#include "stdafx.h"
#include "WidgetCamera.h"

#include "FormMain.h"
#include "FileDlgUtil.h"



WidgetCamera::WidgetCamera(QWidget *parent)
	: QWidget(parent)
{
	ui.setupUi(this);
}

WidgetCamera::~WidgetCamera()
{

}

void WidgetCamera::setMainForm(FormMain* mainFrm_)
{
	mainFrm = mainFrm_;
}

void WidgetCamera::focusList()
{
	ui.listCamera->setFocus();
}

void WidgetCamera::on_pushButtonAddCameraRecord_clicked()
{
	mainFrm->m_View3d.RecordCamera();

	ui.listCamera->addItem( QString::number(ui.listCamera->count()) );

	mainFrm->updateView_3D();
}

void WidgetCamera::on_pushButtonDeleteCameraRecord_clicked()
{
	int idx = ui.listCamera->currentRow();
	if (idx < 0)
		return;

	mainFrm->m_View3d.RemoveRecordedCamera(idx);

	for (int i = idx+1; i < ui.listCamera->count(); ++i)
	{
		ui.listCamera->item(i)->setText(QString::number(i - 1));
	}

	ui.listCamera->takeItem(idx);

	mainFrm->updateView_3D();
}

//! Jʒu@\gp̃Aj[VL
void WidgetCamera::on_checkCameraAnimation_toggled(bool checked)
{
}

void WidgetCamera::on_pushCameraRecordClear_clicked()
{
	mainFrm->m_View3d.ClearRecordedCamera();

	ui.listCamera->clear();

	mainFrm->updateView_3D();
}

void WidgetCamera::on_listCamera_itemDoubleClicked(QListWidgetItem *item)
{
	int idx = ui.listCamera->currentRow();
	if (idx < 0)
		return;

	mainFrm->m_View3d.MoveToRecordedCamera(idx, ui.checkCameraAnimation->isChecked());
}

void WidgetCamera::on_checkEnableCamerSeq_toggled(bool checked)
{
	mainFrm->m_Scene.m_Camera.m_EnableSeqence = checked;
}

void WidgetCamera::on_buttonLoadCameraSeq_clicked()
{
	FileDlgFilterList exts;
	exts.Add("Collada", "dae");

	QString filter = FileDlgUtil::ExtListToDlgFilter("Geometry", exts);
	QString title = "Open Camera seq by collada";
	QString path = mainFrm->GetFilePathFromOpenDlg("", filter);

	if (path.isEmpty())
		return;

	mainFrm->m_Scene.LoadCameraSeq(path.toLocal8Bit().data());

	mainFrm->ResetSequenceSliderRange();

	mainFrm->updateView_All();
}

void WidgetCamera::on_buttonClearCameraSeq_clicked()
{
	mainFrm->m_Scene.m_Camera.m_SeqTrans.Clear();
	mainFrm->ResetSequenceSliderRange();
}

bool WidgetCamera::OpenCameraFile(const QString& path)
{
	std::string fname = path.toLocal8Bit().data();

	if (!mainFrm->m_View3d.m_CameraRecord.LoadCamera(fname.c_str()))
		return false;

	ui.listCamera->blockSignals(true);
	ui.listCamera->clear();
	for (size_t i = 0; i < mainFrm->m_View3d.m_CameraRecord.m_Records.size(); ++i)
	{
		ui.listCamera->addItem( QString::number(i) );
	}
	ui.listCamera->blockSignals(false);

	return true;
}
