#pragma once

#include <QWidget>
#include "ui_ViewConfigDlg.h"
#include "View3DConfig.h"


class ViewConfigDlg : public QWidget
{
	Q_OBJECT

public:
	ViewConfigDlg(QWidget *parent = 0);
	~ViewConfigDlg();

	void InitializeConfigDlg(View3DConfig* config);
	void UpdateValueLabels(void);

signals:
	void ConfigChanged();

protected:
	virtual void keyPressEvent(QKeyEvent *e);

private slots:
	void on_sliderPointSize_valueChanged(int value);
	void on_sliderNormalLen_valueChanged(int value);
	void on_sliderIndexLine_valueChanged(int value);

private:
	float GetNormalLenValue(void) const;
	float GetIndexLineLen(void) const;

private:
	Ui::ViewConfigDlg ui;

private:
	View3DConfig* m_Config;
};
