varying vec3 v_position;

uniform sampler2D tex_color;
uniform sampler2D tex_depth;


void main (void)
{
	float tx = v_position.x * 0.5 + 0.5;
	float ty = v_position.y * 0.5 + 0.5;
	vec4 uv = vec4(tx, ty, 0.0, 1.0);

	float d = texture2DProj(tex_depth, uv).x;

	float h = 0.5;
	float f = 1.0;

	if (d < 0.0)
		gl_FragColor = vec4(0, 0, 0, 1);
	else if (d < 0.1)
		gl_FragColor = vec4(h, 0, 0, 1);
	else if (d < 0.2)
		gl_FragColor = vec4(f, 0, 0, 1);
	else if (d < 0.3)
		gl_FragColor = vec4(0, h, 0, 1);
	else if (d < 0.4)
		gl_FragColor = vec4(0, f, 0, 1);
	else if (d < 0.5)
		gl_FragColor = vec4(0, 0, h, 1);
	else if (d < 0.6)
		gl_FragColor = vec4(0, 0, f, 1);
	else if (d < 0.7)
		gl_FragColor = vec4(0, h, h, 1);
	else if (d < 0.8)
		gl_FragColor = vec4(0, f, f, 1);
	else if (d < 0.9)
		gl_FragColor = vec4(h, 0, h, 1);
	else if (d < 1.0)
		gl_FragColor = vec4(f, 0, f, 1);
	else
		gl_FragColor = vec4(1, 1, 1, 1);
}
