#pragma once

#include <windows.h>
#include <gl/gl.h>

#include <QtGui>
#include <QMainWindow>

#include <QtOpenGL/qgl.h>

#include "QtViewBase.h"

#include <QGestureEvent>



class MyGLWidget : public QGLWidget
{
	Q_OBJECT

public:
	static const int DEFALUT_TIMER_INTERVAL = 20;


public:
	MyGLWidget( QWidget* parent = 0 );

	void SetViewer( QtViewBase* viewer );

	void ActivateGesture(void);

	void StartAnimation(void);
	void StopAnimation(void);
	bool AnimationRunning(void) const;
	int GetAnimationInterval(void) const;
	void SetAnimationInterval(int interval);


protected:
	void resizeGL(int width , int height );
	void paintGL(void);

	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseReleaseEvent(QMouseEvent *e);
	virtual void mouseDoubleClickEvent(QMouseEvent *e);
	virtual void mouseMoveEvent(QMouseEvent *e);
	virtual void moveEvent(QMoveEvent *e);

	virtual void wheelEvent(QWheelEvent *e);

	virtual void keyPressEvent(QKeyEvent *e);
	virtual void keyReleaseEvent(QKeyEvent *e);

	bool IsEnableMouseEvent(void) const;

	virtual bool event(QEvent *event);
	bool gestureEvent(QGestureEvent *event);

	const char* GestureState(QGesture* g) const;

	void swipeTriggered(QSwipeGesture *gesture);
	void panTriggered(QPanGesture *gesture);
	void pinchTriggered(QPinchGesture *gesture);


protected:
	QtViewBase* m_View;

	QTimer m_RenderTimer;

	bool m_IsOnPan;
	bool m_IsOnPinch;


signals:
	void OnGLPaint(void);

	void OnMousePress(QMouseEvent *e);
	void OnMouseRelease(QMouseEvent *e);
	void OnMouseDoubleClick(QMouseEvent *e);
	void OnMouseMove(QMouseEvent *e);
};
