#pragma once

#include "ShaderLibrary.h"

#include "MyGLWidget.h"

#include <QMainWindow>


namespace Ui
{
	class FormCustomShader;
}

class FormCustomShader : public QMainWindow
{
	Q_OBJECT

signals:
	void ShaderBuild();

public:
	explicit FormCustomShader(QWidget *parent = 0);
	~FormCustomShader();

	void SetShaderLibrary(ShaderLibrary* lib);
	void SetParentWidget(MyGLWidget* widget);

	void LoadOrSetDefaultCode(void);

protected:
	virtual void keyPressEvent(QKeyEvent *e);

private:
	QString GetDefaultVertFilename(void) const;
	QString GetDefaultFragFilename(void) const;
	QString GetShaderDir(void) const;

private slots:
	void on_actionBuild_triggered();

	void on_actionReloadVert_triggered();
	void on_actionReloadFrag_triggered();

	void on_actionSaveVert_triggered();
	void on_actionSaveFrag_triggered();

	void on_actionResetVert_triggered();
	void on_actionResetFrag_triggered();

private:
	Ui::FormCustomShader *ui;

	ShaderLibrary* m_ShaderLib;

	MyGLWidget* m_ParentWidget;
};
