#include "stdafx.h"
#include "ShaderUtil.h"

#include <LibTest/DebugStream.h>



bool ShaderUtil::InitShaderStd(lib_gl::GlslProgram& shader, const std::string& frag_filename, const std::string& vert_filename)
{
	lib_gl::GlslShader vert;
	if (!vert.CreateFromFile(GL_VERTEX_SHADER, vert_filename.c_str()))
	{
		LibTest::dout << "vertex shader compile failed ----------------------------------" << std::endl;
		LibTest::dout << vert.GetLastCompileStatus();
		LibTest::dout << "---------------------------------------------------------------" << std::endl;
		assert(false);
		return false;
	}

	lib_gl::GlslShader frag;
	if (!frag.CreateFromFile(GL_FRAGMENT_SHADER, frag_filename.c_str()))
	{
		LibTest::dout << "fragment shader compile failed --------------------------------" << std::endl;
		LibTest::dout << frag.GetLastCompileStatus();
		LibTest::dout << "---------------------------------------------------------------" << std::endl;
		assert(false);
		return false;
	}

	if (!shader.Create( vert , frag ))
	{
		LibTest::dout << shader.GetLastLinkStatus();
		assert(false);
		return false;
	}

	return true;
}
