#include "stdafx.h"
#include "QEnv.h"

#include <QProcess>



namespace qut
{


QString QEnv::GetEnvParam(QString name)
{
	QStringList envs = QProcess::systemEnvironment();
	for (const QString& s : envs)
	{
		int split_pos = s.indexOf("=");
		if (split_pos == -1)
			continue;

		QString name = s.left(split_pos);
		QString param = s.mid(split_pos + 1);

		if (s.left(5) == name)
			return param;
	}

	return QString("");
}


}
