#pragma once

#include <iostream>

#include <C2/graph/color.h>
#include <C2/graph/RawImage.h>

#include "HdrFileHeader.h"


namespace lib_graph
{

namespace hdr
{


class HdrImageLoader
{
public:
	bool Load( lib_graph::RawImage4b& img , const char* filename );
	bool Load( lib_graph::RawImage4b& img , std::istream& ifs );
	bool Load( lib_graph::RawImage3f& img , const char* filename );
	bool Load( lib_graph::RawImage3f& img , std::istream& ifs );

private:
	bool LoadToHeader( std::istream& ifs , std::string& s );
	bool LoadHeader( std::istream& ifs , HdrFileHeader& header , std::string& s );
};


}

}
