#pragma once

namespace util
{


template<typename SrcContainerType>
class container_cast_t
{
public:
	container_cast_t(SrcContainerType& t)
		: m_SrcContainer(&t)
	{}
	
	template<typename DstContainerType>
	operator DstContainerType(void) const
	{
		return DstContainerType( m_SrcContainer->begin() , m_SrcContainer->end() );
	}

private:
	SrcContainerType* m_SrcContainer;
};

template<typename SrcContainerType>
container_cast_t<SrcContainerType> container_cast(SrcContainerType& container)
{
	return container_cast_t<SrcContainerType>( container );
}

template<typename DST,typename SRC>
void container_cast( DST& dst_container , SRC& src_container )
{
	dst_container = DST( src_container.begin() , src_container.end() );
}


}
