#pragma once

#include "../graph/Material.h"
#include "MaterialSetter.h"


namespace lib_gl
{


class Material : public lgr::Material
{
public:
	Material(void);
	Material(const lgr::Material& mat);

	const Material& operator=(const lgr::Material& mat);

public:
	void SetGL( GLenum face_type = GL_FRONT_AND_BACK , bool set_diffuse_to_color = true );
	void GetGL( GLenum face_type = GL_FRONT );
};


class DoublesideMaterial : public lgr::DoublesideMaterial
{
	DoublesideMaterial(void);
	DoublesideMaterial(const lgr::DoublesideMaterial& mat);

	const DoublesideMaterial& operator=(const lgr::DoublesideMaterial& mat);

public:
	void SetGL(void);
	void GetGL(void);
};



inline Material::Material(void)
{
}

inline Material::Material(const lgr::Material& mat)
{
	dynamic_cast<lgr::Material&>(*this) = mat;
}

inline const Material& Material::operator=(const lgr::Material& mat)
{
	dynamic_cast<lgr::Material&>(*this) = mat;
	return *this;
}

//! w肵ʂɃ}eAKp
inline void Material::SetGL( GLenum face_type , bool set_diffuse_to_color )
{
	MaterialSetter::SetGL( *this , face_type , set_diffuse_to_color );
}

//! OpenGL̃Jg}eA擾.
//! GL_FRONT_AND_BACK͎擾łȂ̂Œ
inline void Material::GetGL( GLenum face_type )
{
	MaterialSetter::GetGL( *this , face_type );
}



inline DoublesideMaterial::DoublesideMaterial(void)
{
}

inline DoublesideMaterial::DoublesideMaterial(const lgr::DoublesideMaterial& mat)
{
	dynamic_cast<lgr::DoublesideMaterial&>(*this) = mat;
}

inline const DoublesideMaterial& DoublesideMaterial::operator=(const lgr::DoublesideMaterial& mat)
{
	dynamic_cast<lgr::DoublesideMaterial&>(*this) = mat;
	return *this;
}

//! w肵ʃ}eAKp
inline void DoublesideMaterial::SetGL(void)
{
	MaterialSetter::SetGL( *this );
}

//! OpenGL̃Jg}eA𗼖ʃ}eAIuWFNgɎ擾.
inline void DoublesideMaterial::GetGL(void)
{
	MaterialSetter::GetGL( *this );
}


}
