#pragma once

#include <QWidget>
#include "ui_WidgetObjectList.h"

#include "../LibQtGeoViewerCore/SceneMain.h"


class FormMain;

class WidgetObjectList : public QWidget
{
	Q_OBJECT

public:
	WidgetObjectList(QWidget *parent = 0);
	~WidgetObjectList();

	void setMainForm(FormMain* mainFrm_);

	void RegisterContextMenu(void);

	void focusList(void);

	void SetPrimayrSelectObjectFromScene(void);

	void OnSelectedObjectChanged(int sel_obj, int sel_mesh);

	void AddSelectObjectIdx(int step);

	void FlipVisibleSelectedObject(void);

	Qt::CheckState FilpState(Qt::CheckState state) const;

	void DeleteSelectedObject(void);
	void SetPrimayrSelectObjectToScene(void);

	QTreeWidget* GetTree(void);

	void applyConfig(void);

	void UpdateContextmenuState(void);

	void ResizeObjectTreeColumns(void);

	void InitObjectListHeader(void);
	void InitTreConfig(void);

	QTreeWidgetItem* CreateObjectTreeNode(const geom::GeomObject& obj) const;
	QTreeWidgetItem* CreateMeshBufNode(const geom::GeomObject& obj, const MeshBuf& mbuf, int idx) const;

	void PushbackTreeNode(QTreeWidget* tree, QTreeWidgetItem *node);

	void RebuildObjectList(void);
	void OnDoneAddGeom(void);
	void SyncViewMark(void);
	void ClearTree(void);

	int getSelObjIdx();
	int getSelObjIdxWhenSelObjNode();
	void removeObject(int objectIdx);

private:
	void addAllObjectsToTree(void);
	void initUVViewOnUpdateList(void);

	void reloadSelObject(void);

private slots:
	void on_treeObjects_itemChanged( QTreeWidgetItem * item, int column);
	void on_treeObjects_currentItemChanged(QTreeWidgetItem * current, QTreeWidgetItem * previous);
	void on_checkShowOnlySelect_toggled(bool checked);

	void on_pushDeleteSelectedObject_clicked();
	void on_buttonClearAllGeoms_clicked();

	void on_actionTreeCollapseAll_triggered();
	void on_actionTreeExpandAll_triggered();

	void on_actionSelObjectVisible_triggered();
	void on_actionSelObjectVertexOnlyMode_triggered();
	void on_actionSelObjectTriangulate_triggered();

	void on_actionSelObjectResetNormal_triggered();

	void on_actionSelObjectReload_triggered();
	void on_actionSelObjectOpenDir_triggered();
	void on_actionSelObjectFlipNormal_triggered();
	void on_actionSelObjectFlipFace_triggered();
	void on_actionActionSelObjectShowOnlyOnce_triggered();
	void on_actionSelObjectDelete_triggered();

	void on_buttonReloadSel_clicked();

private:
	Ui::WidgetObjectList ui;

	FormMain* mainFrm;
};
