#include "stdafx.h"
#include "PathInfo.h"
#include "BuildInfo.h"

#include <QApplication>
#include <QDir>
#include <QStandardPaths>

#include <Qt5Utility/QGui.h>

static char* LAYOUT_CONFIG      = "layout.dat";
static char* POSITION_CONFIG    = "position.ini";
static char* WINLAYOUT_CONFIG   = "window_layout.dat";
static char* GUI_CONFIG         = "gui_config.xml";
static char* CAMERA_RECORD      = "camera_record.camera";

static char* DEFAULT_CONFIG_DIR = "/Data/DefaultConfig/";


QString PathInfo::GetMyDocDirPath(void)
{
	QStandardPaths::StandardLocation loc_type;
	loc_type = QStandardPaths::DocumentsLocation;

	return QStandardPaths::writableLocation(loc_type);
}

QString PathInfo::GetLocalAppDirPath(void)
{
	QStandardPaths::StandardLocation loc_type;
	loc_type = QStandardPaths::ConfigLocation;

	return QStandardPaths::writableLocation(loc_type);
}

QString PathInfo::GetTempDirPath(void)
{
	QStandardPaths::StandardLocation loc_type;
	loc_type = QStandardPaths::TempLocation;

	return QStandardPaths::writableLocation(loc_type);
}


QString PathInfo::GetAppTmpPath(void)
{
	return GetLocalAppDirPath() + "/Tmp/";
}

QString PathInfo::GetConfigDirPath(void)
{
	if (BUILDMODE_RELEASE)
		return GetLocalAppDirPath() + "/Config/";
	else
		return GetLocalAppDirPath() + "/Config_Test/";
}

QString PathInfo::GetPosConfigFilePath(void)
{
	return GetConfigDirPath() + POSITION_CONFIG;
}

QString PathInfo::GetLayoutConfigFilePath(void)
{
	return GetConfigDirPath() + LAYOUT_CONFIG;
}

QString PathInfo::GetDefaultLayoutConfigFilePath(void)
{
	return GetAppDirPath() + DEFAULT_CONFIG_DIR + LAYOUT_CONFIG;
}

QString PathInfo::GetWindowLayoutConfigFilePath(void)
{
	return GetConfigDirPath() + WINLAYOUT_CONFIG;
}

QString PathInfo::GetDefaultWindowLayoutConfigFilePath(void)
{
	return GetAppDirPath() + DEFAULT_CONFIG_DIR + WINLAYOUT_CONFIG;
}

QString PathInfo::GetGuiConfigFilePath(void)
{
	return GetConfigDirPath() + GUI_CONFIG;
}

QString PathInfo::GetDefaultGuiConfigFilePath(void)
{
	return GetAppDirPath() + DEFAULT_CONFIG_DIR + GUI_CONFIG;
}

QString PathInfo::GetCameraLogFilePath(void)
{
	return GetConfigDirPath() + CAMERA_RECORD;
}

QString PathInfo::GetAppDirPath(void)
{
	return QApplication::applicationDirPath();
}

QString PathInfo::GetAsscEditorPath(void)
{
	return GetAppDirPath() + "/ChangeExtDefaultApp.exe";
}

QString PathInfo::GetWebDownloaderPath(void)
{
	return GetAppDirPath() + "/WebClientUtil.exe";
}

QString PathInfo::GetMatCapPresetDirPath(void)
{
	return GetAppDirPath() + "/Data/matcaps/";
}

QString PathInfo::GetEnvmapPresetDirPath(void)
{
	return GetAppDirPath() + "/Data/Envmap/";
}

QString PathInfo::GetShaderDirPath(void)
{
	return GetAppDirPath() + "/ShaderCode/Mesh/";
}

QString PathInfo::GetPostprocCodeDirPath(void)
{
	return GetAppDirPath() + "/ShaderCode/Postproc/";
}

void PathInfo::CreateConfiDirIfNotExist(void)
{
	QString config_dir = GetConfigDirPath();
	if (!QDir().exists(config_dir))
		QDir().mkpath(config_dir);
}

void PathInfo::OpenAppDir(void)
{
	QGui::ShowDirectory(GetAppDirPath());
}

void PathInfo::OpenConfigDir(void)
{
	QGui::ShowDirectory(GetConfigDirPath());
}
