#include "stdafx.h"
#include "GeomReaderBuilder.h"

#include "Format/Pmd/PmdLoader.h"
#include "Format/Mqo/MqoLoader.h"
#include "Format/Ply/PlyLoader.h"
#include "Format/Stl/StlLoader.h"
#include "Format/Obj/ObjLoader.h"
#include "Format/X/XFileLoader.h"
#include "Format/DaeLoader.h"

using namespace geom;



GeomFileReader* GeomReaderBuilder::Create(geom::GeomFileFormat fmt)
{
	switch(fmt)
	{
	case GeomFileFormat::Obj     : return new ObjLoader();
	case GeomFileFormat::Stl     : return new StlLoader();
	case GeomFileFormat::Ply     : return new PlyLoader();
	case GeomFileFormat::Mqo     : return new MqoLoader();
	case GeomFileFormat::Collada : return new DaeLoader();
	case GeomFileFormat::Pmd     : return new PmdLoader();
	case GeomFileFormat::XFile   : return new XFileLoader();
	default:
		assert(false);
		return false;
	}
}
