#include "stdafx.h"
#include "BmpMarker.h"



void BmpMarker::DrawBmpCross(const lm::vec3f& p)
{
	int Prev_GL_UNPACK_ALIGNMENT  = glGetInteger( GL_UNPACK_ALIGNMENT  );
	int Prev_GL_PACK_ALIGNMENT    = glGetInteger( GL_PACK_ALIGNMENT    );
	int Prev_GL_UNPACK_ROW_LENGTH = glGetInteger( GL_UNPACK_ROW_LENGTH );

	glPixelStorei( GL_UNPACK_ALIGNMENT , 1 );

	static const GLubyte bitmap[8] =
	{
		0x18, // 00011000
		0x18, // 00011000
		0x18, // 00011000
		0xff, // 11111111
		0xff, // 11111111
		0x18, // 00011000
		0x18, // 00011000
		0x18  // 00011000
	};

	glRasterPos3fv(p.v());
	glBitmap(8, 8, 4, 4, 0, 0, bitmap);

	glPixelStorei( GL_UNPACK_ALIGNMENT  , Prev_GL_UNPACK_ALIGNMENT  );
	glPixelStorei( GL_PACK_ALIGNMENT    , Prev_GL_PACK_ALIGNMENT    );
	glPixelStorei( GL_UNPACK_ROW_LENGTH , Prev_GL_UNPACK_ROW_LENGTH );
}
