#pragma once

#include <vector>
#include <QString>


namespace qut
{


class PluginArgs
{
public:
	PluginArgs(int argc, char *argv[]);

	int& GetArgc(void);
	char** GetArgv(void);

private:
	void InitStdArgumentsCopy(int argc, char *argv[]);

	bool IsExistLocalCopy(char *argv[]);

	QString GetStartupPath(char *argv[]);

	QString GetPluginDirFromEnv(void);

	void AddReferenceToSDK(void);

private:
	int argc_ext;
	std::vector<char*> arg_ext;

	std::string plugin_opt;
	std::string plugin_path;
};


}
