#pragma once

#include <utility>
#include <vector>


namespace util
{


//! Reiz_.
//! Rei̒Pɗp. ͈.
template<typename T>
class container_holder
{
public:
	container_holder(void) {}
	
	container_holder<T>& operator()(const T& val)
	{
		return push_back(val);
	}

	container_holder<T>& operator<<(const T& val)
	{
		return push_back(val);
	}

	container_holder<T>& push_back(const T& val)
	{
		m_vec.push_back(val);
		return *this;
	}

	void clear(void)
	{
		m_vec.clear();
	}

	template<typename DstContainer>
	operator DstContainer() const
	{
		return DstContainer( m_vec.begin() , m_vec.end() );
	}

private:
	std::vector<T> m_vec;
};


// ------------------------------------------------------------------------------------------------
// list_of
template<typename T>
container_holder<T> list_of()
{
	container_holder<T> _holder;
}

template<typename T>
container_holder<T> list_of(const T& t)
{
	container_holder<T> _holder;
	return _holder(t);
}


// ------------------------------------------------------------------------------------------------
// pair_of
template<typename T,typename U>
std::pair<T,U> pair_of( const T& t , const U& u )
{
	return std::pair<T,U>( t , u );
}


}
