#pragma once

#include <cassert>

#include "GlInclude.h"


namespace lib_gl
{


//! eNX`IuWFNgNX.
class GlTextureObject
{
public:
	GlTextureObject(void);
	GlTextureObject( GLenum i_TextureType );

	~GlTextureObject(void);

	// eNX`IuWFNgID̐Aj
	bool GenerateTexture(void);
	void ReleaseTexture(void);

	// eNX`IuWFNgoCh
	void Bind(void);

	// eNX`IuWFNgID擾.
	const GLuint& GetID(void) const;

	// eNX``ݒ, 擾.
	GLenum GetTextureType(void) const { return m_TextureType; }
	void SetTextureType(GLenum i_type){ m_TextureType = i_type; }

	// eNX`IuWFNgCfbNXZbgĂ邩mF
	bool IsValid(void) const { return m_ObjectID != 0; }

private:
	GlTextureObject(const GlTextureObject&) {}
	void operator=(const GlTextureObject&) {}

protected:
	GLuint m_ObjectID;     //!< eNX`IuWFNgID.
	GLenum m_TextureType;  //!< eNX`̎. GL_TEXTURE_[123]D.
};



// ---------------------------------------------------------------------------

inline GlTextureObject::GlTextureObject(void)
{
	m_ObjectID = 0;
	m_TextureType = GL_TEXTURE_2D;
}

//! @param[in] i_TextureType - eNX`̎. GL_TEXTURE_[123]D.
inline GlTextureObject::GlTextureObject( GLenum i_TextureType )
{
	m_ObjectID = 0;
	m_TextureType = i_TextureType;
}

inline GlTextureObject::~GlTextureObject(void)
{
	ReleaseTexture();
}

inline bool GlTextureObject::GenerateTexture(void)
{
	glGenTextures( 1 , &m_ObjectID );

	return true;
}

inline void GlTextureObject::ReleaseTexture(void)
{
	if( m_ObjectID != 0 )
	{
		glDeleteTextures( 1 , &m_ObjectID );
		m_ObjectID = 0;
	}
}

inline void GlTextureObject::Bind(void)
{
	glBindTexture( m_TextureType , m_ObjectID );
}

inline const GLuint& GlTextureObject::GetID(void) const
{
	return m_ObjectID;
}


}
