#include "StdAfx.h"

yahash::yahash(TCHAR* fp) : file(fp)
{
}


yahash::~yahash(void)
{
}


std::string yahash::getDigest(CryptoPP::HashTransformation* hashenc,
			      byte* digest, int digest_len)
{
  std::ostringstream oret;
  int max_buff = 8192;
  byte buff[8192];
  boost::filesystem::path p(file);
  if(boost::filesystem::exists(p)) {
    HANDLE hl = CreateFile(file,
			   GENERIC_READ,
			   FILE_SHARE_READ,
			   NULL,
			   OPEN_EXISTING,
			   FILE_FLAG_SEQUENTIAL_SCAN,
			   NULL);
    if(hl != INVALID_HANDLE_VALUE) {
      BOOL ret;
      DWORD buff_readsize;
      do {
	memset(buff, 0, max_buff);
	buff_readsize = 0;
	ret = ReadFile(hl,
		       buff,
		       max_buff,
		       &buff_readsize,
		       NULL);
	hashenc->Update(buff, buff_readsize);
      } while(ret != 0 && buff_readsize != 0);
    }
    CloseHandle(hl);
    hashenc->Final(digest);
    for(int i=0; i < digest_len; i++) {
      oret << std::setw(2) << std::setfill('0') << std::hex << (int)(digest[i]);
    } 
  }
  return oret.str();
}

std::map<int,std::string> yahash::getHash(std::vector<int> types)
{
  std::map<int, std::string> ret;

  CryptoPP::SHA1 sha1cpp;
  byte sha1digest[20];
  CryptoPP::SHA256 sha256cpp;
  byte sha256digest[32];

  HMODULE md5_module = LoadLibraryW(L"Cryptdll.dll");
  typedef struct
  {
    ULONG         i[2];
    ULONG         buf[4];
    unsigned char in[64];
    unsigned char digest[16];
  } MD5_CTX;
  typedef void (WINAPI *LPFNMD5INIT)(MD5_CTX *);
  typedef void (WINAPI *LPFNMD5UPDATE)(MD5_CTX *, const unsigned char *, unsigned int);
  typedef void (WINAPI *LPFNMD5FINAL)(MD5_CTX *);
  LPFNMD5INIT md5init = (LPFNMD5INIT)GetProcAddress(md5_module, "MD5Init");
  LPFNMD5UPDATE md5update = (LPFNMD5UPDATE)GetProcAddress(md5_module, "MD5Update");
  LPFNMD5FINAL md5final = (LPFNMD5FINAL)GetProcAddress(md5_module, "MD5Final");

  MD5_CTX md5ctx;
  md5init(&md5ctx);

  int max_buff = 4098;
  byte buff[4098];
  boost::filesystem::path p(file);
  if(boost::filesystem::exists(p)) {
    HANDLE hl = CreateFile(file,
			   GENERIC_READ,
			   FILE_SHARE_READ,
			   NULL,
			   OPEN_EXISTING,
			   FILE_FLAG_SEQUENTIAL_SCAN,
			   NULL);
    if(hl != INVALID_HANDLE_VALUE) {
      BOOL ret;
      DWORD buff_readsize;
      do {
	memset(buff, 0, max_buff);
	buff_readsize = 0;
	ret = ReadFile(hl,
		       buff,
		       max_buff,
		       &buff_readsize,
		       NULL);

	for(unsigned int i=0; i < types.size(); i++) {
	  if(types[i] == sha1) {
	    sha1cpp.Update(buff, buff_readsize);
	  } else if(types[i] == sha256) {
	    sha256cpp.Update(buff, buff_readsize);
	  } else {
	    md5update(&md5ctx, buff, buff_readsize);
	  }
	}
      } while(ret != 0 && buff_readsize != 0);
    }
    CloseHandle(hl);

    for(unsigned int i=0; i < types.size(); i++) {
      if(types[i] == sha1) {
	std::ostringstream oret;
	sha1cpp.Final(sha1digest);
	for(int j=0; j < 20; j++) {
	  oret << std::setw(2) << std::setfill('0') << std::hex << (int)(sha1digest[j]);
	}
	ret[types[i]] = oret.str();
      } else if(types[i] == sha256) {
	std::ostringstream oret;
	sha256cpp.Final(sha256digest);
	for(int j=0; j < 32; j++) {
	  oret << std::setw(2) << std::setfill('0') << std::hex << (int)(sha256digest[j]);
	}
	ret[types[i]] = oret.str();
      } else {
	std::ostringstream oret;
	md5final(&md5ctx);
	for(int j=0; j < 16; j++) {
	  oret << std::setw(2) << std::setfill('0') << std::hex << (int)(md5ctx.digest[j]);
	}
	ret[types[i]] = oret.str();
      }
    }
  }

  FreeLibrary(md5_module);
  return ret;
}
