#pragma once

class yasqlite3db
{
public:
        yasqlite3db(_TCHAR*, _TCHAR*);
	virtual ~yasqlite3db(void);
	
	virtual std::string getUUID();
	virtual boolean setUUID(std::string uuid);
	
	virtual boolean existUUID(std::string uuid);

	virtual std::map<int, std::string> getHash();
	virtual boolean setHash(int, std::string);
	virtual std::vector<int> getHashType();
	
	virtual boolean updateFilepathByUUID(_TCHAR* filepath, std::string uuid);
	virtual boolean deleteAllHash(std::string uuid);
	
private:
	boost::filesystem::path filepath;
	boost::filesystem::path dbfilepath;
	boost::filesystem::path escaped_filepath;
	tstring tfilepath;
	tstring tdbfilepath;
	TCHAR* filename;
	TCHAR* dbfilename;
	sqlite3pp* db;
	std::string uuid;

	std::string escape_sqlite3(const std::string& query);
	std::wstring escape_sqlite3w(const std::wstring& query);
	tstring escape_sqlite3t(const tstring& query);
};
