
#include "StdAfx.h"

yasqlite3db::yasqlite3db(_TCHAR* _filename, _TCHAR* _dbfilename) : dbfilename(_dbfilename),
								   filename(_filename),
								   filepath(boost::filesystem::path(_filename)),
								   dbfilepath(boost::filesystem::path(_dbfilename)),
								   uuid(std::string("")),
								   tfilepath(tstring(_filename)),
								   tdbfilepath(tstring(_dbfilename))
{
  escaped_filepath =  boost::filesystem::path(escape_sqlite3t(tfilepath));
  db = new sqlite3pp(dbfilepath.string().c_str());
  
  int sqlrc = db->exe("select uuid from uuid");
  if(sqlrc == SQLITE_OK) {
    // found uuid
    //uuid = db->vdata.at(0);
  } else {
    // not found uuid by filepath
    uuid = std::string("");
    // create tables
    sqlrc = db->exe("create table uuid (filepath text, uuid text, primary key(uuid,filepath))");
    if(sqlrc == SQLITE_ERROR) {
#ifdef _DEBUG
      std::cerr << "failed to crete table uuid." << std::endl;
#endif
    }
    sqlrc = db->exe("create table hash (uuid text, type text, value text, primary key(uuid,type))");
    if(sqlrc == SQLITE_ERROR) {
#ifdef _DEBUG
      std::cerr << "failed to crete table hash." << std::endl;
#endif
    }
    sqlrc = db->exe("create table hashtype (uuid text, type integer, primary key(uuid,type))");
    if(sqlrc == SQLITE_ERROR) {
#ifdef _DEBUG
      std::cerr << "failed to crete table uuid." << std::endl;
#endif
    }

    // set the initial default hash types.
    std::ostringstream s;
    s << "insert into hashtype (uuid,type) values ('*'," << md5 << ")";
    sqlrc = db->exe(s.str());
    if(sqlrc == SQLITE_ERROR) {
#ifdef _DEBUG
      std::cerr << "failed to insert hash table." << std::endl;
#endif
    }
    std::ostringstream ss;
    ss << "insert into hashtype (uuid,type) values ('*'," << sha1 << ")";
    sqlrc = db->exe(ss.str());
    if(sqlrc == SQLITE_ERROR) {
#ifdef _DEBUG
      std::cerr << "failed to insert hash table." << std::endl;
#endif
    }
  }
  db->clear();
}

yasqlite3db::~yasqlite3db(void)
{
  delete db;
}

std::string yasqlite3db::getUUID()
{
  std::ostringstream s;
  s << "select uuid from uuid where filepath = '" << escaped_filepath << "'";
#ifdef _DEBUG
  std::cout << "sql: " << s.str() << std::endl;
#endif
  int rc = db->exe(s.str());
  if(rc == SQLITE_OK && db->vdata.size() > 0) {
    uuid = db->vdata.at(0);
  } else {
#ifdef _DEBUG
    std::cerr << "failed to execute sql" << std::endl;
#endif
  }
  db->clear();
#ifdef _DEBUG
  std::cerr << "getUUID(): " << uuid << std::endl;
#endif
  return uuid;
}

boolean yasqlite3db::setUUID(std::string _uuid)
{
  boolean ret = false;
  uuid = _uuid;
  std::ostringstream s;
  
  s << "insert into uuid (uuid,filepath) values ('" << uuid << "','" << escaped_filepath << "')";
#ifdef _DEBUG
  std::cout << "exec sql: " << s.str() << std::endl;
#endif
  int rc = db->exe(s.str());
  if(rc == SQLITE_OK) {
    ret = true;
  } else {
    std::ostringstream s;
    s << "update uuid set uuid = '" << uuid << "' where filepath = '" << escaped_filepath << "'";
#ifdef _DEBUG
    std::cerr << "exec sql: " << s.str() << std::endl;
#endif
    int rc = db->exe(s.str());
    if(rc == SQLITE_OK) {
      ret = true;
    }
  }
  db->clear();
  return ret;
}

boolean yasqlite3db::existUUID(std::string uuid)
{
  boolean ret = false;
  std::ostringstream s;
  s << "select uuid from uuid where uuid = '" << uuid << "'";
  int rc = db->exe(s.str());
  if(rc == SQLITE_OK && db->vdata.size() > 0) {
    ret = true;
  }
  db->clear();
  return ret;
}

boolean yasqlite3db::updateFilepathByUUID(_TCHAR* _filepath, std::string _uuid)
{
  boolean ret = false;
  std::ostringstream s;

  boost::filesystem::path _filepath_escaped(escape_sqlite3t(tfilepath));
  s << "update uuid set filepath = '" << _filepath_escaped << "' where uuid = '" << _uuid << "'";
#ifdef _DEBUG
  std::cerr << "sql: " << s.str() << std::endl;
#endif
  int rc = db->exe(s.str());
  if(rc == SQLITE_OK) {
    filename = _filepath;
    filepath = boost::filesystem::path(filename);
    tfilepath = tstring(filename);
    escaped_filepath =  boost::filesystem::path(escape_sqlite3t(tfilepath));
    uuid = _uuid;
    ret = true;
  }
  db->clear();
  return ret;
}

/**
 * 
 * @return std::map of type and value.
 **/
std::map<int, std::string> yasqlite3db::getHash()
{
	std::map<int, std::string> hash;
	std::ostringstream s;
	s << "select type,value from hash where uuid = '" << uuid << "'";
#ifdef _DEBUG
	std::cerr << "sql: " << s.str() << std::endl;
#endif
	int rc = db->exe(s.str());
	if(rc == SQLITE_OK && db->vdata.size() > 0) {
	  for(size_t i=0; i < db->vdata.size(); i++) {
	    int type = atoi(db->vdata.at(i).c_str());
	    i++;
	    hash[type] = db->vdata.at(i);
	  }
	}
	db->clear();
	return hash;
}

boolean yasqlite3db::setHash(int type, std::string hash_value)
{
  boolean ret = false;
  std::ostringstream s;
  s << "insert into hash (uuid,type,value) values ('" << uuid << "'," << type << ",'" << hash_value << "')";
#ifdef _DEBUG
  std::cerr << "sql: " << s.str() << std::endl;
#endif
  int rc = db->exe(s.str());
  if(rc == SQLITE_OK) {
    ret = true;
  } else {
    std::ostringstream s;
    s << "update hash set value = '" << hash_value << "' where uuid = '" << uuid << "' and type = " << type;
#ifdef _DEBUG
    std::cout << "sql: " << s.str() << std::endl;
#endif
    rc = db->exe(s.str());
    if(rc == SQLITE_OK) {
      ret = true;
    }
  }
  db->clear();
  return ret;
}

std::vector<int> yasqlite3db::getHashType()
{
  std::vector<int> ret;
  std::ostringstream s;
  s << "select type from hashtype where uuid = '" << uuid << "'";
#ifdef _DEBUG
  std::cerr << "sql: " << s.str() << std::endl;
#endif
  int rc = db->exe(s.str());
  if(rc == SQLITE_OK && db->vdata.size() > 0) {
    for(size_t i=0; i < db->vdata.size(); i++) {
      ret.push_back(atoi(db->vdata.at(i).c_str()));
    }
  } else if(rc == SQLITE_OK && db->vdata.size() == 0) {
    rc = db->exe("select type from hashtype where uuid = '*'");
    if(rc == SQLITE_OK && db->vdata.size() > 0) {
      for(size_t i=0; i < db->vdata.size(); i++) {
	ret.push_back(atoi(db->vdata.at(i).c_str()));
      }
    }
  }
  db->clear();
  return ret;
}

boolean yasqlite3db::deleteAllHash(std::string uuid)
{
	boolean ret = false;
	return ret;
}

// utility: escape 
std::string yasqlite3db::escape_sqlite3(const std::string& query)
{
  std::string s = query;
  for(size_t i=0; i<query.size(); i+=2) {
    i = s.find("'", i);
    if(i < 0) {
      break;
    }
    s.replace(i, 1, "''");
  }
  return s;
}

std::wstring yasqlite3db::escape_sqlite3w(const std::wstring& query)
{
  std::wstring s = query;
  for(size_t i=0; i<query.size(); i+=2) {
    i = s.find(L"'", i);
    if(i < 0) {
      break;
    }
    s.replace(i, 1, L"''");
  }
  return s;
}

tstring yasqlite3db::escape_sqlite3t(const tstring& query)
{
  tstring s = query;
  for(size_t i=0; i < query.size(); i=i+2) {
    i = s.find(_T("'"), i);
    if(i < 0 || i > query.size()) { // might be bug of std::wstring::find()
      break;
    }
    s.replace(i, 1, _T("''"));
  }
  return s;
}

