#include "StdAfx.h"

yaprops::yaprops(TCHAR* f) : filename(f), pPropSetStg(NULL), pPropStg(NULL), fmtid(FMTID_SummaryInformation)
{
}

yaprops::~yaprops(void)
{
}

HRESULT yaprops::getIPropertySetStorage(void)
{
	HRESULT hr;
	IPropertySetStorage* pPropSetStg = NULL;
	
	hr = StgOpenStorageEx(this->filename,
		STGM_READWRITE | STGM_SHARE_EXCLUSIVE,
		STGFMT_FILE,
		0,    // preserved. It must be zero.
		NULL, // pointer to STGOPTIONS object
		0,    // preserved. It must be zero.
		IID_IPropertySetStorage,
		reinterpret_cast<void**>(&pPropSetStg));

	this->pPropSetStg = pPropSetStg;
	return hr;
}

HRESULT yaprops::getIPropertySetStorageReader(void)
{
	HRESULT hr;
	IPropertySetStorage* pPropSetStg = NULL;
	
	hr = StgOpenStorageEx(this->filename,
		STGM_READ | STGM_SHARE_EXCLUSIVE,
		STGFMT_FILE,
		0,    // preserved. It must be zero.
		NULL, // pointer to STGOPTIONS object
		0,    // preserved. It must be zero.
		IID_IPropertySetStorage,
		reinterpret_cast<void**>(&pPropSetStg));

	this->pPropSetStg = pPropSetStg;
	return hr;
}


HRESULT yaprops::openIPropertyStorage()
{
	HRESULT hr;
	IPropertyStorage* pPropStg = NULL;
	hr = this->pPropSetStg->Open(fmtid,
		STGM_READWRITE | STGM_SHARE_EXCLUSIVE,
		&pPropStg);

	this->pPropStg = pPropStg;
	return hr;
}

HRESULT yaprops::createIPropertyStorage()
{
	HRESULT hr;
	IPropertyStorage* pPropStg = NULL;
	hr = this->pPropSetStg->Create(fmtid,
		NULL,
		PROPSETFLAG_DEFAULT,
		STGM_CREATE | STGM_READWRITE | STGM_SHARE_EXCLUSIVE,
		&pPropStg);

	this->pPropStg = pPropStg;
	return hr;
}

HRESULT yaprops::readIPropertyStorage()
{
	HRESULT hr;
	IPropertyStorage* pPropStg = NULL;
	hr = this->pPropSetStg->Open(fmtid,
		STGM_READ | STGM_SHARE_EXCLUSIVE,
		&pPropStg);
	
	this->pPropStg = pPropStg;
	return hr;
}


void yaprops::writeMsg(const wchar_t* message) 
{
	HRESULT hr;
	PROPSPEC propspec;
	PROPVARIANT propWrite;

	try {
		hr = getIPropertySetStorage();
		if(FAILED(hr) || this->pPropSetStg == NULL) {
			throw L"Failed to initialize IPropertySetStorage";
		}
		hr = openIPropertyStorage();
		if(FAILED(hr) || this->pPropStg == NULL) {
			hr = createIPropertyStorage();
			if(FAILED(hr) || this->pPropStg == NULL) {
			  throw L"Failed to initialize IPropertyStorage";
			}
		}

		propspec.ulKind = PRSPEC_PROPID;
		propspec.propid = PIDSI_COMMENTS;
		propWrite.vt = VT_LPWSTR; 
		propWrite.pwszVal = (LPWSTR)message;
		hr = this->pPropStg->WriteMultiple(1, &propspec, &propWrite, PID_FIRST_USABLE);
		if(FAILED(hr)) {
		  throw L"Failed to write message";
		}
		hr = this->pPropStg->Commit(STGC_DEFAULT);
		if(FAILED(hr)) {
		  throw L"Failed to commit the write transcation";
		}
	} catch(const WCHAR *pwszError) {
	  std::wcerr << L"NTFS Stream cannot be used: " << pwszError << std::endl;
	  throw pwszError;
	}
	if(this->pPropStg != NULL) {
		this->pPropStg->Release();
		this->pPropStg = NULL;
	}
	if(this->pPropSetStg != NULL) {
		this->pPropSetStg->Release();
		this->pPropSetStg = NULL;
	}
}

const wchar_t* yaprops::readMsg(void)
{
	wchar_t* retmsg;
	HRESULT hr;
	PROPSPEC propspec;
	PROPVARIANT propRead;
	try {
		hr = getIPropertySetStorageReader();
		if(FAILED(hr) || this->pPropSetStg == NULL) {
			throw L"Failed to initialize IPropertySetStorage";
		}
		hr = readIPropertyStorage();
		if(FAILED(hr) || this->pPropStg == NULL) {
		        throw L"Failed to initialize IPropertyStorage";
		}
		
		propspec.ulKind = PRSPEC_PROPID; 
		propspec.propid = PIDSI_COMMENTS;
		hr = this->pPropStg->ReadMultiple(1, &propspec, &propRead);
		if(FAILED(hr)) {
			throw L"Failed to read ReadMultiple";
		}
	} catch(const WCHAR *pwszError) {
		std::wcerr << L"NTFS Stream cannot be used: " << pwszError << std::endl;
		return NULL;
	}
	size_t retmsg_len = 0;
	switch(propRead.vt) {
		case VT_EMPTY:
			retmsg = NULL;
			break;
		case VT_LPSTR:
			// My Windows XP (SP3) reachs here.
			// UNICODE is enabled, but Japanese char throguh the extended panel.
			retmsg = new wchar_t[strlen(propRead.pszVal) + 1];  // '+ 1' is essential for the '\0' terminator.
			mbstowcs_s(&retmsg_len, retmsg, strlen(propRead.pszVal) + 1, propRead.pszVal, _TRUNCATE);
			break;
		case VT_LPWSTR:
			retmsg = (wchar_t*)propRead.pwszVal;
			break;
		default:
			retmsg = L"";
	}
	if(this->pPropSetStg != NULL) {
		this->pPropSetStg->Release();
		this->pPropSetStg = NULL;
	}
	if(this->pPropStg != NULL) {
		this->pPropStg->Release();
		this->pPropStg = NULL;
	}
	return retmsg;
}
