#include "StdAfx.h"

yantfsstream::yantfsstream(TCHAR* _filename) : filename(_filename),
					       filepath(boost::filesystem::path(_filename)),
					       props(new yaprops(_filename))
{
}

yantfsstream::~yantfsstream(void)
{
}

std::string yantfsstream::getUUID()
{
  std::wstring wcmsg;
  const wchar_t* wmsg = props->readMsg();
  if(wmsg == NULL) {
    wcmsg = std::wstring(L"");
  } else {
    wcmsg = std::wstring(wmsg);
  }
  int mbmsg_len = (int)wcmsg.size();
  char* mbmsg = new char[mbmsg_len+1];
  WideCharToMultiByte(CP_ACP,
		      WC_COMPOSITECHECK,
		      wcmsg.c_str(),
		      -1, 
		      mbmsg,
		      mbmsg_len,
		      NULL,
		      NULL);
  mbmsg[mbmsg_len] = '\0';
  std::string ret(mbmsg);
#ifdef _DEBUG
  std::cout << "yanfsstream::getUUID(): ret: " << ret << std::endl;
#endif
  return ret;
}

boolean yantfsstream::setUUID(std::string uuid)
{
  boolean ret = false;
  
  wchar_t* uuid_wc = new wchar_t[uuid.size()+1];
        MultiByteToWideChar(CP_ACP,
			    MB_PRECOMPOSED, 
			    uuid.c_str(), -1, 
			    uuid_wc, (int)(uuid.size()));

	uuid_wc[uuid.size()] = '\0';
#ifdef _DEBUG	
	std::cout <<   "uuid:    " << uuid << std::endl;
	std::cout <<   "uuid.size():   " << uuid.size() << std::endl;
	std::wcout << L"uuid_wc: " << uuid_wc << std::endl;
	std::wcout << L"uuid_wc.size():" << uuid_wc << std::endl;
#endif
	props->writeMsg(uuid_wc);
	
	delete uuid_wc; // it causes a segfault.
	ret = true;
	return ret;
}
