#include "StdAfx.h"

yamain::yamain(TCHAR* _filename, TCHAR* _dbfilename) : filename(_filename), dbfilename(_dbfilename),
						       filepath(boost::filesystem::path(_filename)),
						       dbpath(boost::filesystem::path(_dbfilename)),
						       yafs(new yantfsstream(_filename)),
						       yadb(new yasqlite3db(_filename, _dbfilename)),
						       hash(new yahash(_filename))
{
  yahashtype_string[(int)md5] = std::string("MD5");
  yahashtype_string[(int)sha1] = std::string("SHA1");
  yahashtype_string[(int)sha256] = std::string("SHA256");
}

yamain::~yamain(void)
{
  delete yafs;
  delete yadb;
}

boolean yamain::deleteData()
{
  boolean ret = false;
  
  return ret;
}
boolean yamain::createHash()
{
  boolean ret = false;
  std::vector<int> hashtypes = yadb->getHashType();
  file_hash = hash->getHash(hashtypes);

  std::map<int, std::string>::iterator ite;
  for(ite = file_hash.begin(); ite != file_hash.end(); ite++) {
#ifdef _DEBUG
    std::cout << "createHash(): i,hash: " << ite->first << "," << ite->second << std::endl;
#endif
    boolean rc = yadb->setHash(ite->first, ite->second);
    if(rc) {
      rc = true;
    }
  }
  return ret;
}
boolean yamain::checkHash(boolean update_db)
{
  boolean ret = false;

  std::vector<int> hashtypes = yadb->getHashType();
  file_hash = hash->getHash(hashtypes);
  std::map<int, std::string>::iterator ite;

  std::map<int, std::string> dbhashmap = yadb->getHash();
  db_hash = dbhashmap;
  std::map<int, std::string>::iterator dbhashmap_ite;
  for(ite = file_hash.begin();  ite != file_hash.end(); ite++) {
    dbhashmap_ite = dbhashmap.find(ite->first);
    if(dbhashmap_ite == dbhashmap.end()) {
      // not found on db
#ifdef _DEBUG
      std::cout << "not found on db: " << ite->second << std::endl;
#endif
      if(update_db) {
#ifdef _DEBUG
	std::cout << "update_db is true: update to '" << ite->second << "'" << std::endl;
#endif
	yadb->setHash(ite->first, ite->second);
      }
    } else {
      // calculated hash result was found on db.
      std::string diskhash = ite->second;
      std::string dbhash = dbhashmap[ite->first];
#ifdef _DEBUG
      std::cout << "diskhash: " << diskhash << std::endl;
      std::cout << "dbhash  : " << dbhash << std::endl;
#endif
      if(diskhash.compare(dbhash) == 0) {
	ret = true;
      } else {
	if(update_db) {
#ifdef _DEBUG
	  std::cout << "update_db is true: update to '" << diskhash << "'" << std::endl;
#endif
	  yadb->setHash(ite->first, diskhash);
	}
      }
    }
  }
  // show results
  for(ite = file_hash.begin(); ite != file_hash.end(); ite++) {
    // previous value:  dbhashmap[ite->first]
    std::cout << yahashtype_string[ite->first] << "\t: " << ite->second;
    if(ret) {
      std::cout << std::endl;
    } else {
      std::cout << "(* modified)" << std::endl;
    }
  }
  return ret;
}

std::string yamain::getUUIDFromDB()
{
	std::string ret;
	ret = yadb->getUUID();

	return ret;
}
std::string yamain::getUUIDFromDisk()
{
	std::string ret;
	ret = yafs->getUUID();

	return ret;
}
boolean yamain::setUUIDToDB(std::string uuid)
{
  boolean ret = yadb->setUUID(uuid);
  return ret;
}
boolean yamain::setUUIDToDisk(std::string uuid)
{
  boolean ret = yafs->setUUID(uuid);
  return ret;
}

boolean yamain::checkUUIDonDB(std::string uuid)
{
  return yadb->existUUID(uuid);
}

boolean yamain::updateFilepathonDBByUUID(TCHAR* _filename, std::string diskuuid)
{
  return yadb->updateFilepathByUUID(_filename, diskuuid);
}

