
#include "stdafx.h"

/**
 * This file was explained at http://souptonuts.sourceforge.net/readme_sqlite_tutorial.html
 *
 * I renamed the class name from SQLITE3 to sqlite3pp.
 * 
 */
sqlite3pp::sqlite3pp(std::string tablename="init.db") : zErrMsg(0), rc(0), db_open(0) {
  rc = sqlite3_open(tablename.c_str(), &db);
  if(rc){
    sqlite3_close(db);
  }
  db_open=1;
}

void sqlite3pp::clear() {
  vcol_head.clear();
  vdata.clear();
}

int sqlite3pp::exe(std::string s_exe) {
  rc = sqlite3_get_table(db,               /* An open database */
			 s_exe.c_str(),    /* SQL to be executed */
			 &result,          /* Result written to a char *[]  that this points to */
			 &nrow,            /* Number of result rows written here */
			 &ncol,            /* Number of result columns written here */
			 &zErrMsg          /* Error msg written here */
			 );

  if(vcol_head.size()<0) { vcol_head.clear();  }
  if(vdata.size()<0)     { vdata.clear(); }
  
  if( rc == SQLITE_OK ){
    for(int i=0; i < ncol; ++i)
      vcol_head.push_back(result[i]);   /* First row heading */
    for(int i=0; i < ncol*nrow; ++i)
      vdata.push_back(result[ncol+i]);
  }
  sqlite3_free_table(result);
  return rc;
}

sqlite3pp::~sqlite3pp(){
  sqlite3_close(db);
}

