// q2chwmSearchEngineDialog.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmSearchEngineDialog.h"
#include "q2chwmLayoutManager.h"
#include "q2chwmConfig.h"

// Cq2chwmSearchEngineDialog _CAO

IMPLEMENT_DYNAMIC(Cq2chwmSearchEngineDialog, CDialog)

Cq2chwmSearchEngineDialog::Cq2chwmSearchEngineDialog(CWnd* pParent /*=NULL*/)
	: CDialog(Cq2chwmSearchEngineDialog::IDD, pParent)
{

}

Cq2chwmSearchEngineDialog::~Cq2chwmSearchEngineDialog()
{
}

void Cq2chwmSearchEngineDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_CBString(pDX, IDC_COMBO_SEARCH, m_cstr_word);
}


BEGIN_MESSAGE_MAP(Cq2chwmSearchEngineDialog, CDialog)
	ON_WM_SHOWWINDOW()
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_BUTTON_CLOSE, &Cq2chwmSearchEngineDialog::OnBnClickedButtonClose)
	ON_BN_CLICKED(IDC_BUTTON_FIND, &Cq2chwmSearchEngineDialog::OnBnClickedButtonFind)
END_MESSAGE_MAP()


// Cq2chwmSearchEngineDialog bZ[W nh

BOOL Cq2chwmSearchEngineDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	// Zbg
	ReloadHistory();

	RECT r;
	CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_SEARCH);
	pCombo->GetWindowRect(&r);
	int in_buttonsize = r.bottom - r.top;
	int in_iconsize = in_buttonsize < 32 ? 16 : 32;
	if (m_cButtonFind.Create(IDI_ICON_FIND, in_iconsize, in_iconsize, CRect(0, 0, in_buttonsize, in_buttonsize), this, IDC_BUTTON_FIND) == FALSE ||
		m_cButtonClose.Create(IDI_ICON_CLOSE, in_iconsize, in_iconsize, CRect(0, 0, in_buttonsize, in_buttonsize), this, IDC_BUTTON_CLOSE) == FALSE)
	{
		return FALSE;
	}
	m_cButtonClose.ShowWindow(SW_SHOW);
	m_cButtonFind.ShowWindow(SW_SHOW);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmSearchEngineDialog::OnOK()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	OnBnClickedButtonFind();

	//CDialog::OnOK();
}

void Cq2chwmSearchEngineDialog::OnCancel()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	OnBnClickedButtonClose();

	//CDialog::OnCancel();
}

BOOL Cq2chwmSearchEngineDialog::PreTranslateMessage(MSG* pMsg)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	if (pMsg->message == WM_KEYDOWN && pMsg->wParam == 0x0d) {
		if (GetFocus() == GetDlgItem(IDC_COMBO_SEARCH)) {
			OnOK();
			return TRUE;
		} else if (GetFocus() == GetDlgItem(IDC_BUTTON_CLOSE)) {
			OnBnClickedButtonClose();
			return TRUE;
		} else if (GetFocus() == GetDlgItem(IDC_BUTTON_FIND)) {
			OnBnClickedButtonFind();
			return TRUE;
		}
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void Cq2chwmSearchEngineDialog::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CDialog::OnShowWindow(bShow, nStatus);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (bShow == TRUE && GetDlgItem(IDC_COMBO_SEARCH)->IsWindowVisible() == TRUE) {
		GetDlgItem(IDC_COMBO_SEARCH)->SetFocus();
	}
}

void Cq2chwmSearchEngineDialog::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (m_cButtonFind.m_hWnd != NULL) {
		Cq2chwmLayoutManager cLayout(
			new Cq2chwmLayoutLine(
			GetDlgItem(IDC_COMBO_SEARCH), 5,
			&m_cButtonFind, 1,
			&m_cButtonClose, 1)
		);
		cLayout.Layout(cx, cy);
	}
}

void Cq2chwmSearchEngineDialog::OnBnClickedButtonClose()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	GetParent()->SendMessage(WM_USER_SHOWSEARCHENGINEBAR, 0, (LPARAM)FALSE);
}

void Cq2chwmSearchEngineDialog::OnBnClickedButtonFind()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	UpdateData(TRUE);
	if (m_cstr_word.GetLength() > 0) {
		CString cstr_url = makeUrl();
		CYoString str_url = A(cstr_url);
		CYoString str_word = A(m_cstr_word);
		GetParent()->SendMessage(WM_USER_EXECSEARCHENGINE, (WPARAM)(const char*)str_url, (LPARAM)(const char*)str_word);
	}
}

void Cq2chwmSearchEngineDialog::ReloadHistory()
{
	CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_SEARCH);
	pCombo->ResetContent();
	for (int i = 0; i < Cq2chwmConfig::GetInstance()->GetHistorySearchWordCount(); i++) {
		CString cstr_value;
		cstr_value = Cq2chwmConfig::GetInstance()->GetHistorySearchWord(i);
		pCombo->InsertString(i, cstr_value);
		if (i == 0) pCombo->SetWindowText(cstr_value);
	}
}

CString Cq2chwmSearchEngineDialog::makeUrl()
{
	// eLXg
	CYoString str_text = A(m_cstr_word);
	str_text.Trim();
	str_text.Format("\"%s\"", (const char*)str_text);
	str_text.Replace(" ", "\" \"");
	str_text.Replace("@", "\" \"");
	str_text.Replace("\t", "\" \"");
	str_text.UrlEncode();

	// URL(Q˂BBSPINKΏۂƂ邽߂ɁuGoogleJX^vT[rX𗘗pĂ܂)
	CYoString str_url;
	str_url.Format("http://www.google.com/cse?cx=000772435278507379437:vzmgmsxhjqm&q=%s&hl=ja&lr=lang_ja&tbs=rcnt:1&num=100&ie=Shift_JIS&oe=Shift_JIS", (const char*)str_text);

	CString cstr_url;
	cstr_url = str_url;
	return cstr_url;
}

void Cq2chwmSearchEngineDialog::SetFocus()
{
	GetDlgItem(IDC_COMBO_SEARCH)->SetFocus();
}

void Cq2chwmSearchEngineDialog::SetText(
	LPCTSTR lpszText)
{
	CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_SEARCH);
	pCombo->SetWindowText(lpszText);
}
