#pragma once

#include "YoPtrArray.h"
#include "q2chwmCommon.h"
#include "q2chwmEditCtrl.h"
#include "q2chwmMessage.h"
#include "q2chwmTabCtrl.h"

// Cq2chwmDatView r[
class Cq2chwmDatCtrl;
class Cq2chwmMessageDialog;

class Cq2chwmDatView : public CView
{
	DECLARE_DYNCREATE(Cq2chwmDatView)

public:
	Cq2chwmDatView();           // IŎgp protected RXgN^
	virtual ~Cq2chwmDatView();

public:
	virtual void OnDraw(CDC* pDC);      // ̃r[`悷邽߂ɃI[o[Ch܂B
#ifdef _DEBUG
	virtual void AssertValid() const;
#ifndef _WIN32_WCE
	virtual void Dump(CDumpContext& dc) const;
#endif

#endif

private:
	Cq2chwmDatCtrl *searchCtrl(const char *chp_url, const char *chp_id, int& in_index);
	void hideCtrl();
	Cq2chwmDatCtrl *currentCtrl();
	void resizeCtrl();

protected:
	DECLARE_MESSAGE_MAP()
public:
	virtual void OnInitialUpdate();
public:
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg long OnCustomMessage(WPARAM wParam, LPARAM lParam);
public:
	BOOL CreateFromFile(const char *chp_aname, const char* chp_aid, const char *chp_bname, const char *chp_burl, const char *chp_bid, int in_number = -1);
	void SetFont();
	void CloseTab(int in_index);
	void NextTab();
	void PrevTab();
	void AddBookmark();
	void GoTop();
	void GoBottom();
	void Delete();
	BOOL IsRunning();
	void SearchNext(const char *chp_find);
	void SearchPrev(const char *chp_find);
	void CopyInformation();
	void Write();
	int GetTabCount(){ return m_cTab.GetItemCount(); }
	void SetWindowText();
	const char *GetCurrentBoardUrl();
	const char *GetCurrentBoardName();
	const char *GetCurrentBoardId();
	const char *GetCurrentArticleId();
	const char *GetCurrentArticleName();
	const char *GetCurrentMessageText();
	void Reply(BOOL bo_message);
	void JumpNumber(int in_number);

private:
	Cq2chwmTabCtrl m_cTab;
	CFont *m_pFont;				// ^uRg[̃tHg
	Cq2chwmMessageDialog *m_pMessageDialog;
	CYoString m_str_font_name;	// tHgύXm邽
	int m_in_font_size;			// tHgύXm邽
	BOOL m_bo_font_bold;		// tHgύXm邽

private:
	afx_msg void OnDestroy();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnReload();
	afx_msg long OnTabClicked(WPARAM wParam, LPARAM lParam);
	afx_msg void OnEdit();
	afx_msg void OnReply();
	afx_msg void OnGotop();
	afx_msg void OnGobottom();
	afx_msg void OnClosetab();
	afx_msg void OnNexttab();
	afx_msg void OnPrevtab();
	afx_msg void OnAddbookmark();
	afx_msg void OnDelete();
protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
public:
	afx_msg void OnLinkBack();
	afx_msg void OnLinkNext();
	afx_msg void OnLinkPrev();
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnDispReload();
	afx_msg void OnDispWrap();
	afx_msg void OnUpdateDispWrap(CCmdUI *pCmdUI);
	afx_msg void OnDispAbone();
	afx_msg void OnUpdateDispAbone(CCmdUI *pCmdUI);
	afx_msg void OnAddTemplate();
	afx_msg void OnUpdateAddTemplate(CCmdUI *pCmdUI);
	afx_msg void OnAddNg();
	afx_msg void OnUpdateAddNg(CCmdUI *pCmdUI);
	afx_msg void OnGrepId();
	afx_msg void OnGrepName();
	afx_msg void OnGrepRefer();
	afx_msg void OnCopyMessage();
	afx_msg void OnCopy();
	afx_msg void OnUpdateCopy(CCmdUI *pCmdUI);
	afx_msg void OnReplyAll();
};
