#pragma once

#include "YoTable.h"
#include "YoString.h"
#include "YoRegex.h"
#include "q2chwmCommon.h"

/*
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
*/
//! t@CLbV̗vf
/*!
 * t@CCύXCTCYɂύX̗LD
 */
/*
class Cq2chwmArticleFileCacheItem
{
private:
    CYoString m_str_filename;
    time_t m_ctime;
    int m_in_size;
    CYoPtrArray *m_pPtrArray;

	void freePtrArray(){
		for( int i = 0; i < m_pPtrArray->Count(); i++ ){
			CYoDataArray *pDataArray = (CYoDataArray*)m_pPtrArray->Get(i);
			delete pDataArray;
		}
		delete m_pPtrArray;
	}

    void SetPtrArray ( CYoPtrArray *pPtrArray ){ 
	if( m_pPtrArray != NULL ) {
	    freePtrArray();
	}
	m_pPtrArray = new CYoPtrArray();
	*m_pPtrArray = *pPtrArray; 
    }
    
public:
    Cq2chwmArticleFileCacheItem( const char *chp_filename, CYoPtrArray *pPtrArray ){
	m_pPtrArray = NULL;

	struct stat st_stat;
	memset( &st_stat, 0x00, sizeof(st_stat) );
	if( stat( chp_filename, &st_stat ) != 0 ){
		qDebug( "stat error[%s]\n", chp_filename );
		m_ctime = 0;
		m_in_size = 0;
		pPtrArray = NULL;
	} else {
		m_ctime = st_stat.st_ctime;
		m_in_size = st_stat.st_size;
	}

	SetPtrArray( pPtrArray );
	m_str_filename = chp_filename;
    }

    ~CQ2chArticleFileCacheItem(){ 
	if( m_pPtrArray != NULL ){
	    freePtrArray();
	}
    }

    BOOL isModified() { // fBXÑf[^LbVƈĂ邩ǂ
	struct stat st_stat;
	memset( &st_stat, 0x00, sizeof(st_stat) );
	if( stat( (const char*)m_str_filename, &st_stat ) != 0 ){
		qDebug( "stat error[%s]\n", (const char*)m_str_filename );
		return TRUE; // ȂĂ TRUE
	}

	// TCYύX̂Ƃ炩łႦ TRUED
	return( st_stat.st_size != m_in_size || st_stat.st_ctime != m_ctime );
    }

    inline const char *GetFileName(){ return (const char *) m_str_filename; }
    inline time_t GetCTime(){ return m_ctime; }
    inline CYoPtrArray *GetPtrArray(){ return m_pPtrArray; }
};
*/

//! article-summaryt@CǗNX
/*!
 * 
 */
class Cq2chwmArticleFile : public CYoTable
{
private:
	CYoString m_str_filename;
	CYoString m_str_id;
	int m_in_seen;
	int m_in_time;
	CYoRegex *m_pRegex;

//	static CYoPtrArray *m_parray_cache;
//	static int m_in_cachesize;

public:
	Cq2chwmArticleFile();
	~Cq2chwmArticleFile();

 	BOOL Create(const char *chp_url);
// 	static void SetCacheSize( int in_size = 0 );
 
	const char *GetId(int in_idx);
	int  GetSeen(const char *chp_id);
	BOOL SetSeen(const char *chp_id, int in_seen, BOOL bl_time = TRUE);
	int  GetTime(const char *chp_id);
	BOOL SetTime(const char *chp_id, int in_time = -1);
	int  Search( const char *chp_key);
	BOOL Write();
	void AddArticle(Cq2chwmArticleFile &cFile);
};
