// q2chwmSubjectView.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmSubjectView.h"
#include "q2chwmConfig.h"
#include "YoTime.h"
#include "q2chwmThreadDialog.h"

// Cq2chwmSubjectView

//IMPLEMENT_DYNCREATE(Cq2chwmSubjectView, Cq2chwmListView)

Cq2chwmSubjectView::Cq2chwmSubjectView()
{
	m_bo_running = FALSE;
}

Cq2chwmSubjectView::~Cq2chwmSubjectView()
{
}

BEGIN_MESSAGE_MAP(Cq2chwmSubjectView, Cq2chwmListView)
	ON_WM_DESTROY()
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_RELOAD, &Cq2chwmSubjectView::OnReload)
	ON_COMMAND(ID_ADDBOOKMARK, &Cq2chwmSubjectView::OnAddbookmark)
	ON_COMMAND(ID_THREAD, &Cq2chwmSubjectView::OnThread)
	ON_COMMAND(ID_SORT_AID, &Cq2chwmSubjectView::OnSortArticleId)
	ON_UPDATE_COMMAND_UI(ID_SORT_AID, &Cq2chwmSubjectView::OnUpdateSortArticleId)
	ON_COMMAND(ID_SORT_ANAME, &Cq2chwmSubjectView::OnSortArticleName)
	ON_UPDATE_COMMAND_UI(ID_SORT_ANAME, &Cq2chwmSubjectView::OnUpdateSortArticleName)
	ON_COMMAND(ID_SORT_CACHE, &Cq2chwmSubjectView::OnSortCache)
	ON_UPDATE_COMMAND_UI(ID_SORT_CACHE, &Cq2chwmSubjectView::OnUpdateSortCache)
	ON_COMMAND(ID_SORT_COUNT, &Cq2chwmSubjectView::OnSortCount)
	ON_UPDATE_COMMAND_UI(ID_SORT_COUNT, &Cq2chwmSubjectView::OnUpdateSortCount)
	ON_COMMAND(ID_SORT_INDEX, &Cq2chwmSubjectView::OnSortIndex)
	ON_UPDATE_COMMAND_UI(ID_SORT_INDEX, &Cq2chwmSubjectView::OnUpdateSortIndex)
	ON_COMMAND(ID_SORT_NEW, &Cq2chwmSubjectView::OnSortNew)
	ON_UPDATE_COMMAND_UI(ID_SORT_NEW, &Cq2chwmSubjectView::OnUpdateSortNew)
	ON_COMMAND(ID_SORT_SEARCH, &Cq2chwmSubjectView::OnSortSearch)
	ON_UPDATE_COMMAND_UI(ID_SORT_SEARCH, &Cq2chwmSubjectView::OnUpdateSortSearch)
	ON_WM_SHOWWINDOW()
	ON_COMMAND(ID_ADJUST_COLUMN_WIDTH, &Cq2chwmSubjectView::OnAdjustColumnWidth)
	ON_COMMAND(ID_SORT_COUNTPERDAY, &Cq2chwmSubjectView::OnSortCountPerDay)
	ON_UPDATE_COMMAND_UI(ID_SORT_COUNTPERDAY, &Cq2chwmSubjectView::OnUpdateSortCountPerDay)
END_MESSAGE_MAP()


// Cq2chwmSubjectView ff

#ifdef _DEBUG
void Cq2chwmSubjectView::AssertValid() const
{
	Cq2chwmListView::AssertValid();
}

#ifndef _WIN32_WCE
void Cq2chwmSubjectView::Dump(CDumpContext& dc) const
{
	Cq2chwmListView::Dump(dc);
}
#endif
#endif //_DEBUG


// Cq2chwmSubjectView bZ[W nh

BOOL Cq2chwmSubjectView::Reload()
{
	if (CreateFromHttp(m_str_bname, m_str_burl, m_str_bid) == FALSE) {
		return FALSE;
	}
	return TRUE;
}

BOOL Cq2chwmSubjectView::CreateFromFile(
	const char *chp_bname,
	const char *chp_burl,
	const char *chp_bid)
{
	CYoTime cTime;
	if (chp_bname == NULL || chp_burl == NULL || chp_bid == NULL) return FALSE;
	m_str_bname = chp_bname;
	m_str_bid = chp_bid;
	m_str_burl = chp_burl;
	m_str_url = m_str_burl + "subject.txt";
	m_str_filename = UrlToPath(chp_burl);
	m_str_filename += "\\subject.txt";

	if (ExistFile(m_str_filename) == FALSE) {
		if (isFind2ch() == TRUE) {
			::MessageBox(m_hWnd, _T("Q˂錟̌ʂ܂\nQ˂錟sɂ\n[j[][Q˂錟]sĉ"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONINFORMATION);
			return TRUE;
		}
		if (Cq2chwmConfig::GetInstance()->GetOnline() == TRUE ||
			::MessageBox(m_hWnd, _T("Xbhꗗ݂܂BT[o擾܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES)
		{
			if (CreateFromHttp(chp_bname, chp_burl, chp_bid) == FALSE) {
				return FALSE;
			}
			return TRUE;
		}
	} else {
		clearList();
		int in_ret = m_cSubjectFile.CreateFromFile(m_str_filename);
		if (in_ret != ERR_NONE) {
			return FALSE;
		}
	}
	PRINTLOG("done %d(msec)", cTime.Elapsed());

	// Xbhꗗ쐬
	createList();
	GoTop();
	PRINTLOG("createList done %d(msec)", cTime.Elapsed());

	// ^Cgo[
	AfxGetMainWnd()->SetWindowText(W(m_str_bname));

	if (isFind2ch() == FALSE && Cq2chwmConfig::GetInstance()->GetOnline() == TRUE) {
		OnReload();
	}

	SortItems(Cq2chwmConfig::GetInstance()->GetSortColumnSubject(),
		Cq2chwmConfig::GetInstance()->GetSortAscSubject());

	return TRUE;
}

BOOL Cq2chwmSubjectView::CreateFromHttp(
	const char *chp_bname,
	const char *chp_burl,
	const char *chp_bid)
{
	if (chp_bname == NULL || chp_burl == NULL || chp_bid == NULL) return FALSE;
	if (m_bo_running == TRUE) return TRUE;

	// \[gԂۑ
	Cq2chwmConfig::GetInstance()->SetSortColumnSubject(GetSortColumn());
	Cq2chwmConfig::GetInstance()->SetSortAscSubject(GetSortAsc());

	m_bo_running = TRUE;
	GetParent()->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)TRUE);

	m_str_bname = chp_bname;
	m_str_bid = chp_bid;
	m_str_burl = chp_burl;
	m_str_url = m_str_burl + "subject.txt";
	m_str_filename = UrlToPath(chp_burl);
	m_str_filename += "\\subject.txt";
	clearList();

	// ÕXꗗɕێ
	m_cSubjectFileOld.CreateFromFile(m_str_filename);

	int in_ret = m_cSubjectFile.CreateFromHttp(m_str_filename, m_str_url);
	if (in_ret != ERR_NONE) {
		if (in_ret == ERR_HTTP_NOTMODIFIED) {
			CreateFromFile(m_str_bname, m_str_burl, m_str_bid);
		} else {
			ErrorMessageBox(in_ret);
		}
		m_bo_running = FALSE;
		GetParent()->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)FALSE);
		return FALSE;
	}

	// Xbhꗗ쐬
	createList();
	m_bo_running = FALSE;
	GetParent()->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)FALSE);

	// \[g
	SortItems(Cq2chwmConfig::GetInstance()->GetSortColumnSubject(),
		Cq2chwmConfig::GetInstance()->GetSortAscSubject());

	// ^Cgo[
	AfxGetMainWnd()->SetWindowText(W(m_str_bname));

	return TRUE;
}

BOOL Cq2chwmSubjectView::CreateFromFindUrl(
	const char *chp_url)
{
	if (m_bo_running == TRUE) return TRUE;
	m_bo_running = TRUE;
	GetParent()->SendMessage(WM_USER_SHOWFIND2CHBAR, 0, (LPARAM)TRUE);

	m_str_bname = "Q˂錟";
	m_str_bid = "find.2ch.net";
	m_str_burl = "http://.tmp/find.2ch.net/";
	m_str_url = m_str_burl + "subject.txt";
	m_str_filename = UrlToPath(m_str_burl);
	m_str_filename += "\\subject.txt";

	clearList();
	int in_ret = m_cSubjectFile.CreateFromFindUrl(m_str_filename, chp_url);
	if (in_ret != ERR_NONE) {
		m_bo_running = FALSE;
		GetParent()->SendMessage(WM_USER_SHOWFIND2CHBAR, 0, (LPARAM)FALSE);
		return FALSE;
	}

	// Xbhꗗ쐬
	createList();

	m_bo_running = FALSE;
	GetParent()->SendMessage(WM_USER_SHOWFIND2CHBAR, 0, (LPARAM)FALSE);

	return TRUE;
}

void Cq2chwmSubjectView::OnInitialUpdate()
{
	Cq2chwmListView::OnInitialUpdate();

	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	GetListCtrl().InsertColumn(0, _T("No"));
	GetListCtrl().InsertColumn(1, _T("X"));
	GetListCtrl().InsertColumn(2, _T("Xbh"));
	GetListCtrl().InsertColumn(3, _T(""));
	GetListCtrl().InsertColumn(4, _T("XbhID"));
	GetListCtrl().SetColumnWidth(0, Cq2chwmConfig::GetInstance()->GetColumnWidthSubject(0) == 0 ? 50 :
		Cq2chwmConfig::GetInstance()->GetColumnWidthSubject(0));
	GetListCtrl().SetColumnWidth(1, Cq2chwmConfig::GetInstance()->GetColumnWidthSubject(1) == 0 ? 50 :
		Cq2chwmConfig::GetInstance()->GetColumnWidthSubject(1));
	GetListCtrl().SetColumnWidth(2, Cq2chwmConfig::GetInstance()->GetColumnWidthSubject(2) == 0 ? 300 :
		Cq2chwmConfig::GetInstance()->GetColumnWidthSubject(2));
	GetListCtrl().SetColumnWidth(3, Cq2chwmConfig::GetInstance()->GetColumnWidthSubject(3) == 0 ? 50 :
		Cq2chwmConfig::GetInstance()->GetColumnWidthSubject(3));
	GetListCtrl().SetColumnWidth(4, Cq2chwmConfig::GetInstance()->GetColumnWidthSubject(4) == 0 ? 100 :
		Cq2chwmConfig::GetInstance()->GetColumnWidthSubject(4));
	SetFont();
	SetSortColumn(Cq2chwmConfig::GetInstance()->GetSortColumnSubject());
	SetSortAsc(Cq2chwmConfig::GetInstance()->GetSortAscSubject());
}

void Cq2chwmSubjectView::createList()
{
	// Q˂錟ʃXbhꗗŃJύX
	{
		CHeaderCtrl *pHeader = GetListCtrl().GetHeaderCtrl();
		TCHAR szBuff[MAX_PATH];
		_tcscpy(szBuff, isFind2ch() == TRUE ? _T("") : _T("XbhID"));
		HDITEM st_item = {0};
		st_item.mask = HDI_TEXT;
		st_item.cchTextMax = MAX_PATH;
		st_item.pszText = szBuff;
		pHeader->SetItem(Cq2chwmSubjectFile::IDX_AID, &st_item);
	}

	int in_row = m_cSubjectFile.Count();
	GetListCtrl().SetItemCountEx(in_row);

	// VtOZbg
	if (m_cSubjectFileOld.Count() > 0) {
		for (int i = 0; i < m_cSubjectFile.Count(); i++) {
			Cq2chwmSubjectItem *pItem = m_cSubjectFile.GetItem(i);
			Cq2chwmSubjectItem *pItemOld = m_cSubjectFileOld.GetItem(pItem->GetArticleId());
			if (pItemOld == NULL || pItem == NULL) continue;
			int in_count_new = pItem->GetCount() - pItemOld->GetCount();
			if (in_count_new > 0) {
				pItem->SetNew(TRUE);
				pItem->SetCountNew(in_count_new);
			}
		}
	}
}

void Cq2chwmSubjectView::clearList()
{
	GetListCtrl().SetItemCountEx(0);
	GetListCtrl().InvalidateRect(NULL);
	GetListCtrl().UpdateWindow();
	m_cSubjectFile.RemoveAll();
	m_cSubjectFileOld.RemoveAll();
}

void Cq2chwmSubjectView::OnListClicked()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if ((int)pos == -1) return;
	Cq2chwmSubjectItem *pItem = m_cSubjectFile.GetItem((int)pos - 1);
	if (pItem == NULL) return;
	GetParent()->SendMessage(WM_USER_SUBJECTCLICKED, 0, (LPARAM)pItem);
}

void Cq2chwmSubjectView::OnDestroy()
{
	CYoPtrArray cArray;
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(0));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(1));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(2));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(3));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(4));
	Cq2chwmConfig::GetInstance()->SetColumnWidthSubject(cArray);
	Cq2chwmConfig::GetInstance()->SetSortColumnSubject(GetSortColumn());
	Cq2chwmConfig::GetInstance()->SetSortAscSubject(GetSortAsc());
	clearList();
	Cq2chwmListView::OnDestroy();

	// TODO: ɃbZ[W nh R[hǉ܂B
}

void Cq2chwmSubjectView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	TRACE(_T("Cq2chwmSubjectView::OnKeyDown: %02x(%d)\n"), nChar, nChar);
	if (Cq2chwmConfig::GetInstance()->IsKeyAddBookmark(nChar)) {
		AddBookmark();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeySort(nChar)) {
		Sort();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyReload(nChar)) {
		OnReload();
		return;
	};

	Cq2chwmListView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void Cq2chwmSubjectView::OnReload()
{
	// TODO: ɃR}h nh R[hǉ܂B
	if (m_str_burl.Length() == 0 || isFind2ch() == TRUE) return;
	clearList();
	CreateFromHttp(m_str_bname, m_str_burl, m_str_bid);
}

void Cq2chwmSubjectView::SetFont()
{
	Cq2chwmListView::SetFont(Cq2chwmConfig::GetInstance()->GetFontNameBoard(),
		Cq2chwmConfig::GetInstance()->GetFontSizeBoard(), Cq2chwmConfig::GetInstance()->GetFontBoldBoard());
}

void Cq2chwmSubjectView::AddBookmark()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if ((int)pos == -1) return;
	if (::MessageBox(m_hWnd, _T("ubN}[Nɒǉ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
		Cq2chwmListItem *pItem = m_cSubjectFile.GetItem((int)pos - 1);
		Cq2chwmBookmarkItem cBookmarkItem(1, pItem->GetArticleName(), pItem->GetArticleId(),
			pItem->GetBoardName(), pItem->GetBoardId(), pItem->GetBoardUrl());
		GetParent()->SendMessage(WM_USER_ADDBOOKMARK, 0, (LPARAM)&cBookmarkItem);
		InvalidateRect(NULL);
		UpdateWindow();
	}
}

void Cq2chwmSubjectView::OnAddbookmark()
{
	// TODO: ɃR}h nh R[hǉ܂B
	AddBookmark();
}

void Cq2chwmSubjectView::SortItems(
	int in_col,
	BOOL bo_asc)
{
	// \[gsƂ^Cgo[ς
	/*
	CString cstr_title;
	cstr_title = m_str_bname;
	switch (in_col) {
	case Cq2chwmSubjectFile::IDX_INDEX:
		cstr_title += _T("[No]");
		break;
	case Cq2chwmSubjectFile::IDX_COUNT:
		cstr_title += _T("[X]");
		break;
	case Cq2chwmSubjectFile::IDX_ANAME:
		cstr_title += _T("[Xbh]");
		break;
	case Cq2chwmSubjectFile::IDX_AID:
		cstr_title += _T("[XbhID]");
		break;
	case Cq2chwmSubjectFile::IDX_NEW:
		cstr_title += _T("[V]");
		break;
	case Cq2chwmSubjectFile::IDX_SEARCH:
		cstr_title += _T("[]");
		break;
	case Cq2chwmSubjectFile::IDX_CACHE:
		cstr_title += _T("[LbV]");
		break;
	};
	AfxGetMainWnd()->SetWindowText(cstr_title);
	*/

	m_cSubjectFile.Sort(in_col, bo_asc);
	RedrawWindow();
	SetSortColumn(in_col);
	SetSortAsc(bo_asc);
}

void Cq2chwmSubjectView::Sort()
{
	int in_col = GetSortColumn();
	if (in_col == Cq2chwmSubjectFile::IDX_CACHE) {
		in_col = Cq2chwmSubjectFile::IDX_INDEX;
	} else {
		in_col++;
	}
	SortItems(in_col, TRUE);
}

void Cq2chwmSubjectView::Search(
	const char *chp_word)
{
	BOOL bo_ret = FALSE;
	CYoRegex cRegex(chp_word, CYoRegex::SJIS, TRUE);
	for (int i = 0; i < m_cSubjectFile.Count(); i++) {
		Cq2chwmSubjectItem *pItem = m_cSubjectFile.GetItem(i);
		if (cRegex.Match(pItem->GetArticleName()) >= 0) {
			pItem->SetSearch(TRUE);
			bo_ret = TRUE;
		} else {
			pItem->SetSearch(FALSE);
		}
	}

	// }b`ꍇ̂݁A[]Ń\[g&ֈړ
	if (bo_ret == TRUE) {
		SortItems(Cq2chwmSubjectFile::IDX_SEARCH, TRUE);
		GoTop();
	}
}

BOOL Cq2chwmSubjectView::GetItemText(
	LPTSTR wchp_text,
	int in_size,
	int in_row,
	int in_col)
{
	if (isFind2ch() == TRUE && in_col == Cq2chwmSubjectFile::IDX_AID) {
		in_col = Cq2chwmSubjectFile::IDX_BNAME;
	}

	Cq2chwmSubjectItem *pItem = m_cSubjectFile.GetItem(in_row);
	if (pItem == NULL) return FALSE;
	CString cstr_tmp;
	switch (in_col) {
	case Cq2chwmSubjectFile::IDX_INDEX:
		cstr_tmp.Format(_T("%d"), pItem->GetIndex());
		break;
	case Cq2chwmSubjectFile::IDX_COUNT:
		if (pItem->GetCountNew() > 0) {
			if (Cq2chwmConfig::GetInstance()->GetListSingleLine() == TRUE) {
				cstr_tmp.Format(_T("%d(%d)"), pItem->GetCount(), pItem->GetCountNew());
			} else {
				cstr_tmp.Format(_T("%d\n(%d)"), pItem->GetCount(), pItem->GetCountNew());
			}
		} else {
			cstr_tmp.Format(_T("%d"), pItem->GetCount());
		}
		break;
	case Cq2chwmSubjectFile::IDX_ANAME:
		cstr_tmp = pItem->GetArticleName();
		break;
	case Cq2chwmSubjectFile::IDX_AID:
		cstr_tmp = pItem->GetArticleId();
		break;
	case Cq2chwmSubjectFile::IDX_COUNTPERDAY:
		cstr_tmp.Format(_T("%.1f"), pItem->GetCountPerDay());
		break;
	case Cq2chwmSubjectFile::IDX_BNAME:
		cstr_tmp = pItem->GetBoardName();
		break;
	};
	_tcscpy_s(wchp_text, in_size, cstr_tmp);
	return TRUE;
}

Cq2chwmListItem *Cq2chwmSubjectView::GetSelectedItem()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if ((int)pos == -1) return NULL;
	return m_cSubjectFile.GetItem((int)pos - 1);
}

Cq2chwmListItem *Cq2chwmSubjectView::GetItem(
	int iRow)
{
	return m_cSubjectFile.GetItem(iRow);
}

void Cq2chwmSubjectView::OnThread()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmThreadDialog cDialog(m_str_burl, this);
	if (cDialog.DoModal() == IDOK) {
		Cq2chwmConfig::GetInstance()->AddHistoryName(cDialog.GetName());
		if (strcmp(cDialog.GetMail(), "sage") != 0) {
			// sage͗ɓȂ
			Cq2chwmConfig::GetInstance()->AddHistoryMail(cDialog.GetMail());
		}
		OnReload();
	}
}

void Cq2chwmSubjectView::Copy()
{
	Cq2chwmListView::Copy();
}


void Cq2chwmSubjectView::OnSortArticleId()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmSubjectFile::IDX_AID, FALSE);
}

void Cq2chwmSubjectView::OnUpdateSortArticleId(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmSubjectFile::IDX_AID);
}

void Cq2chwmSubjectView::OnSortArticleName()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmSubjectFile::IDX_ANAME, TRUE);
}

void Cq2chwmSubjectView::OnUpdateSortArticleName(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmSubjectFile::IDX_ANAME);
}

void Cq2chwmSubjectView::OnSortCache()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmSubjectFile::IDX_CACHE, TRUE);
}

void Cq2chwmSubjectView::OnUpdateSortCache(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmSubjectFile::IDX_CACHE);
}

void Cq2chwmSubjectView::OnSortCount()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmSubjectFile::IDX_COUNT, FALSE);
}

void Cq2chwmSubjectView::OnUpdateSortCount(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmSubjectFile::IDX_COUNT);
}

void Cq2chwmSubjectView::OnSortIndex()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmSubjectFile::IDX_INDEX, TRUE);
}

void Cq2chwmSubjectView::OnUpdateSortIndex(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmSubjectFile::IDX_INDEX);
}

void Cq2chwmSubjectView::OnSortNew()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmSubjectFile::IDX_NEW, TRUE);
}

void Cq2chwmSubjectView::OnUpdateSortNew(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmSubjectFile::IDX_NEW);
}

void Cq2chwmSubjectView::OnSortSearch()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmSubjectFile::IDX_SEARCH, TRUE);
}

void Cq2chwmSubjectView::OnUpdateSortSearch(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmSubjectFile::IDX_SEARCH);
}

void Cq2chwmSubjectView::OnShowWindow(BOOL bShow, UINT nStatus)
{
	Cq2chwmListView::OnShowWindow(bShow, nStatus);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (bShow == TRUE) {
		// ^Cgo[
		AfxGetMainWnd()->SetWindowText(W(m_str_bname));
	}
}

void Cq2chwmSubjectView::OnAdjustColumnWidth()
{
	// TODO: ɃR}h nh R[hǉ܂B
	for (int i = 0; i < GetListCtrl().GetHeaderCtrl()->GetItemCount(); i++) {
		GetListCtrl().SetColumnWidth(i, LVSCW_AUTOSIZE);
	}
	if (Cq2chwmConfig::GetInstance()->GetListSingleLine() == FALSE) {
		// X1/2
		GetListCtrl().SetColumnWidth(1, GetListCtrl().GetColumnWidth(1) / 2);
	}
	// Xbh1/2Ƃ
	GetListCtrl().SetColumnWidth(2, GetListCtrl().GetColumnWidth(2) / 2);
}

void Cq2chwmSubjectView::OnSortCountPerDay()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmSubjectFile::IDX_COUNTPERDAY, FALSE);
}

void Cq2chwmSubjectView::OnUpdateSortCountPerDay(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmSubjectFile::IDX_COUNTPERDAY);
}
