// q2chwmFind2chDialog.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmFind2chDialog.h"
#include "q2chwmLayoutManager.h"
#include "q2chwmConfig.h"

// Cq2chwmFind2chDialog _CAO

IMPLEMENT_DYNAMIC(Cq2chwmFind2chDialog, CDialog)

Cq2chwmFind2chDialog::Cq2chwmFind2chDialog(CWnd* pParent /*=NULL*/)
	: CDialog(Cq2chwmFind2chDialog::IDD, pParent)
	, m_cstr_word(_T(""))
{

}

Cq2chwmFind2chDialog::~Cq2chwmFind2chDialog()
{
}

void Cq2chwmFind2chDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_CBString(pDX, IDC_COMBO_SEARCH, m_cstr_word);
}


BEGIN_MESSAGE_MAP(Cq2chwmFind2chDialog, CDialog)
	ON_WM_SIZE()
	ON_WM_SHOWWINDOW()
	ON_BN_CLICKED(IDC_BUTTON_CLOSE, &Cq2chwmFind2chDialog::OnBnClickedButtonClose)
	ON_BN_CLICKED(IDC_BUTTON_FIND, &Cq2chwmFind2chDialog::OnBnClickedButtonFind)
END_MESSAGE_MAP()


// Cq2chwmFind2chDialog bZ[W nh

void Cq2chwmFind2chDialog::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (GetDlgItem(IDC_COMBO_SEARCH) != NULL &&
		::IsWindow(GetDlgItem(IDC_COMBO_SEARCH)->m_hWnd) != FALSE &&
		::IsWindow(m_cButtonClose.m_hWnd) == TRUE)
	{
		Cq2chwmLayoutManager cLayout(
			new Cq2chwmLayoutLine(GetDlgItem(IDC_COMBO_SEARCH), 5, &m_cButtonFind, 1, &m_cButtonClose, 1)
		);
		cLayout.Layout(cx, cy);
	}
}

void Cq2chwmFind2chDialog::OnOK()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	UpdateData(TRUE);
	CString cstr_url = makeUrl();
	if (m_cstr_word.GetLength() > 0) {
		GetParent()->SendMessage(WM_USER_EXECFIND2CH, (WPARAM)(const wchar_t*)cstr_url, (LPARAM)(const wchar_t*)m_cstr_word);
	}

	//CDialog::OnOK();
}

void Cq2chwmFind2chDialog::OnCancel()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	GetParent()->SendMessage(WM_USER_SHOWFIND2CHBAR, 0, (LPARAM)FALSE);

	//CDialog::OnCancel();
}

BOOL Cq2chwmFind2chDialog::PreTranslateMessage(MSG* pMsg)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	if (pMsg->message == WM_KEYDOWN && pMsg->wParam == 0x0d) {
		if (GetFocus() == GetDlgItem(IDC_COMBO_SEARCH)) {
			OnOK();
			return TRUE;
		} else if (GetFocus() == GetDlgItem(IDC_BUTTON_CLOSE)) {
			OnCancel();
			return TRUE;
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void Cq2chwmFind2chDialog::SetFocus()
{
	GetDlgItem(IDC_COMBO_SEARCH)->SetFocus();
}

CString Cq2chwmFind2chDialog::makeUrl()
{
	// eLXg
	CYoString str_enc_text = A(m_cstr_word);
	str_enc_text.ConvertKCodeEx(CYoString::SJISTOEUC);
	str_enc_text.UrlEncode();

	// T[rX
	int in_service = 0;

	// 
	int in_num = 50;

	// \[g
	int in_sort = 0;

	// \[g
	static char *chpa_sort_text[][8] = {
		// find.2ch.net
		{
			"SCEND=A&SORT=NPOSTS",
			"SCEND=D&SORT=NPOSTS",
			"SCEND=A&SORT=CREATED",
			"SCEND=D&SORT=CREATED",
			"SCEND=A&SORT=MODIFIED",
			"SCEND=D&SORT=MODIFIED",
			NULL,	// ԑ傫̂ɍ킹Ė
			NULL,	// ԑ傫̂ɍ킹Ė
		},

		// domo2.net
		{
			"res+desc",
			"res",
			"dat+desc",
			"dat",
			"title",
			"title+desc",
			"bbsname",
			"bbsname+desc"
		},

		// 2ken.net
		{
			"all",
			"linux%2Cunix%2Chack%2Cperl%2Cesite%2Ctech%2Cjisaku%2Chp%2Cprog%2Cpc%2Cnetwork%2Cnet%2Cmac%2Cphp%2Csec%2Cpcqa%2Cisp%2Chard%2Cbsoft%2Cyahoo%2Cnifty%2Cwin%2Cgame%2Csoftware%2Cpcnews",
			"fashion%2Cshop%2Cgurume%2Canime%2Cfootball%2Cmusice%2Cgeino%2Cfemale%2Csoccer%2Ctvd%2Cmusicj%2Cbase%2Ctrain%2Cmusic%2Cymag%2Ccar%2Cpachi%2Ckeiba%2Cbike%2Cdiet%2Carc%2Cslot%2Cfamicom%2Cboxing%2Ccomic",
			"koumu%2Ctv%2Ckankon%2Cnewsplus%2Cventure%2Chikari%2Ccompany%2Cshihou%2Ckaden%2Crecruit%2Ctax%2Cyouth%2Choken%2Cjob%2Cnews%2Cshikaku%2Cdrama%2Chosp%2Cghard%2Cpart%2Cestate%2Clic%2Chaken%2Cmass%2Cstock",
			"qa%2Cgline%2Csake%2Cbooks%2Cmj%2Csale%2Cuwasa%2Cclub%2Cnortha%2Cutu%2Coccult%2Cainotane%2Cjan%2Cdoujin%2Cihou%2Csmap%2Ccosp%2Cascii%2Cstreaming%2Cgay%2Cmorningcoffee%2Cmovie%2Cmental%2Caccuse%2Cpolice",
			NULL,	// ԑ傫̂ɍ킹Ė
			NULL,	// ԑ傫̂ɍ킹Ė
			NULL,	// ԑ傫̂ɍ킹Ė
		},
	};
	CYoString str_sort_text = chpa_sort_text[in_service][in_sort];

	// URL
	CYoString str_url;
	switch (in_service) {
	case 0:
		// find.2ch.net
		str_url.Format("http://find.2ch.net/index.php?TYPE=TITLE&STR=%s&COUNT=%d&%s", (const char*)str_enc_text, in_num, (const char*)str_sort_text);
		break;
	case 1:
		// domo2.net
		str_url.Format("http://domo2.net/search/search.cgi?word=%s&tnum=%d&sort=%s", (const char*)str_enc_text, in_num, (const char*)str_sort_text);
		break;
	case 2:
		// 2ken.net
		str_url.Format("http://2ken.net/cgi-bin/namazu.cgi?key=%s&max=%d&whence=0&dbname=%s", (const char*)str_enc_text, in_num, (const char*)str_sort_text);
		break;
	}

	CString cstr_url;
	cstr_url = str_url;
	return cstr_url;
}

void Cq2chwmFind2chDialog::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CDialog::OnShowWindow(bShow, nStatus);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (bShow == TRUE && GetDlgItem(IDC_COMBO_SEARCH)->IsWindowVisible() == TRUE) {
		GetDlgItem(IDC_COMBO_SEARCH)->SetFocus();
	}
}

BOOL Cq2chwmFind2chDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	// Zbg
	CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_SEARCH);
	for (int i = 0; i < Cq2chwmConfig::GetInstance()->GetHistorySearchWordCount(); i++) {
		CString cstr_value;
		cstr_value = Cq2chwmConfig::GetInstance()->GetHistorySearchWord(i);
		pCombo->InsertString(i, cstr_value);
	}

	RECT r;
	pCombo->GetWindowRect(&r);
	int in_buttonsize = r.bottom - r.top;
	int in_iconsize = in_buttonsize < 32 ? 16 : 32;
	if (m_cButtonFind.Create(IDI_ICON_FIND, in_iconsize, in_iconsize, CRect(0, 0, in_buttonsize, in_buttonsize), this, IDC_BUTTON_FIND) == FALSE ||
		m_cButtonClose.Create(IDI_ICON_CLOSE, in_iconsize, in_iconsize, CRect(0, 0, in_buttonsize, in_buttonsize), this, IDC_BUTTON_CLOSE) == FALSE)
	{
		return FALSE;
	}
	m_cButtonFind.ShowWindow(SW_SHOW);
	m_cButtonClose.ShowWindow(SW_SHOW);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmFind2chDialog::OnBnClickedButtonClose()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	OnCancel();
}

void Cq2chwmFind2chDialog::OnBnClickedButtonFind()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	OnOK();
}
