/*
 * nEdit
 *
 * nEdit.h
 *
 * Copyright (C) 1996-2005 by Nakashima Tomoaki. All rights reserved.
 *		http://www.nakka.com/
 *		nakka@nakka.com
 */

#ifndef _INC_NEDIT_H
#define _INC_NEDIT_H

/* Include Files */
#include <windows.h>
#include <tchar.h>
#ifdef OP_XP_STYLE
#include <uxtheme.h>
#include <tmschema.h>
#endif	// OP_XP_STYLE

/* Define */
#define NEDIT_WND_CLASS					TEXT("nEdit")

#define WM_GETBUFFERINFO				(WM_APP + 1)
#define WM_REFLECT						(WM_APP + 2)
#define WM_GETWORDWRAP					(WM_APP + 3)
#define WM_SETWORDWRAP					(WM_APP + 4)
#define WM_GETMEMSIZE					(WM_APP + 5)
#define WM_GETMEM						(WM_APP + 6)
#define WM_SETMEM						(WM_APP + 7)

// added by FujitaYOSHITOMO
#define WM_ADDTEXT						(WM_APP + 8)
#ifndef EM_GETSELTEXT
#define EM_GETSELTEXT					(WM_APP + 9)
#endif
#define EM_GETLINEEND					(WM_APP + 10)
#define WM_USER_NEDITMSG				(WM_APP + 11)
#define Q2CH_SETCOLOR_FORE				(WM_APP + 1000)
#define Q2CH_SETCOLOR_BACK				(WM_APP + 1001)
#define Q2CH_SETCOLOR_FROM				(WM_APP + 1002)
#define Q2CH_SETCOLOR_FROMWITHMAIL		(WM_APP + 1003)
#define Q2CH_SETCOLOR_FROMWITHSAGE		(WM_APP + 1004)
#define Q2CH_SETCOLOR_NEW				(WM_APP + 1005)
#define Q2CH_SETCOLOR_DATE				(WM_APP + 1006)
#define Q2CH_SETCOLOR_LINK				(WM_APP + 1007)
#define Q2CH_SETCOLOR_ABONE				(WM_APP + 1008)
#define Q2CH_SETCOLOR_MESSAGE			(WM_APP + 1009)
// added end

#define EM_GETREADONLY					(WM_APP + 100)

#ifndef EM_REDO
#define EM_REDO							(WM_USER + 84)
#endif
#ifndef EM_CANREDO
#define EM_CANREDO						(WM_USER + 85)
#endif

#define UNDO_TYPE_INPUT					1
#define UNDO_TYPE_DELETE				2

/* Struct */
typedef struct _UNDO {
	BYTE type;

	DWORD st;
	DWORD len;
	TCHAR *buf;
} UNDO;

typedef struct _BUFFER {
	// ێĂe
	TCHAR *buf;
	DWORD buf_size;
	DWORD buf_len;

	// ̓obt@
	TCHAR *input_buf;
	DWORD input_size;
	DWORD input_len;

	// \s̃ItZbg
	DWORD *line;
	int line_size;
	int line_len;
	int line_add_index;
	int line_add_len;

	// UNDOobt@
	UNDO *undo;
	int undo_size;
	int undo_len;
	int undo_pos;

	// ͊Jnʒu
	TCHAR *ip;
	DWORD ip_len;
	// 폜Jnʒu
	TCHAR *dp;
	DWORD del_len;

	// Lbg̈ʒu
	DWORD cp;
	// Iʒu
	DWORD sp;
	// ㉺ړ̃LbgXW
	int cpx;

	// 1s̕
	int line_max;
	// s̍ő啝
	int line_width;
	// EBhE̕
	int width;

	// XN[ o[
	int pos_x;
	int max_x;
	int pos_y;
	int max_y;

	// ^uXgbv
	int tab_stop;
	// }[W
	int left_margin;
	// }[W
	int top_margin;
	// E}[W
	int right_margin;
	// }[W
	int bottom_margin;
	// s
	int spacing;

	// `p
	HDC mdc;
	HBITMAP ret_bmp;
	HRGN hrgn;
	HFONT hfont;
	HFONT ret_font;

	// tHg
	int font_height;
	int char_width;

	// ܂ԂtO
	BOOL wordwrap;
	// tH[JXĂI\
	BOOL no_hide_sel;
	// ɕϊ
	BOOL lowercase;
	// 啶ɕϊ
	BOOL uppercase;
	// bNtO
	BOOL lock;
	// CtO
	BOOL modified;
	// ̓[h
	BOOL insert_mode;
	// ItO
	BOOL sel;
	// }EXtO
	BOOL mousedown;
	// ͒
	DWORD limit_len;

	// ̕
	//BYTE cwidth[256];

	// Rg[ʎq
	int id;
	// IME
	HIMC himc;
#ifdef OP_XP_STYLE
	// XP
	HMODULE hModThemes;
	HTHEME hTheme;
#endif	// OP_XP_STYLE

	// added by FujitaYOSHITOMO
	COLORREF color_fore;
	COLORREF color_back;
	COLORREF color_from;
	COLORREF color_fromwithmail;
	COLORREF color_fromwithsage;
	COLORREF color_new;
	COLORREF color_date;
	COLORREF color_link;
	COLORREF color_abone;
	COLORREF color_message;
	COLORREF color_cite;
	// added end

} BUFFER;

// q2chg
typedef struct _NEDITMSG {
	UINT msg;
	WPARAM wParam;
	LPARAM lParam;
} NEDITMSG;
// ptH[}XAbv̂ߒڌĂׂ悤ɂ
DWORD line_get(const BUFFER *bf, const int lindex);
int line_get_length(const BUFFER *bf, const DWORD index);
TCHAR *index_to_char(const BUFFER *bf, const DWORD index);
void nedit_clear_cache();

/* Function Prototypes */
BOOL nedit_regist(const HINSTANCE hInstance);
#endif
/* End of source */
