// q2chwmPageNg.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmPageNg.h"
#include "q2chwmNgFile.h"
#include "q2chwmLayoutManager.h"
#include "q2chwmConfig.h"

// Cq2chwmPageNg _CAO

IMPLEMENT_DYNAMIC(Cq2chwmPageNg, CDialog)

Cq2chwmPageNg::Cq2chwmPageNg(CWnd* pParent /*=NULL*/)
	: Cq2chwmConfigPage(Cq2chwmPageNg::IDD, pParent)
	, m_cstr_url(_T(""))
	, m_cstr_ng(_T(""))
{
	m_bo_update = FALSE;
}

Cq2chwmPageNg::~Cq2chwmPageNg()
{
}

void Cq2chwmPageNg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_CBString(pDX, IDC_COMBO_URL, m_cstr_url);
	DDX_CBString(pDX, IDC_COMBO_NG, m_cstr_ng);
}


BEGIN_MESSAGE_MAP(Cq2chwmPageNg, Cq2chwmConfigPage)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_BUTTON_ADD, &Cq2chwmPageNg::OnBnClickedButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_MOD, &Cq2chwmPageNg::OnBnClickedButtonMod)
	ON_BN_CLICKED(IDC_BUTTON_DEL, &Cq2chwmPageNg::OnBnClickedButtonDel)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST, &Cq2chwmPageNg::OnLvnItemchangedList)
END_MESSAGE_MAP()

void Cq2chwmPageNg::Write()
{
	CButton *pButton = (CButton*)GetDlgItem(IDC_CHECK_TRANSPARENTABONE);
	Cq2chwmConfig::GetInstance()->SetTransParentAbone(pButton->GetCheck());

	// ngword.txt
	if (m_bo_update == TRUE) {
		Cq2chwmNgFile::GetInstance()->RemoveAll();
		CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
		for (int i = 0; i < pList->GetItemCount(); i++) {
			CYoString str_url = A(pList->GetItemText(i, 0));
			CYoString str_ng = A(pList->GetItemText(i, 1));
			Cq2chwmNgFile::GetInstance()->AddNg(str_url, str_ng);
		}
		Cq2chwmNgFile::GetInstance()->Write();
	}
}

// Cq2chwmPageNg bZ[W nh

BOOL Cq2chwmPageNg::OnInitDialog()
{
	Cq2chwmConfigPage::OnInitDialog();

	// TODO:  ɏǉĂ
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	pList->SetExtendedStyle(LVS_EX_FULLROWSELECT);
	pList->InsertColumn(0, _T("URL"));
	pList->InsertColumn(1, _T("NG[h"));
	for (int i = 0; i < Cq2chwmNgFile::GetInstance()->Rows(); i++) {
		CString cstr_tmp;
		cstr_tmp = Cq2chwmNgFile::GetInstance()->GetUrl(i);
		pList->InsertItem(i, cstr_tmp);
		cstr_tmp = Cq2chwmNgFile::GetInstance()->GetNg(i);
		pList->SetItemText(i, 1, cstr_tmp);
	}

	// URLR{{bNXɃZbg
	{
		CStringArray *pArray = ((Cq2chwmConfigDialog*)GetParent())->GetUrlArray();
		CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_URL);
		for (int i = 0; i < pArray->GetCount(); i++) {
			pCombo->AddString(pArray->GetAt(i));
		}
	}

	// NG[hR{{bNXɃZbg
	{
		CStringArray *pArray = ((Cq2chwmConfigDialog*)GetParent())->GetTextArray();
		CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_NG);
		for (int i = 0; i < pArray->GetCount(); i++) {
			pCombo->AddString(pArray->GetAt(i));
		}
	}

	CButton *pButton = (CButton*)GetDlgItem(IDC_CHECK_TRANSPARENTABONE);
	pButton->SetCheck(Cq2chwmConfig::GetInstance()->GetTransParentAbone());

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmPageNg::OnSize(UINT nType, int cx, int cy)
{
	Cq2chwmConfigPage::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	Cq2chwmLayoutManager cLayout(
		new Cq2chwmLayoutLine(GetDlgItem(IDC_CHECK_TRANSPARENTABONE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_URL), 1, GetDlgItem(IDC_COMBO_URL), 3),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_NG), 1, GetDlgItem(IDC_COMBO_NG), 3),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_BUTTON_ADD), 1, GetDlgItem(IDC_BUTTON_MOD), 1, GetDlgItem(IDC_BUTTON_DEL), 1),
		new Cq2chwmLayoutLine(4, GetDlgItem(IDC_LIST), 1)
	);
	cLayout.Layout(cx, cy);

	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	if (pList != NULL) {
		pList->SetColumnWidth(0, cx / 2);
		pList->SetColumnWidth(1, cx / 2);
	}
}

BOOL Cq2chwmPageNg::checkDuplicate()
{
	UpdateData(TRUE);
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	for (int i = 0; i < pList->GetItemCount(); i++) {
		CString cstr_url = pList->GetItemText(i, 0);
		CString cstr_ng = pList->GetItemText(i, 1);
		if (cstr_url == m_cstr_url && cstr_ng == m_cstr_ng) {
			return FALSE;
		}
	}
	return TRUE;
}

void Cq2chwmPageNg::OnBnClickedButtonAdd()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	if (checkDuplicate() == FALSE) {
		::MessageBox(m_hWnd, _T("ɓo^ς݂ł"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK);
		return;
	}
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	pList->InsertItem(0, m_cstr_url);
	pList->SetItemText(0, 1, m_cstr_ng);
	m_bo_update = TRUE;
}

void Cq2chwmPageNg::OnBnClickedButtonMod()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	if (checkDuplicate() == FALSE) {
		::MessageBox(m_hWnd, _T("ɓo^ς݂ł"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK);
		return;
	}
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL) {
		int in_index = (int)pos - 1;
		pList->SetItemText(in_index, 0, m_cstr_url);
		pList->SetItemText(in_index, 1, m_cstr_ng);
	}
	m_bo_update = TRUE;
}

void Cq2chwmPageNg::OnBnClickedButtonDel()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL) {
		int in_index = (int)pos - 1;
		pList->DeleteItem(in_index);
	}
	m_bo_update = TRUE;
}

void Cq2chwmPageNg::OnLvnItemchangedList(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL) {
		int in_index = (int)pos - 1;
		CString cstr_url = pList->GetItemText(in_index, 0);
		CString cstr_ng = pList->GetItemText(in_index, 1);
		CComboBox *pComboUrl = (CComboBox*)GetDlgItem(IDC_COMBO_URL);
		CComboBox *pComboNg = (CComboBox*)GetDlgItem(IDC_COMBO_NG);
		pComboUrl->SetWindowText(cstr_url);
		pComboNg->SetWindowText(cstr_ng);
	}
	*pResult = 0;
}
