// q2chwmPageColor.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmPageColor.h"
#include "q2chwmLayoutManager.h"
#include "q2chwmConfig.h"
#include "q2chwmConfigDialog.h"

#define SETCOLORSTRING(s, i) { \
	CYoString str_color; \
	str_color.Format("#%02x%02x%02x", GetRValue(i), GetGValue(i), GetBValue(i)); \
	s = str_color; \
}

#define SETCOLORINT(s, func) { \
	CYoString str_color = A(s); \
	if (*(const char*)str_color == '#' && str_color.Length() == 7) { \
		const char *chp_tmp = str_color; \
		int ina_rgb[3]; \
		for (int i = 0; i < 3; i++) { \
			char cha_tmp[3]; \
			cha_tmp[0] = chp_tmp[1 + i * 2]; \
			cha_tmp[1] = chp_tmp[1 + i * 2 + 1]; \
			cha_tmp[2] = 0x00; \
			ina_rgb[i] = strtol((const char*)cha_tmp, NULL, 16); \
		} \
		##func(RGB(ina_rgb[0], ina_rgb[1], ina_rgb[2])); \
	} \
}

// Cq2chwmPageColor _CAO

IMPLEMENT_DYNAMIC(Cq2chwmPageColor, CDialog)

Cq2chwmPageColor::Cq2chwmPageColor(CWnd* pParent /*=NULL*/)
	: Cq2chwmConfigPage(Cq2chwmPageColor::IDD, pParent)
{
	m_pColorFore = NULL;
	m_pColorBack = NULL;
	m_pColorCache = NULL;
	m_pColorNew = NULL;
	m_pColorSearch = NULL;
	m_pColorError = NULL;
	m_pColorActive = NULL;
	m_pColorFrom = NULL;
	m_pColorFromWithMail = NULL;
	m_pColorFromWithSage = NULL;
	m_pColorDate = NULL;
	m_pColorDateNew = NULL;
	m_pColorLink = NULL;
	m_pColorMessage = NULL;
	m_pColorAbone = NULL;
}

Cq2chwmPageColor::~Cq2chwmPageColor()
{
	delete m_pColorFore;
	delete m_pColorBack;
	delete m_pColorCache;
	delete m_pColorNew;
	delete m_pColorSearch;
	delete m_pColorError;
	delete m_pColorActive;
	delete m_pColorFrom;
	delete m_pColorFromWithMail;
	delete m_pColorFromWithSage;
	delete m_pColorDate;
	delete m_pColorDateNew;
	delete m_pColorLink;
	delete m_pColorMessage;
	delete m_pColorAbone;
}

void Cq2chwmPageColor::DoDataExchange(CDataExchange* pDX)
{
	Cq2chwmConfigPage::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(Cq2chwmPageColor, Cq2chwmConfigPage)
	ON_WM_SIZE()
END_MESSAGE_MAP()


// Cq2chwmPageColor bZ[W nh

BOOL Cq2chwmPageColor::OnInitDialog()
{
	Cq2chwmConfigPage::OnInitDialog();

	// TODO:  ɏǉĂ
	m_pColorFore = new Cq2chwmColorSelector();
	m_pColorBack = new Cq2chwmColorSelector();
	m_pColorCache = new Cq2chwmColorSelector();
	m_pColorNew = new Cq2chwmColorSelector();
	m_pColorSearch = new Cq2chwmColorSelector();
	m_pColorError = new Cq2chwmColorSelector();
	m_pColorActive = new Cq2chwmColorSelector();
	m_pColorFrom = new Cq2chwmColorSelector();
	m_pColorFromWithMail = new Cq2chwmColorSelector();
	m_pColorFromWithSage = new Cq2chwmColorSelector();
	m_pColorDate = new Cq2chwmColorSelector();
	m_pColorDateNew = new Cq2chwmColorSelector();
	m_pColorLink = new Cq2chwmColorSelector();
	m_pColorMessage = new Cq2chwmColorSelector();
	m_pColorAbone = new Cq2chwmColorSelector();
	RECT rect = {0, 0, 40, 30};
	m_pColorFore->Create(Cq2chwmConfig::GetInstance()->GetColorFore(), rect, this);
	m_pColorBack->Create(Cq2chwmConfig::GetInstance()->GetColorBack(), rect, this);
	m_pColorCache->Create(Cq2chwmConfig::GetInstance()->GetColorCache(), rect, this);
	m_pColorNew->Create(Cq2chwmConfig::GetInstance()->GetColorNew(), rect, this);
	m_pColorSearch->Create(Cq2chwmConfig::GetInstance()->GetColorSearch(), rect, this);
	m_pColorError->Create(Cq2chwmConfig::GetInstance()->GetColorError(), rect, this);
	m_pColorActive->Create(Cq2chwmConfig::GetInstance()->GetColorActive(), rect, this);
	m_pColorFrom->Create(Cq2chwmConfig::GetInstance()->GetColorFrom(), rect, this);
	m_pColorFromWithMail->Create(Cq2chwmConfig::GetInstance()->GetColorFromWithMail(), rect, this);
	m_pColorFromWithSage->Create(Cq2chwmConfig::GetInstance()->GetColorFromWithSage(), rect, this);
	m_pColorDate->Create(Cq2chwmConfig::GetInstance()->GetColorDate(), rect, this);
	m_pColorDateNew->Create(Cq2chwmConfig::GetInstance()->GetColorDateNew(), rect, this);
	m_pColorLink->Create(Cq2chwmConfig::GetInstance()->GetColorLink(), rect, this);
	m_pColorMessage->Create(Cq2chwmConfig::GetInstance()->GetColorMessage(), rect, this);
	m_pColorAbone->Create(Cq2chwmConfig::GetInstance()->GetColorAbone(), rect, this);

	RECT rcClient;
	GetClientRect(&rcClient);
	int cx = rcClient.left;
	int cy = rcClient.bottom;
		Cq2chwmLayoutManager cLayout(
			new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_FORE), 1, m_pColorFore, 1,
				GetDlgItem(IDC_STATIC_BACK), 1, m_pColorBack, 1),
			new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_CACHE), 1, m_pColorCache, 1,
				GetDlgItem(IDC_STATIC_NEW), 1, m_pColorNew, 1),
			new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_SEARCH), 1, m_pColorSearch, 1,
				GetDlgItem(IDC_STATIC_ERROR), 1, m_pColorError, 1),
			new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_ACTIVE), 1, m_pColorActive, 1,
				GetDlgItem(IDC_STATIC_FROM), 1, m_pColorFrom, 1),
			new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_FROMWITHMAIL), 1, m_pColorFromWithMail, 1,
				GetDlgItem(IDC_STATIC_FROMWITHSAGE), 1, m_pColorFromWithSage, 1),
			new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_DATE), 1, m_pColorDate, 1,
				GetDlgItem(IDC_STATIC_DATENEW), 1, m_pColorDateNew, 1),
			new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_LINK), 1, m_pColorLink, 1,
				GetDlgItem(IDC_STATIC_MESSAGE), 1, m_pColorMessage, 1),
			new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_ABONE), 1, m_pColorAbone, 1,
				GetDlgItem(IDC_STATIC_DUMMY), 2)
		);
		cLayout.Layout(cx, cy);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmPageColor::OnSize(UINT nType, int cx, int cy)
{
	Cq2chwmConfigPage::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (m_pColorCache != NULL) {
		Cq2chwmLayoutManager cLayout(
			new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_FORE), 1, m_pColorFore, 1,
				GetDlgItem(IDC_STATIC_BACK), 1, m_pColorBack, 1),
			new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_CACHE), 1, m_pColorCache, 1,
				GetDlgItem(IDC_STATIC_NEW), 1, m_pColorNew, 1),
			new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_SEARCH), 1, m_pColorSearch, 1,
				GetDlgItem(IDC_STATIC_ERROR), 1, m_pColorError, 1),
			new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_ACTIVE), 1, m_pColorActive, 1,
				GetDlgItem(IDC_STATIC_FROM), 1, m_pColorFrom, 1),
			new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_FROMWITHMAIL), 1, m_pColorFromWithMail, 1,
				GetDlgItem(IDC_STATIC_FROMWITHSAGE), 1, m_pColorFromWithSage, 1),
			new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_DATE), 1, m_pColorDate, 1,
				GetDlgItem(IDC_STATIC_DATENEW), 1, m_pColorDateNew, 1),
			new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_LINK), 1, m_pColorLink, 1,
				GetDlgItem(IDC_STATIC_MESSAGE), 1, m_pColorMessage, 1),
			new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_ABONE), 1, m_pColorAbone, 1,
				GetDlgItem(IDC_STATIC_DUMMY), 2)
		);
		cLayout.Layout(cx, cy);
	}
}

void Cq2chwmPageColor::Write()
{
	UpdateData(TRUE);
	Cq2chwmConfig::GetInstance()->SetColorFore(m_pColorFore->GetColor());
	Cq2chwmConfig::GetInstance()->SetColorBack(m_pColorBack->GetColor());
	Cq2chwmConfig::GetInstance()->SetColorCache(m_pColorCache->GetColor());
	Cq2chwmConfig::GetInstance()->SetColorNew(m_pColorNew->GetColor());
	Cq2chwmConfig::GetInstance()->SetColorSearch(m_pColorSearch->GetColor());
	Cq2chwmConfig::GetInstance()->SetColorError(m_pColorError->GetColor());
	Cq2chwmConfig::GetInstance()->SetColorActive(m_pColorActive->GetColor());
	Cq2chwmConfig::GetInstance()->SetColorFrom(m_pColorFrom->GetColor());
	Cq2chwmConfig::GetInstance()->SetColorFromWithMail(m_pColorFromWithMail->GetColor());
	Cq2chwmConfig::GetInstance()->SetColorFromWithSage(m_pColorFromWithSage->GetColor());
	Cq2chwmConfig::GetInstance()->SetColorDate(m_pColorDate->GetColor());
	Cq2chwmConfig::GetInstance()->SetColorDateNew(m_pColorDateNew->GetColor());
	Cq2chwmConfig::GetInstance()->SetColorLink(m_pColorLink->GetColor());
	Cq2chwmConfig::GetInstance()->SetColorMessage(m_pColorMessage->GetColor());
	Cq2chwmConfig::GetInstance()->SetColorAbone(m_pColorAbone->GetColor());
}
