#pragma once
#include "q2chwmCommon.h"
#include "YoDataArray.h"

class Cq2chwmConfigKey;

// VXe
#define CONF_ROOTDIR			"RootDirectory"
#define CONF_BOARDURL			"BoardUrl"
#define CONF_BROWSER			"Browser"
#define CONF_THREADMAX			"ThreadMax"
#define CONF_TABMAX				"TabMax"
#define CONF_TABWIDTH			"TabWidth"
#define CONF_ONLINE				"Online"
#define CONF_DEBUG				"Debug"

// lbg[N
#define CONF_PROXY_USE			"ProxyUse"
#define CONF_PROXY_USEWRITE		"ProxyUseWrite"
#define CONF_PROXY_HOST			"ProxyHost"
#define CONF_PROXY_PORT			"ProxyPort"
#define CONF_PROXY_ID			"ProxyId"
#define CONF_PROXY_PASS			"ProxyPass"
#define CONF_DOLIB_ID			"DoLibId"
#define CONF_DOLIB_PASS			"DoLibPass"
#define CONF_DOLIB_SID			"DoLibSid"
#define CONF_SAGE				"Sage"

// tHg
#define CONF_FONTNAME_LIST		"FontNameList"
#define CONF_FONTNAME_BOARD		"FontNameBoard"
#define CONF_FONTNAME_MESSAGE	"FontNameMessage"
#define CONF_FONTNAME_CACHE		"FontNameCache"
#define CONF_FONTNAME_BOOKMARK	"FontNameBookmark"
#define CONF_FONTNAME_TAB		"FontNameTab"
#define CONF_FONTNAME_ARTICLE	"FontNameArticle"
#define CONF_FONTSIZE_LIST		"FontSizeList"
#define CONF_FONTSIZE_BOARD		"FontSizeBoard"
#define CONF_FONTSIZE_MESSAGE	"FontSizeMessage"
#define CONF_FONTSIZE_CACHE		"FontSizeCache"
#define CONF_FONTSIZE_BOOKMARK	"FontSizeBookmark"
#define CONF_FONTSIZE_TAB		"FontSizeTab"
#define CONF_FONTSIZE_ARTICLE	"FontSizeArticle"
#define CONF_FONTBOLD_LIST		"FontBoldList"
#define CONF_FONTBOLD_BOARD		"FontBoldBoard"
#define CONF_FONTBOLD_MESSAGE	"FontBoldMessage"
#define CONF_FONTBOLD_CACHE		"FontBoldCache"
#define CONF_FONTBOLD_BOOKMARK	"FontBoldBookmark"
#define CONF_FONTBOLD_TAB		"FontBoldTab"
#define CONF_FONTBOLD_ARTICLE	"FontBoldArticle"

// F
#define CONF_COLOR_FORE			"ColorFore"
#define CONF_COLOR_BACK			"ColorBack"
#define CONF_COLOR_CACHE		"ColorCache"
#define CONF_COLOR_NEW			"ColorNew"
#define CONF_COLOR_ERROR		"ColorError"
#define CONF_COLOR_SEARCH		"ColorSearch"
#define CONF_COLOR_ACTIVE		"ColorActive"
#define CONF_COLOR_FROM			"ColorFrom"
#define CONF_COLOR_FROMWITHMAIL	"ColorFromWithMail"
#define CONF_COLOR_FROMWITHSAGE	"ColorFromWithSage"
#define CONF_COLOR_DATE			"ColorDate"
#define CONF_COLOR_DATENEW		"ColorDateNew"
#define CONF_COLOR_MESSAGE		"ColorMessage"
#define CONF_COLOR_LINK			"ColorLink"
#define CONF_COLOR_ABONE		"ColorAbone"

// L[
#define CONF_KEY_CANCEL			"KeyCancel"
#define CONF_KEY_ONLINE			"KeyOnline"
#define CONF_KEY_RELOAD			"KeyReload"
#define CONF_KEY_DELETE			"KeyDelete"
#define CONF_KEY_SEARCH			"KeySearch"
#define CONF_KEY_TOP			"KeyTop"
#define CONF_KEY_BOTTOM			"KeyBottom"
#define CONF_KEY_CLOSETAB		"KeyCloseTab"
#define CONF_KEY_NEXT			"KeyNext"
#define CONF_KEY_PREV			"KeyPrev"
#define CONF_KEY_NEXTLINK		"KeyNextLink"
#define CONF_KEY_PREVLINK		"KeyPrevLink"
#define CONF_KEY_MENU			"KeyMenu"
#define CONF_KEY_NEXTTAB		"KeyNextTab"
#define CONF_KEY_PREVTAB		"KeyPrevTab"
#define CONF_KEY_BACK			"KeyBack"
#define CONF_KEY_OPENBOOKMARK	"KeyOpenBookmark"
#define CONF_KEY_ADDBOOKMARK	"KeyAddBookmark"
#define CONF_KEY_SORT			"KeySort"
#define CONF_KEY_EDIT			"KeyEdit"
#define CONF_KEY_EDITREPLY		"KeyEditReply"
#define CONF_KEY_FIND2CH		"KeyFind2ch"
#define CONF_KEY_NEXTLINE		"KeyNextLine"
#define CONF_KEY_PREVLINE		"KeyPrevLine"
#define CONF_KEY_PAGEUP			"KeyPageUp"
#define CONF_KEY_PAGEDOWN		"KeyPageDown"
#define CONF_KEY_CURRENTSUBJECT	"KeyCurrentSubject"
#define CONF_KEY_TOGGLEABONE	"KeyToggleAbone"
#define CONF_KEY_TOGGLEWRAP		"KeyToggleWrap"
#define CONF_KEY_REOPEN			"KeyReopen"
#define CONF_KEY_CHANGEVIEW		"KeyChangeView"
#define CONF_KEY_GREPID			"KeyGrepId"
#define CONF_KEY_GREPNAME		"KeyGrepName"
#define CONF_KEY_GREPREFER		"KeyGrepRefer"

// NG[h
#define CONF_TRANSPARENTABONE	"TransParentAbone"

// 
#define CONF_USEDEFAULTTEMPLATE	"UseDefaultTemplate"
#define CONF_FOCUSONMESSAGE		"FocusOnMessage"

// ̑
#define CONF_DELETEBLANKLINES	"DeleteBlankLines"
#define CONF_NEXTCONTROL		"NextControl"

// n
#define CONF_HISTORY_NAME		"HistoryName"
#define CONF_HISTORY_MAIL		"HistoryMail"
#define CONF_HISTORY_SEARCHWORD	"HistorySearchWord"

// J
#define CONF_COLUMNWIDTH_BOOKMARK	"ColumnWidthBookmark"
#define CONF_COLUMNWIDTH_SUBJECT	"ColumnWidthSubject"
#define CONF_COLUMNWIDTH_CACHE		"ColumnWidthCache"

// \[g
#define CONF_SORTCOLUMN_BOOKMARK	"SortColumnBookmark"
#define CONF_SORTCOLUMN_SUBJECT		"SortColumnSubject"
#define CONF_SORTCOLUMN_CACHE		"SortColumnCache"
#define CONF_SORTASC_BOOKMARK		"SortAscBookmark"
#define CONF_SORTASC_SUBJECT		"SortAscSubject"
#define CONF_SORTASC_CACHE			"SortAscCache"

// oϐAQb^[AZb^[`}N
#define PROPERTY(var, type, argtype, conf) \
private: \
	type var; \
public: \
	argtype Get##var(){ return var; } \
	void Set##var(argtype v){ if (var != v) {var = v; write(conf, v);} }

#define PROPERTY_KEY(var, type, argtype, conf) \
private: \
	type var; \
	type Sub##var; \
public: \
	argtype Get##var(){ return var; } \
	argtype GetSub##var(){ return Sub##var; } \
	void Set##var(argtype v){ if (v != 0 && var != v) {var = v; write(conf, v);} } \
	void SetSub##var(argtype v){ if (v != 0 && Sub##var != v) {Sub##var = v; write("Sub"conf, v);} } \
	BOOL Is##var(argtype v){ return (v == var || v == Sub##var); }

#define PROPERTY_DIR(var, conf) \
private: \
	CYoString var; \
public: \
	const char *Get##var(){ return var; } \
	void Set##var(const char *v){ \
		if (var != v) { \
			var = v; \
			while (var.Right(1) == "\\") { \
				var.Remove(var.Length() - 1); \
			} \
			write(conf, (const char*)var);} \
		}

#define PROPERTY_HISTORY(var, max, conf) \
private: \
	CYoDataArray var; \
public: \
	int Get##var##Count(){ return var.Count(); } \
	const char *Get##var(int i){ return var.Get(i); } \
	void Add##var(const char *v) \
	{ \
		for (int i = 0; i < var.Count(); i++) { \
			if (strcmp(var.Get(i), v) == 0) { \
				var.Remove(i); \
				i--; \
			} \
		} \
		var.Insert(0, v); \
		if (var.Count() > max) var.Remove(var.Count() - 1); \
		write(conf, var); \
	}

#define PROPERTY_INTARRAY(var, conf) \
private: \
	CYoPtrArray var; \
public: \
	int Get##var##Count(){ return var.Count(); } \
	int Get##var(int i){ return (int)var.Get(i); } \
	void Set##var(CYoPtrArray &a) \
	{ \
		var.RemoveAll(); \
		var = a; \
		write(conf, var); \
	}

class Cq2chwmConfig
{
private:
	static Cq2chwmConfig *m_pInstance;
	CYoString m_str_filename;			// ݒt@C̃pX

	// VXe
	PROPERTY_DIR(RootDirectory, CONF_ROOTDIR);							// q2ch[gfBNg
	PROPERTY(BoardUrl, CYoString, const char*, CONF_BOARDURL);			// board.txtURL
	PROPERTY(Browser, CYoString, const char*, CONF_BROWSER);			// uEU
	PROPERTY(ThreadMax, int, int, CONF_THREADMAX);						// 񎞍őXbh
	PROPERTY(TabMax, int, int, CONF_TABMAX);							// ő^u
	PROPERTY(TabWidth, int, int, CONF_TABWIDTH);						// ő^u
	PROPERTY(Online, BOOL, BOOL, CONF_ONLINE);							// IC/ItC
	PROPERTY(Debug, BOOL, BOOL, CONF_DEBUG);							// IC/ItC

	// lbg[N
	PROPERTY(ProxyUse, BOOL, BOOL, CONF_PROXY_USE);						// vLVgptO
	PROPERTY(ProxyUseWrite, BOOL, BOOL, CONF_PROXY_USEWRITE);					// ݎvLVgptO
	PROPERTY(ProxyHost, CYoString, const char*, CONF_PROXY_HOST);		// vLVzXg
	PROPERTY(ProxyPort, int, int, CONF_PROXY_PORT);						// vLV|[gԍ
	PROPERTY(ProxyId, CYoString, const char*, CONF_PROXY_ID);			// vLVID
	PROPERTY(ProxyPass, CYoString, const char*, CONF_PROXY_PASS);		// vLVPASS
	PROPERTY(DoLibId, CYoString, const char*, CONF_DOLIB_ID);;			// DOLIB ID
	PROPERTY(DoLibPass, CYoString, const char*, CONF_DOLIB_PASS);		// DOLIB PASS
	PROPERTY(DoLibSid, CYoString, const char*, CONF_DOLIB_SID);			// DOLIB ZbVID
	PROPERTY(Sage, BOOL, BOOL, CONF_SAGE);								// sage

	// tHg
	PROPERTY(FontNameList, CYoString, const char*, CONF_FONTNAME_LIST);			// List
	PROPERTY(FontNameBoard, CYoString, const char*, CONF_FONTNAME_BOARD);		// Board
	PROPERTY(FontNameMessage, CYoString, const char*, CONF_FONTNAME_MESSAGE);	// Message
	PROPERTY(FontNameCache, CYoString, const char*, CONF_FONTNAME_CACHE);		// Cache
	PROPERTY(FontNameBookmark, CYoString, const char*, CONF_FONTNAME_BOOKMARK);	// Bookmark
	PROPERTY(FontNameTab, CYoString, const char*, CONF_FONTNAME_TAB);			// ^u
	PROPERTY(FontNameArticle, CYoString, const char*, CONF_FONTNAME_ARTICLE);	// Article
	PROPERTY(FontSizeList, int, int, CONF_FONTSIZE_LIST);			// List
	PROPERTY(FontSizeBoard, int, int, CONF_FONTSIZE_BOARD);			// Board
	PROPERTY(FontSizeMessage, int, int, CONF_FONTSIZE_MESSAGE);		// Message
	PROPERTY(FontSizeCache, int, int, CONF_FONTSIZE_CACHE);			// Cache
	PROPERTY(FontSizeBookmark, int, int, CONF_FONTSIZE_BOOKMARK);	// Bookmark
	PROPERTY(FontSizeTab, int, int, CONF_FONTSIZE_TAB);				// ^u
	PROPERTY(FontSizeArticle, int, int, CONF_FONTSIZE_ARTICLE);		// Article
	PROPERTY(FontBoldList, BOOL, BOOL, CONF_FONTBOLD_LIST);			// List
	PROPERTY(FontBoldBoard, BOOL, BOOL, CONF_FONTBOLD_BOARD);			// Board
	PROPERTY(FontBoldMessage, BOOL, BOOL, CONF_FONTBOLD_MESSAGE);		// Message
	PROPERTY(FontBoldCache, BOOL, BOOL, CONF_FONTBOLD_CACHE);			// Cache
	PROPERTY(FontBoldBookmark, BOOL, BOOL, CONF_FONTBOLD_BOOKMARK);	// Bookmark
	PROPERTY(FontBoldTab, BOOL, BOOL, CONF_FONTBOLD_TAB);				// ^u
	PROPERTY(FontBoldArticle, BOOL, BOOL, CONF_FONTBOLD_ARTICLE);		// Article

	// F
	PROPERTY(ColorFore, int, int, CONF_COLOR_FORE);
	PROPERTY(ColorBack, int, int, CONF_COLOR_BACK);
	PROPERTY(ColorCache, int, int, CONF_COLOR_CACHE);
	PROPERTY(ColorNew, int, int, CONF_COLOR_NEW);
	PROPERTY(ColorError, int, int, CONF_COLOR_ERROR);
	PROPERTY(ColorSearch, int, int, CONF_COLOR_SEARCH);
	PROPERTY(ColorActive, int, int, CONF_COLOR_ACTIVE);
	PROPERTY(ColorFrom, int, int, CONF_COLOR_FROM);
	PROPERTY(ColorFromWithMail, int, int, CONF_COLOR_FROMWITHMAIL);
	PROPERTY(ColorFromWithSage, int, int, CONF_COLOR_FROMWITHSAGE);
	PROPERTY(ColorDate, int, int, CONF_COLOR_DATE);
	PROPERTY(ColorDateNew, int, int, CONF_COLOR_DATENEW);
	PROPERTY(ColorMessage, int, int, CONF_COLOR_MESSAGE);
	PROPERTY(ColorLink, int, int, CONF_COLOR_LINK);
	PROPERTY(ColorAbone, int, int, CONF_COLOR_ABONE);

	// L[
	PROPERTY_KEY(KeyCancel, int, int, CONF_KEY_CANCEL);
	PROPERTY_KEY(KeyOnline, int, int, CONF_KEY_ONLINE);
	PROPERTY_KEY(KeyReload, int, int, CONF_KEY_RELOAD);
	PROPERTY_KEY(KeyDelete, int, int, CONF_KEY_DELETE);
	PROPERTY_KEY(KeySearch, int, int, CONF_KEY_SEARCH);
	PROPERTY_KEY(KeyTop, int, int, CONF_KEY_TOP);
	PROPERTY_KEY(KeyBottom, int, int, CONF_KEY_BOTTOM);
	PROPERTY_KEY(KeyCloseTab, int, int, CONF_KEY_CLOSETAB);
	PROPERTY_KEY(KeyNext, int, int, CONF_KEY_NEXT);
	PROPERTY_KEY(KeyPrev, int, int, CONF_KEY_PREV);
	PROPERTY_KEY(KeyNextLink, int, int, CONF_KEY_NEXTLINK);
	PROPERTY_KEY(KeyPrevLink, int, int, CONF_KEY_PREVLINK);
	PROPERTY_KEY(KeyMenu, int, int, CONF_KEY_MENU);
	PROPERTY_KEY(KeyNextTab, int, int, CONF_KEY_NEXTTAB);
	PROPERTY_KEY(KeyPrevTab, int, int, CONF_KEY_PREVTAB);
	PROPERTY_KEY(KeyBack, int, int, CONF_KEY_BACK);
	PROPERTY_KEY(KeyOpenBookmark, int, int, CONF_KEY_OPENBOOKMARK);
	PROPERTY_KEY(KeyAddBookmark, int, int, CONF_KEY_ADDBOOKMARK);
	PROPERTY_KEY(KeySort, int, int, CONF_KEY_SORT);
	PROPERTY_KEY(KeyEdit, int, int, CONF_KEY_EDIT);
	PROPERTY_KEY(KeyEditReply, int, int, CONF_KEY_EDITREPLY);
	PROPERTY_KEY(KeyFind2ch, int, int, CONF_KEY_FIND2CH);
	PROPERTY_KEY(KeyNextLine, int, int, CONF_KEY_NEXTLINE);
	PROPERTY_KEY(KeyPrevLine, int, int, CONF_KEY_PREVLINE);
	PROPERTY_KEY(KeyPageUp, int, int, CONF_KEY_PAGEUP);
	PROPERTY_KEY(KeyPageDown, int, int, CONF_KEY_PAGEDOWN);
	PROPERTY_KEY(KeyCurrentSubject, int, int, CONF_KEY_CURRENTSUBJECT);
	PROPERTY_KEY(KeyToggleAbone, int, int, CONF_KEY_TOGGLEABONE);
	PROPERTY_KEY(KeyToggleWrap, int, int, CONF_KEY_TOGGLEWRAP);
	PROPERTY_KEY(KeyReopen, int, int, CONF_KEY_REOPEN);
	PROPERTY_KEY(KeyChangeView, int, int, CONF_KEY_CHANGEVIEW);
	PROPERTY_KEY(KeyGrepId, int, int, CONF_KEY_GREPID);
	PROPERTY_KEY(KeyGrepName, int, int, CONF_KEY_GREPNAME);
	PROPERTY_KEY(KeyGrepRefer, int, int, CONF_KEY_GREPREFER);

	// NG[h
	PROPERTY(TransParentAbone, BOOL, BOOL, CONF_TRANSPARENTABONE);

	// 
	PROPERTY(UseDefaultTemplate, BOOL, BOOL, CONF_USEDEFAULTTEMPLATE);
	PROPERTY(FocusOnMessage, BOOL, BOOL, CONF_FOCUSONMESSAGE);

	// ̑
	PROPERTY(DeleteBlankLines, BOOL, BOOL, CONF_DELETEBLANKLINES);
	PROPERTY(NextControl, BOOL, BOOL, CONF_NEXTCONTROL);

	// ŕۑ
	PROPERTY_HISTORY(HistoryName, 30, CONF_HISTORY_NAME);
	PROPERTY_HISTORY(HistoryMail, 30, CONF_HISTORY_MAIL);
	PROPERTY_HISTORY(HistorySearchWord, 30, CONF_HISTORY_SEARCHWORD);

	// J
	PROPERTY_INTARRAY(ColumnWidthBookmark, CONF_COLUMNWIDTH_BOOKMARK);
	PROPERTY_INTARRAY(ColumnWidthSubject, CONF_COLUMNWIDTH_SUBJECT);
	PROPERTY_INTARRAY(ColumnWidthCache, CONF_COLUMNWIDTH_CACHE);

	// \[g
	PROPERTY(SortColumnBookmark, int, int, CONF_SORTCOLUMN_BOOKMARK);
	PROPERTY(SortColumnSubject, int, int, CONF_SORTCOLUMN_SUBJECT);
	PROPERTY(SortColumnCache, int, int, CONF_SORTCOLUMN_CACHE);
	PROPERTY(SortAscBookmark, BOOL, BOOL, CONF_SORTASC_BOOKMARK);
	PROPERTY(SortAscSubject, BOOL, BOOL, CONF_SORTASC_SUBJECT);
	PROPERTY(SortAscCache, BOOL, BOOL, CONF_SORTASC_CACHE);

	Cq2chwmConfig(const char *chp_filename);
	static void Delete();

	void write(const char *chp_name, const char *chp_value);
	void write(const char *chp_name, int in_value);
	void write(const char *chp_name, CYoDataArray& cArray);
	void write(const char *chp_name, CYoPtrArray& cArray);
	void readKeyConf();

public:
	static Cq2chwmConfig *GetInstance();

	~Cq2chwmConfig();
	void SetConfigKey(const Cq2chwmConfigKey &cConfigKey);

};

#define KEYITEM(text, conf, name) \
	{text, conf, "Sub"conf, Cq2chwmConfig::GetInstance()->Get##name(), Cq2chwmConfig::GetInstance()->GetSub##name(), FALSE, FALSE}

class Cq2chwmConfigKey
{
private:
	struct _key_list {
		char cha_name[64];
		char cha_conf_name[64];
		char cha_conf_name_sub[64];
		int in_code;
		int in_code_sub;
		BOOL bo_changed;
		BOOL bo_changed_sub;
	};
	struct _key_list *m_stp_key_list;
	int m_in_count;

public:
	Cq2chwmConfigKey()
	{
	struct _key_list sta_key_list[] = {
		KEYITEM("LZ", CONF_KEY_CANCEL, KeyCancel),
		KEYITEM("j[", CONF_KEY_MENU, KeyMenu),
		KEYITEM("On/Off", CONF_KEY_ONLINE, KeyOnline),
		KEYITEM("[h", CONF_KEY_RELOAD, KeyReload),
		KEYITEM("폜", CONF_KEY_DELETE, KeyDelete),
		KEYITEM("Q˂錟", CONF_KEY_FIND2CH, KeyFind2ch),
		KEYITEM("", CONF_KEY_SEARCH, KeySearch),
		KEYITEM("IDo", CONF_KEY_GREPID, KeyGrepId),
		KEYITEM("Oo", CONF_KEY_GREPNAME, KeyGrepName),
		KEYITEM("탌Xo", CONF_KEY_GREPREFER, KeyGrepRefer),
		KEYITEM("", CONF_KEY_TOP, KeyTop),
		KEYITEM("", CONF_KEY_BOTTOM, KeyBottom),
		KEYITEM("\[g", CONF_KEY_SORT, KeySort),
		KEYITEM("XN[", CONF_KEY_PREVLINE, KeyPrevLine),
		KEYITEM("XN[", CONF_KEY_NEXTLINE, KeyNextLine),
//		{"N", CONF_KEYGOTOURL, Cq2chwmConfig::GetInstance()->GetKeyGotoUrl(), FALSE},
//		{"VKXbh쐬", CONF_KEYCREATETHREAD, Cq2chwmConfig::GetInstance()->GetKeyCreateThread(), FALSE},
//		{"S\", CONF_KEYVIEWLOGO, Cq2chwmConfig::GetInstance()->GetKeyViewLogo(), FALSE},
//		{"ۑ", CONF_KEYIMAGESAVE, Cq2chwmConfig::GetInstance()->GetKeyImageSave(), FALSE},
//		{"XN[(Article)", CONF_KEYAPAGEUP, Cq2chwmConfig::GetInstance()->GetKeyArticleUp(), FALSE},
//		{"XN[(Article)", CONF_KEYAPAGEDOWN, Cq2chwmConfig::GetInstance()->GetKeyArticleDown(), FALSE},
		KEYITEM("y[WAbv", CONF_KEY_PAGEUP, KeyPageUp),
		KEYITEM("y[W_E", CONF_KEY_PAGEDOWN, KeyPageDown),
		KEYITEM("̃bZ[W", CONF_KEY_NEXT, KeyNext),
		KEYITEM("ÕbZ[W", CONF_KEY_PREV, KeyPrev),
		KEYITEM("̃N", CONF_KEY_NEXTLINK, KeyNextLink),
		KEYITEM("ÕN", CONF_KEY_PREVLINK, KeyPrevLink),
		KEYITEM("Nֈړ", CONF_KEY_BACK, KeyBack),
		KEYITEM("̃^u", CONF_KEY_NEXTTAB, KeyNextTab),
		KEYITEM("Õ^u", CONF_KEY_PREVTAB, KeyPrevTab),
//		{"̃ubN}[N", CONF_KEYNEXTBOOKMARK, Cq2chwmConfig::GetInstance()->GetKeyNextBookmark(), FALSE},
		KEYITEM("\X̔ꗗ", CONF_KEY_CURRENTSUBJECT, KeyCurrentSubject),
		KEYITEM("^u", CONF_KEY_CLOSETAB, KeyCloseTab),
		KEYITEM("ځ[", CONF_KEY_TOGGLEABONE, KeyToggleAbone),
		KEYITEM("܂Ԃ", CONF_KEY_TOGGLEWRAP, KeyToggleWrap),
		KEYITEM("ēǂݍ", CONF_KEY_REOPEN, KeyReopen),
//		{"tHg؂ւ", CONF_KEYCHANGEAFONT, Cq2chwmConfig::GetInstance()->GetKeyChangeAFont(), FALSE},
		KEYITEM("bZ[W쐬", CONF_KEY_EDIT, KeyEdit),
		KEYITEM("bZ[W쐬(ԐM)", CONF_KEY_EDITREPLY, KeyEditReply),
//		{"M", CONF_KEYSEND, Cq2chwmConfig::GetInstance()->GetKeySend(), FALSE},
		KEYITEM("ubN}[N", CONF_KEY_OPENBOOKMARK, KeyOpenBookmark),
		KEYITEM("ubN}[Nǉ", CONF_KEY_ADDBOOKMARK, KeyAddBookmark),
//		{"ubN}[N\t", CONF_KEYPASTEBOOKMARK, Cq2chwmConfig::GetInstance()->GetKeyPasteBookmark(), FALSE},
		KEYITEM("r[؂ւ", CONF_KEY_CHANGEVIEW, KeyChangeView),
	};
	m_stp_key_list = (struct _key_list*)malloc(sizeof(sta_key_list));
	memcpy(m_stp_key_list, &sta_key_list, sizeof(sta_key_list));
	m_in_count = sizeof(sta_key_list)/sizeof(sta_key_list[0]);
	}
	~Cq2chwmConfigKey(){ free(m_stp_key_list); }
	inline const char *GetName(int in_index) const {return m_stp_key_list[in_index].cha_name;}
	inline const char *GetConfName(int in_index) const {return m_stp_key_list[in_index].cha_conf_name;}
	inline const char *GetSubConfName(int in_index) const {return m_stp_key_list[in_index].cha_conf_name_sub;}
	inline int GetCode(int in_index) const {return m_stp_key_list[in_index].in_code;}
	inline int GetSubCode(int in_index) const {return m_stp_key_list[in_index].in_code_sub;}
	inline BOOL GetChanged(int in_index) const {return m_stp_key_list[in_index].bo_changed;}
	inline BOOL GetSubChanged(int in_index) const {return m_stp_key_list[in_index].bo_changed_sub;}
	inline void SetCode(int in_index, int in_code)
	{
		if (m_stp_key_list[in_index].in_code == in_code) return;
		m_stp_key_list[in_index].in_code = in_code;
		m_stp_key_list[in_index].bo_changed = TRUE;
	}
	inline void SetSubCode(int in_index, int in_code)
	{
		if (m_stp_key_list[in_index].in_code_sub == in_code) return;
		m_stp_key_list[in_index].in_code_sub = in_code;
		m_stp_key_list[in_index].bo_changed_sub = TRUE;
	}
	const char *GetCodeName(unsigned char uc_code);
	void Write();
	inline int Count() const {return m_in_count;}
};
