// q2chwmSearchDialog.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmSearchDialog.h"
#include "q2chwmLayoutManager.h"
#include "q2chwmConfig.h"

// Cq2chwmSearchDialog _CAO

IMPLEMENT_DYNAMIC(Cq2chwmSearchDialog, CDialog)

Cq2chwmSearchDialog::Cq2chwmSearchDialog(CWnd* pParent /*=NULL*/)
	: CDialog(Cq2chwmSearchDialog::IDD, pParent)
	, m_cstr_word(_T(""))
{
}

Cq2chwmSearchDialog::~Cq2chwmSearchDialog()
{
}

void Cq2chwmSearchDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_CBString(pDX, IDC_COMBO_SEARCH, m_cstr_word);
}


BEGIN_MESSAGE_MAP(Cq2chwmSearchDialog, CDialog)
	ON_WM_SIZE()
	ON_WM_SHOWWINDOW()
	ON_BN_CLICKED(IDC_BUTTON_CLOSE, &Cq2chwmSearchDialog::OnBnClickedButtonClose)
	ON_BN_CLICKED(IDC_BUTTON_NEXT, &Cq2chwmSearchDialog::OnBnClickedButtonNext)
	ON_BN_CLICKED(IDC_BUTTON_PREV, &Cq2chwmSearchDialog::OnBnClickedButtonPrev)
	ON_BN_CLICKED(IDC_BUTTON_FIND, &Cq2chwmSearchDialog::OnBnClickedButtonFind)
END_MESSAGE_MAP()


// Cq2chwmSearchDialog bZ[W nh

void Cq2chwmSearchDialog::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (m_cButtonNext.m_hWnd != NULL) {
		if (m_bo_updownbutton == TRUE) {
			Cq2chwmLayoutManager cLayout(
				new Cq2chwmLayoutLine(
				GetDlgItem(IDC_COMBO_SEARCH), 4,
				&m_cButtonNext, 1,
				&m_cButtonPrev, 1,
				&m_cButtonClose, 1)
			);
			cLayout.Layout(cx, cy);
		} else {
			Cq2chwmLayoutManager cLayout(
				new Cq2chwmLayoutLine(
				GetDlgItem(IDC_COMBO_SEARCH), 5,
				&m_cButtonFind, 1,
				&m_cButtonClose, 1)
			);
			cLayout.Layout(cx, cy);
		}
	}
}

void Cq2chwmSearchDialog::OnOK()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	OnBnClickedButtonNext();

	//CDialog::OnOK();
}

void Cq2chwmSearchDialog::OnCancel()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	GetParent()->SendMessage(WM_USER_SHOWSEARCHBAR, 0, (LPARAM)FALSE);

	//CDialog::OnCancel();
}

BOOL Cq2chwmSearchDialog::PreTranslateMessage(MSG* pMsg)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	if (pMsg->message == WM_KEYDOWN && pMsg->wParam == 0x0d) {
		if (GetFocus() == GetDlgItem(IDC_COMBO_SEARCH)) {
			OnOK();
			return TRUE;
		} else if (GetFocus() == GetDlgItem(IDC_BUTTON_CLOSE)) {
			OnBnClickedButtonClose();
			return TRUE;
		} else if (GetFocus() == GetDlgItem(IDC_BUTTON_NEXT)) {
			OnBnClickedButtonNext();
			return TRUE;
		} else if (GetFocus() == GetDlgItem(IDC_BUTTON_PREV)) {
			OnBnClickedButtonPrev();
			return TRUE;
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void Cq2chwmSearchDialog::SetFocus()
{
	GetDlgItem(IDC_COMBO_SEARCH)->SetFocus();
}

void Cq2chwmSearchDialog::SetUpDownButton(
	BOOL bo_updownbutton)
{
	m_bo_updownbutton = bo_updownbutton;
	if (m_bo_updownbutton == TRUE) {
		m_cButtonNext.ShowWindow(SW_SHOW);
		m_cButtonPrev.ShowWindow(SW_SHOW);
		m_cButtonFind.ShowWindow(SW_HIDE);
	} else {
		m_cButtonNext.ShowWindow(SW_HIDE);
		m_cButtonPrev.ShowWindow(SW_HIDE);
		m_cButtonFind.ShowWindow(SW_SHOW);
	}
}

void Cq2chwmSearchDialog::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CDialog::OnShowWindow(bShow, nStatus);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (bShow == TRUE && GetDlgItem(IDC_COMBO_SEARCH)->IsWindowVisible() == TRUE) {
		GetDlgItem(IDC_COMBO_SEARCH)->SetFocus();
	}
}

#define ICONSIZE	32
#define BUTTONSIZE	36
BOOL Cq2chwmSearchDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	if (m_cButtonNext.Create(IDI_ICON_NEXT, ICONSIZE, ICONSIZE, CRect(0, 0, BUTTONSIZE, BUTTONSIZE), this, IDC_BUTTON_NEXT) == FALSE ||
		m_cButtonPrev.Create(IDI_ICON_PREV, ICONSIZE, ICONSIZE, CRect(0, 0, BUTTONSIZE, BUTTONSIZE), this, IDC_BUTTON_PREV) == FALSE ||
		m_cButtonFind.Create(IDI_ICON_FIND, ICONSIZE, ICONSIZE, CRect(0, 0, BUTTONSIZE, BUTTONSIZE), this, IDC_BUTTON_FIND) == FALSE ||
		m_cButtonClose.Create(IDI_ICON_CLOSE, ICONSIZE, ICONSIZE, CRect(0, 0, BUTTONSIZE, BUTTONSIZE), this, IDC_BUTTON_CLOSE) == FALSE)
	{
		return FALSE;
	}
	m_cButtonClose.ShowWindow(SW_SHOW);

	// Zbg
	CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_SEARCH);
	for (int i = 0; i < Cq2chwmConfig::GetInstance()->GetHistorySearchWordCount(); i++) {
		CString cstr_value;
		cstr_value = Cq2chwmConfig::GetInstance()->GetHistorySearchWord(i);
		pCombo->InsertString(i, cstr_value);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmSearchDialog::OnBnClickedButtonClose()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	OnCancel();
}

void Cq2chwmSearchDialog::OnBnClickedButtonNext()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	UpdateData(TRUE);
	if (m_cstr_word.GetLength() > 0) {
		GetParent()->SendMessage(WM_USER_EXECSEARCH, 0, (LPARAM)(const wchar_t*)m_cstr_word);
	}
}

void Cq2chwmSearchDialog::OnBnClickedButtonPrev()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	UpdateData(TRUE);
	if (m_cstr_word.GetLength() > 0) {
		GetParent()->SendMessage(WM_USER_EXECSEARCH, 1, (LPARAM)(const wchar_t*)m_cstr_word);
	}
}

void Cq2chwmSearchDialog::OnBnClickedButtonFind()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	UpdateData(TRUE);
	if (m_cstr_word.GetLength() > 0) {
		GetParent()->SendMessage(WM_USER_EXECSEARCH, 1, (LPARAM)(const wchar_t*)m_cstr_word);
	}
}
