#pragma once

#include "nEdit.h"
class Cq2chwmEditCtrl

{
public:
	enum
	{
		COLOR_FROM = 1,
		COLOR_FROM_WITHMAIL,
		COLOR_FROM_WITHSAGE,
		COLOR_NEW,
		COLOR_DATE,
		COLOR_LINK,
		COLOR_ABONE,
		COLOR_MESSAGE,

		COLOR_MAX,
	};

private:
	HWND m_hWnd;
	CFont m_cFont;
	CYoString m_str_fontname;
	int m_in_fontsize;

public:
	static void Regist(const HINSTANCE hInstance);
	static void ClearCache(){ nedit_clear_cache(); }
	Cq2chwmEditCtrl();
	~Cq2chwmEditCtrl();

	// EBhEn
	BOOL Create(CWnd *pParent, int x, int y, int cx, int cy);
	void SetFocus();
	BOOL MoveWindow(int x, int y, int cx, int cy);
	BOOL ShowWindow(int in_cmd);
	void ScrollVertical(BOOL bo_next, int in_num);
	void ScrollHorizontal(BOOL bo_next, int in_num);

	// eLXgn
	void SetText(const char *chp_text, int in_len);
	void AddText(const char *chp_text, int in_len);
	void SetWrap(BOOL bo_flg);
	void SetFont(const char *chp_name, int in_size);
	void SetColor(COLORREF *pColors);
	void SetColorFore(COLORREF color){ ::SendMessage(m_hWnd, Q2CH_SETCOLOR_FORE, color, 0); }
	void SetColorBack(COLORREF color){ ::SendMessage(m_hWnd, Q2CH_SETCOLOR_BACK, color, 0); }
	void SetColorFrom(COLORREF color){ ::SendMessage(m_hWnd, Q2CH_SETCOLOR_FROM, color, 0); }
	void SetColorFromWithMail(COLORREF color){ ::SendMessage(m_hWnd, Q2CH_SETCOLOR_FROMWITHMAIL, color, 0); }
	void SetColorFromWithSage(COLORREF color){ ::SendMessage(m_hWnd, Q2CH_SETCOLOR_FROMWITHSAGE, color, 0); }
	void SetColorNew(COLORREF color){ ::SendMessage(m_hWnd, Q2CH_SETCOLOR_NEW, color, 0); }
	void SetColorDate(COLORREF color){ ::SendMessage(m_hWnd, Q2CH_SETCOLOR_DATE, color, 0); }
	void SetColorLink(COLORREF color){ ::SendMessage(m_hWnd, Q2CH_SETCOLOR_LINK, color, 0); }
	void SetColorAbone(COLORREF color){ ::SendMessage(m_hWnd, Q2CH_SETCOLOR_ABONE, color, 0); }
	void SetColorMessage(COLORREF color){ ::SendMessage(m_hWnd, Q2CH_SETCOLOR_MESSAGE, color, 0); }
	BOOL GetSelectedString(CString& cstr_text);
	void SetAutoUpdate(BOOL bo_update);
	void Clear();
	void Copy();

	// sn
	int GetLines();
	int GetVisibleLines();
	int GetLineLength();
	BOOL GetLineString(int in_line, CString& cstr_line);
	BOOL IsEndOfLine(int in_line);
	BOOL IsVisibleLine(int in_line);
	void SetTopLine(int in_line);
	int GetTopLine();
	//void SetLineText(const char *chp_text, int in_line, int in_start = 0);
	TCHAR *GetLine(int in_line);

	// 
	BOOL SearchNext(const char *chp_pat, BOOL bo_visible = FALSE);
	BOOL SearchPrev(const char *chp_pat, BOOL bo_visible = FALSE);

	// Cxg
	void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);

private:
	void SetSelection(int in_row_s, int in_row_e, int in_col_s, int in_col_e);
	void GetSelection(int& in_row_s, int& in_row_e, int& in_col_s, int& in_col_e);

};
