#include "StdAfx.h"
#include "YoTime.h"
#include "q2chwmDatFile.h"
#include "q2chwmEditCtrl.h"
#include "q2chwmCommon.h"
#include "q2chwmArticleFile.h"
#include "q2chwmInfoFile.h"

#define MSG_SEPARATOR			"\n\n"
#define MSG_SEPARATOR_LEN		2

Cq2chwmDatFile::Cq2chwmDatFile()
{
}

Cq2chwmDatFile::~Cq2chwmDatFile()
{
}

int Cq2chwmDatFile::Count(
	const char *chp_dat)
{
	CYoTime cTime;
	FILE *fp = fopen(chp_dat, "rb");
	if (fp == NULL) {
		PRINTLOG("error %s(%d)", chp_dat, ::GetLastError());
		return -1;
	}
	char cha_line[1024 * 16];
	int in_count = 0;
	int in_read;
	while ((in_read = fread(cha_line, sizeof(char), sizeof(cha_line)-1, fp)) > 0) {
		cha_line[in_read] = 0x00;
		char *chp_lf = cha_line;
		while ((chp_lf = strchr(chp_lf, '\n')) != NULL) {
			in_count++;
			chp_lf++;
		}
	}
	fclose(fp);
	PRINTLOG("done [%s]%d(msec)", chp_dat, cTime.Elapsed());
	return in_count;
}

//! DAT`r[`ɕϊ
/*!
 * DAT`: O<>[AhX<>t<>Rg<>Xbh\n
 * 
 * r[`: [Xԍ]O<[AhX>\nt\nRg\n
 * ɕϊ
 * XbhDATt@C1sڂ̂
 * chp_srcɂ͕̃XĂ悢K\nŏI邱(r[ȃXȂ)
 * \param str_name ()Xbh
 * \param chp_dst r[`̏݃AhX(\ȃmۂKv)
 * \param chp_src DAT`
 * \param in_msg JnXԍ
 * \param uin_new JnVXԍ(̒lȏ̃XԍVƂȂ)
 * \param pRegex NG[hK\(}b`X͂ځ[񂳂)
 * \param bl_localabone [Jځ[tO(FALSEœځ[)
 * \param pHideArray ځ[񃁃bZ[W̃XԔz
 * \param pImportantArray NG[hK\Ƀ}b`Ă̔zɓXԂ͂ځ[񂳂Ȃ
 * \return int I: chp_dstɏ܂ꂽoCg ُI: -1
 */
int Cq2chwmDatFile::Convert(
	CYoString &str_name,
	char *chp_dst,
	const char *chp_src,
	int in_msg,
	unsigned int uin_new,
	CYoRegex *pRegex,
	BOOL bl_localabone,
	CYoPtrArray *pHideArray,
	CYoPtrArray *pImportantArray)
{
	if( chp_dst == NULL || chp_src == NULL ){
		return -1;
	}

	char *chp_outp = chp_dst;
	char *chp_inp = (char*)chp_src;
	char *chp_sta = chp_inp;
	char *chp_end;
	int in_len;

	while( *chp_sta != 0x00 ){
		char *chp_tmp = chp_outp;

		// From ʂ̂
		*chp_outp = Cq2chwmEditCtrl::COLOR_FROM;
		chp_outp++;

		chp_outp += sprintf( chp_outp, "[%d]", in_msg );

		for( int i = 0; i < 3; i++ ){
			chp_end = strstr( chp_sta, "<>" );
			if( chp_end == NULL ){
				*chp_outp = 0x00;
				return chp_outp - chp_dst;
			}
			in_len = chp_end - chp_sta;
			switch( i ){
			case 0:		// O
				while( chp_sta < chp_end ){
					encodeTag( &chp_outp, (const char**)&chp_sta );
				}
				break;
			case 1:		// email
				*chp_outp = '<';
				chp_outp++;
				while( chp_sta < chp_end ){
					encodeTag( &chp_outp, (const char**)&chp_sta );
				}
				if (strncmp(chp_outp - 4, "sage", 4) == 0) {
					*chp_tmp = Cq2chwmEditCtrl::COLOR_FROM_WITHSAGE;
				} else if (*(chp_outp - 1) != '<') {
					*chp_tmp = Cq2chwmEditCtrl::COLOR_FROM_WITHMAIL;
				}
				strcpy( chp_outp, ">\n" );
				chp_outp += 2;
				break;
			case 2:		// t
				*chp_outp = (unsigned int)(in_msg) >= uin_new ? Cq2chwmEditCtrl::COLOR_NEW : Cq2chwmEditCtrl::COLOR_DATE;
				chp_outp++;
				while( chp_sta < chp_end ){
				    encodeTag( &chp_outp, (const char**)&chp_sta);
				}
				*chp_outp = '\n';
				chp_outp++;
				break;
			}
			chp_sta = chp_end + 2;
			if( *chp_sta == ' ' ) chp_sta++;
			if( *chp_sta == '\n' ) break;
		}
		// bZ[W
		while( *chp_sta != 0x00 && *chp_sta != '\n' ){
			if( *chp_sta == '<' ){
				if( *(chp_sta+1) == '>' ){
					// bZ[W̏I
					char *chp_name = chp_sta + 2;
					chp_sta = strchr( chp_name, '\n' );
					if( chp_sta == NULL ){
						chp_sta = chp_name + strlen(chp_name);
					}
					if( in_msg == 1 && str_name == "" && chp_name != chp_sta ){
						// Xbh擾
						str_name.StrnCpy( chp_name, chp_sta-chp_name );
					}
					break;
				}else if( strncmp( chp_sta + 1, "br>", 3 ) == 0 ){
					if( *(chp_outp-1) == ' ' ) chp_outp--;
					*chp_outp = '\n';
					chp_outp++;
					chp_sta += 4;
					if( *chp_sta == ' ' ) chp_sta++;
				}else{
					char *chp_tmp = strchr( chp_sta, '>' );
					if( chp_tmp != NULL ){
						chp_sta = chp_tmp;
					}
					chp_sta++;
				}
			}else{
				encodeTag( &chp_outp, (const char**)&chp_sta );
			}
		}
		*chp_outp = 0x00;		// NULL^[~l[g

 		if( pRegex != NULL && pRegex->Match( chp_tmp ) >= 0 ){
			// importantXgɓĂ邩`FbN
			BOOL bo_exist_important = FALSE;
			if (pImportantArray != NULL) {
				for (int i = 0; i < pImportantArray->Count(); i++) {
					if (in_msg == (int)pImportantArray->Get(i)) {
						bo_exist_important = TRUE;
						break;
					}
				}
			}

			// importantXgɓĂ炠ځ[񂵂Ȃ
			if (bo_exist_important == FALSE) {
				if (bl_localabone) {
					*chp_tmp = Cq2chwmEditCtrl::COLOR_ABONE;
					chp_tmp++;
					chp_outp = chp_tmp; // ځ[
				} else {
					*chp_tmp = Cq2chwmEditCtrl::COLOR_ABONE;
				}
			}
		}

		// XԂɂ郍[Jځ[
		if (pHideArray != NULL) {
			for (int i = 0; i < pHideArray->Count(); i++) {
				if (in_msg == (int)pHideArray->Get(i)) {
					if (bl_localabone) {
						*chp_tmp = Cq2chwmEditCtrl::COLOR_ABONE;
						chp_tmp++;
						chp_outp = chp_tmp; // ځ[
					} else {
						*chp_tmp = Cq2chwmEditCtrl::COLOR_ABONE;
					}
					break;
				}
			}
		}

		in_msg++;

		if( *chp_sta == 0x00 ){
			break;
		}
		chp_sta++;
		strcpy( chp_outp, MSG_SEPARATOR );
		chp_outp += MSG_SEPARATOR_LEN;
	}

	// Ō̉s
	if( *(chp_outp - 1) == '\n' ){
		chp_outp--;
		*chp_outp = 0x00;
	}

	return chp_outp - chp_dst;
}

//! HTMLeLXgɕϊ
/*!
 * &gt; -> >
 * &lt; -> <
 * &amp; -> &
 * &nbsp; -> pXy[X
 * &quot; -> "
 * <.*>폜
 * \param *chp_dst 
 * \param *chp_src 
 * \return void 
 */
void Cq2chwmDatFile::encodeTag(
	char **chp_dst,
	const char **chp_src )
{
	if( **chp_src == '&' ){
		if( strncmp( *chp_src + 1, "gt;", 3 ) == 0 ){
			**chp_dst = '>';
			(*chp_dst)++;
			(*chp_src)+=4;
		}else if( strncmp( *chp_src + 1, "lt;", 3 ) == 0 ){
			**chp_dst = '<';
			(*chp_dst)++;
			(*chp_src)+=4;
		}else if( strncmp( *chp_src + 1, "amp;", 4 ) == 0 ){
			**chp_dst = '&';
			(*chp_dst)++;
			(*chp_src)+=5;
		}else if( strncmp( *chp_src + 1, "nbsp;", 5 ) == 0 ){
			**chp_dst = ' ';
			(*chp_dst)++;
			(*chp_src)+=6;
		}else if( strncmp( *chp_src + 1, "quot;", 5 ) == 0 ){
			**chp_dst = '"';
			(*chp_dst)++;
			(*chp_src) += 6;
		}else{
			**chp_dst = '&';
			(*chp_dst)++;
			(*chp_src)++;
		}
	}else if( **chp_src == '<' ){
		(*chp_src) = strchr( *chp_src, '>' );
		if( (*chp_src) == NULL ){
		  **chp_dst = **chp_src;
		  (*chp_dst)++;
		  (*chp_src)++;
		}else{
		  (*chp_src)++;
		}
	}else{
		**chp_dst = **chp_src;
		(*chp_dst)++;
		(*chp_src)++;
	}
}

//! As폜
/*!
 * strMaxBlankLinesȏ̉s΃bZ[W}ɁAs폜
 * \param str 
 * \return QString 
 */
/*
QString CQ2chDatFile::SqueeseBlankLines(
	QString str)
{
	int in_max_blines = CQ2chConfig::GetInstance()->GetMaxBlankLines();
	if(in_max_blines < 3){
		return str;
	}

	int index = 0;
	int length = 0;
	int ret = 0;
	QRegExp cRegex;
	cRegex.setPattern( "\\n\\n+" );
	while(ret != -1){
		ret = cRegex.match(str, index, &length);
		if(in_max_blines + 1 < length ){
			QString message;
			message.sprintf( "\n\n%c%d blank lines squeesed...\n\n", MESSAGE_KEY, length - in_max_blines - 1 );
			str = str.replace(ret, length, message );
		}
		index = ret + length;
	}

	return str;
}
*/

//! Datt@CXbh擾
/*!
 * Describe GetThread
 * K\gȂo[W
 * \param chp_filename Datt@C̃tpX
 * \return char* 
 */
BOOL Cq2chwmDatFile::GetName(
	CYoString &str_name,
	const char *chp_filename)
{
	FILE *fp = fopen(chp_filename, "r");
	if (fp == NULL) {
		return FALSE;
	}
	char cha_line[1024 * 16];
	CYoString str_line;
	cha_line[0] = 0x00;
	do {
		if (fgets(cha_line, sizeof(cha_line), fp) == NULL) {
			fclose( fp );
			return FALSE;
		}
		str_line += cha_line;
	} while (str_line.Find("\n") == -1);
	fclose(fp);
	str_line.Trim();
	const char *chp_sta = strrchr((const char*)str_line, '>');
	if (chp_sta == NULL) return FALSE;
	str_name = chp_sta + 1;
	str_name.Trim();

	return TRUE;
}

BOOL Cq2chwmDatFile::Delete(
	const char *chp_burl,
	const char *chp_aid)
{
	CYoString str_dir = UrlToPath(chp_burl);
	CYoString str_filename = str_dir;
	str_filename += "\\";
	str_filename += chp_aid;
	str_filename += ".dat";
	CYoString str_tmp;

	// Datt@C폜
	{
		str_tmp = (const char*)str_filename;
		RemoveFile(str_tmp);
	}

	// Infot@C폜
	{
		str_tmp = (const char*)str_dir;
		str_tmp += "\\info\\";
		str_tmp += chp_aid;
		RemoveFile(str_tmp);
	}

	// Articlet@C폜
	Cq2chwmArticleFile cArticle;
	cArticle.Create(chp_burl);
	cArticle.Remove(cArticle.Search(chp_aid));
	cArticle.Write();

	return TRUE;
}
