#include "StdAfx.h"
#include "YoRegex.h"
#include "q2chwmCommon.h"
#include "q2chwmEditCtrl.h"

#define SEARCH_LINEMAX	0x8000

void Cq2chwmEditCtrl::Regist(
	const HINSTANCE hInstance)
{
	nedit_regist(hInstance);
}

Cq2chwmEditCtrl::Cq2chwmEditCtrl()
{
}

Cq2chwmEditCtrl::~Cq2chwmEditCtrl()
{
	ShowWindow(SW_HIDE);
	::SendMessage(m_hWnd, WM_DESTROY, 0, 0);
}

void Cq2chwmEditCtrl::SetAutoUpdate(
	BOOL bo_update)
{
	//getPaintTool().setAutoUpdate(bo_update == TRUE ? true : false);
}

BOOL Cq2chwmEditCtrl::Create(
	CWnd *pParent,
	int x,
	int y,
	int cx,
	int cy)
{
	m_hWnd = ::CreateWindowEx(0, NEDIT_WND_CLASS, TEXT(""),
		WS_VISIBLE|WS_CHILD|WS_VSCROLL|WS_HSCROLL|/*WS_BORDER|*/ES_MULTILINE|ES_NOHIDESEL,
		0, 0, 0, 0,
		pParent->m_hWnd, (HMENU)0/*IDC_EDIT_EDIT*/, AfxGetApp()->m_hInstance, NULL);
	::SendMessage(m_hWnd, EM_SETREADONLY, TRUE, 0);
	return TRUE;
}

void Cq2chwmEditCtrl::SetFont(
	const char *chp_name,
	int in_size,
	BOOL bo_bold)
{
	CString cstr_name;
	cstr_name = chp_name;
	LOGFONT lf;
	memset(&lf, 0x00, sizeof(lf));
	_tcscpy_s(lf.lfFaceName, LF_FACESIZE, cstr_name);
	lf.lfHeight = -::MulDiv(in_size, ::GetDeviceCaps(::GetDC(m_hWnd), LOGPIXELSY), 72);
	lf.lfWeight = bo_bold == TRUE ? FW_BOLD : FW_NORMAL;
	lf.lfCharSet = DEFAULT_CHARSET;
	m_cFont.DeleteObject();
	m_cFont.CreateFontIndirect(&lf);
	HFONT hFont = (HFONT)m_cFont;
	::SendMessage(m_hWnd, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));
}

void Cq2chwmEditCtrl::SetFocus()
{
	::SendMessage(m_hWnd, WM_SETFOCUS, 0, 0);
}

void Cq2chwmEditCtrl::SetText(
	const char *chp_text,
	int in_len)
{
	CString cstr_text;
	cstr_text = chp_text;
	::SendMessage(m_hWnd, WM_SETTEXT, 0, (LPARAM)(const TCHAR*)cstr_text);
}

void Cq2chwmEditCtrl::SetText(
	const wchar_t *wchp_text,
	int in_len)
{
	::SendMessage(m_hWnd, WM_SETTEXT, 0, (LPARAM)(const TCHAR*)wchp_text);
}

void Cq2chwmEditCtrl::AddText(
	const char *chp_text,
	int in_len)
{
	CString cstr_text;
	cstr_text = chp_text;
	AddText((const TCHAR*)cstr_text);
}

void Cq2chwmEditCtrl::AddText(
	const wchar_t *wchp_text,
	int in_len)
{
	if (wchp_text == NULL) {
		return;
	}

	BUFFER *bf = (BUFFER *)GetWindowLong(m_hWnd, GWL_USERDATA);
	if (bf == NULL) {
		return;
	}
	DWORD cp = bf->cp;
	bf->cp = get_buffer_length(bf);
	bf->sp = bf->cp;
	string_insert(m_hWnd, bf, (TCHAR *)wchp_text, lstrlen((TCHAR *)wchp_text), TRUE);
	bf->cp = cp;
	bf->sp = bf->cp;
	string_flush(bf, FALSE);
	InvalidateRect(NULL, FALSE);
}

void Cq2chwmEditCtrl::SetWrap(
	BOOL bo_flg)
{
	::SendMessage(m_hWnd, WM_SETWORDWRAP, bo_flg, 0);
}

BOOL Cq2chwmEditCtrl::GetWrap()
{
	return ((GetWindowLong(m_hWnd, GWL_STYLE) & WS_HSCROLL) ? FALSE : TRUE);
}

BOOL Cq2chwmEditCtrl::MoveWindow(
	int x,
	int y,
	int cx,
	int cy)
{
	::MoveWindow(m_hWnd, x, y, cx, cy, FALSE);
	return TRUE;
}

BOOL Cq2chwmEditCtrl::ShowWindow(
	int in_cmd)
{
	::ShowWindow(m_hWnd, in_cmd);
	return TRUE;
}

int Cq2chwmEditCtrl::GetLines()
{
	return ::SendMessage(m_hWnd, EM_GETLINECOUNT, 0, 0);
}

int Cq2chwmEditCtrl::GetLineString(
	int in_line,
	TCHAR *pszLine,		// si[pobt@
	int in_size,		// pszLineɊi[\NULL^[~l[g܂ށuv
	BOOL bo_all)		// q2chg܂߂ȂꍇFALSE
{
	if (in_line < 0) return -1;
	BUFFER *bf = (BUFFER *)GetWindowLong(m_hWnd, GWL_USERDATA);
	if (bf == NULL) {
		return -1;
	}

	// ptH[}XAbv̂߃EBhEbZ[WgȂ
	// ::SendMessage(m_hWnd, EM_LINEINDEX, in_line, 0);Ɠ
	int in_index;
	if (in_line < 0 || (unsigned)in_line >= (WPARAM)bf->line_len) {
		return -1;
	}
	in_index = line_get(bf, in_line);
	if (in_index < 0) {
		return -1;
	}

	// ::SendMessage(m_hWnd, EM_LINELENGTH, in_index, 0);Ɠ
	int in_len = line_get_length(bf, in_index);
	if (in_len == 0) {
		pszLine[0] = 0x00;
		return 0;
	}

	// ::SendMessage(m_hWnd, EM_GETLINE, in_line, (LPARAM)pszLine);Ɠ
	in_len = min(in_size - 1, in_len);
	if (bo_all == FALSE && IsExtChar(*(index_to_char(bf, in_index))) == TRUE) {
		// q2chgRs[Ȃ
		in_index++;
		in_len--;
	}
	CopyMemory(pszLine,
		index_to_char(bf, in_index),
		sizeof(TCHAR) * in_len);
	pszLine[in_len] = 0x00;

	return in_len;
}

int Cq2chwmEditCtrl::GetLineString(
	int in_line,
	CString &cstr_line,
	BOOL bo_all)		// q2chg܂߂ȂꍇFALSE
{
	if (in_line < 0) return -1;
	BUFFER *bf = (BUFFER *)GetWindowLong(m_hWnd, GWL_USERDATA);
	if (bf == NULL) {
		return -1;
	}

	// ptH[}XAbv̂߃EBhEbZ[WgȂ
	// ::SendMessage(m_hWnd, EM_LINEINDEX, in_line, 0);Ɠ
	int in_index;
	if (in_line < 0 || (unsigned)in_line >= (WPARAM)bf->line_len) {
		return -1;
	}
	in_index = line_get(bf, in_line);
	if (in_index < 0) {
		return -1;
	}

	// ::SendMessage(m_hWnd, EM_LINELENGTH, in_index, 0);Ɠ
	int in_len = line_get_length(bf, in_index);
	if (in_len == 0) return 0;

	// ::SendMessage(m_hWnd, EM_GETLINE, in_line, (LPARAM)pszLine);Ɠ
	TCHAR *pszLine = cstr_line.GetBufferSetLength(in_len);
	if (bo_all == FALSE && IsExtChar(*(index_to_char(bf, in_index))) == TRUE) {
		// q2chgRs[Ȃ
		in_index++;
		in_len--;
	}
	CopyMemory(pszLine,
		index_to_char(bf, in_index),
		sizeof(TCHAR) * in_len);
	cstr_line.ReleaseBufferSetLength(in_len);

	return in_len;
}

BOOL Cq2chwmEditCtrl::IsEndOfLine(
	int in_line)
{
	if (GetLines() == in_line) return TRUE;
	return FALSE;
}

void Cq2chwmEditCtrl::SetTopLine(
	int in_line)	// \sԍ
{
	//int in_index = ::SendMessage(m_hWnd, EM_LINEINDEX, in_line, 0);
	::SendMessage(m_hWnd, EM_LINESCROLL, 0, in_line - GetTopLine());
	//::SendMessage(m_hWnd, EM_SCROLLCARET, 0, 0);
}

int Cq2chwmEditCtrl::GetTopLine()
{
	BUFFER *bf = (BUFFER*)GetWindowLong(m_hWnd, GWL_USERDATA);
	if (bf == NULL) {
		return -1;
	}
	return bf->pos_y;
}

TCHAR *Cq2chwmEditCtrl::GetLine(
	int in_line)	// \sԍ(0`)
{
	if (in_line < 0) return NULL;
	BUFFER *bf = (BUFFER *)GetWindowLong(m_hWnd, GWL_USERDATA);
	if (bf == NULL) {
		return NULL;
	}

	int in_index;// = ::SendMessage(m_hWnd, EM_LINEINDEX, in_line, 0);
	// ptH[}XAbv̂߃EBhEbZ[WgȂ
	{
		if (in_line < 0 || (unsigned)in_line >= (WPARAM)bf->line_len) {
			return NULL;
		}
		in_index = line_get(bf, in_line);
		if (in_index < 0) {
			return NULL;
		}
	}

	if ((int)bf->buf_len < in_index) {
		return bf->input_buf + (in_index - bf->buf_len);
	}
	return bf->buf[0] == 0x00 ? bf->input_buf + in_index : bf->buf + in_index;
}

void Cq2chwmEditCtrl::SetSelection(
	int in_row_s,		// Docsԍ
	int in_row_e,
	int in_col_s,
	int in_col_e)
{
	int in_index_s = ::SendMessage(m_hWnd, EM_LINEINDEX, in_row_s, 0);
	int in_index_e = ::SendMessage(m_hWnd, EM_LINEINDEX, in_row_e, 0);
	::SendMessage(m_hWnd, EM_SETSEL, in_index_s + in_col_s, in_index_e + in_col_e);
}

void Cq2chwmEditCtrl::GetSelection(
	int& in_row_s,
	int& in_row_e,
	int& in_col_s,
	int& in_col_e)
{
	WPARAM wStart;
	LPARAM lEnd;
	::SendMessage(m_hWnd, EM_GETSEL, (WPARAM)&wStart, (LPARAM)&lEnd);
	in_row_s = ::SendMessage(m_hWnd, EM_LINEFROMCHAR, wStart, 0);
	in_row_e = ::SendMessage(m_hWnd, EM_LINEFROMCHAR, lEnd, 0);
	int in_index_s = ::SendMessage(m_hWnd, EM_LINEINDEX, in_row_s, 0);
	in_col_s = wStart - in_index_s;
	int in_index_e = ::SendMessage(m_hWnd, EM_LINEINDEX, in_row_e, 0);
	in_col_e = lEnd - in_index_e;
}

BOOL Cq2chwmEditCtrl::IsVisibleLine(
	int in_line)
{
	int in_topline = ::SendMessage(m_hWnd, EM_GETFIRSTVISIBLELINE, 0, 0);
	BUFFER *bf;
	::SendMessage(m_hWnd, WM_GETBUFFERINFO, 0, (LPARAM)&bf);
	if(bf->line_len-1<in_line)	return FALSE;
	if (in_line < in_topline || in_line > in_topline + GetVisibleLines()) {
		return FALSE;
	}
	return TRUE;
}

// ʂɕ\Ăs擾
int Cq2chwmEditCtrl::GetVisibleLines()
{
	RECT rc;
	::GetClientRect(m_hWnd, &rc);
	BUFFER *bf;
	::SendMessage(m_hWnd, WM_GETBUFFERINFO, 0, (LPARAM)&bf);
	return (rc.bottom - rc.top) / bf->font_height;
}

BOOL Cq2chwmEditCtrl::IsLineEnd(
	int in_line)
{
	// ptH[}X̂߃EBhEbZ[WgȂ
	BUFFER *bf;
	if ((bf = (BUFFER *)GetWindowLong(m_hWnd, GWL_USERDATA)) == NULL) {
		return FALSE;
	}
	if (in_line < 0 || in_line >= bf->line_len) {
		return FALSE;
	}
	if (in_line + 1 == (WPARAM)bf->line_len || *(index_to_char(bf, line_get(bf, in_line + 1)) - 1) == '\n') {
		return TRUE;
	}
	return FALSE;
	//return ::SendMessage(m_hWnd, EM_GETLINEEND, in_line, 0);
}

BOOL Cq2chwmEditCtrl::SearchNext(
	const char *chp_pat,
	BOOL bo_visible)
{
	// ݑIs擾
	int in_selrow_s;
	int in_selrow_e;
	int in_selcol_s;
	int in_selcol_e;
	GetSelection(in_selrow_s, in_selrow_e, in_selcol_s, in_selcol_e);

	// Is猟JnʒuvZ
	int in_search_row;
	int in_search_col;
	if (in_selrow_e == -1 || IsVisibleLine(in_selrow_e) == FALSE) {
		in_search_row = GetTopLine();
		in_search_col = 0;
	} else {
		in_search_row = in_selrow_e;
		in_search_col = in_selcol_e;
	}

	CString cstr_pat;
	cstr_pat = chp_pat;
	CYoRegex cRegex(cstr_pat, CYoRegex::UTF16LE, TRUE);
	int in_count = GetLines();
	for (int i = in_search_row; i < in_count; i++) {
		if (bo_visible == TRUE && IsVisibleLine(i) == FALSE) break;
		CString cstr_line;
		int in_start = i;
		while (i < in_count) {
			TCHAR szBuff[SEARCH_LINEMAX];
			GetLineString(i, szBuff, SEARCH_LINEMAX);
			cstr_line += szBuff;
			if (IsLineEnd(i) == TRUE) break;
			i++;
		}
		int in_ret;
		if ((in_ret = cRegex.Match(cstr_line, in_search_col)) >= 0) {
			// UTF16Ȃ̂ŃoCg當񒷂ɕϊ邽2Ŋ
			in_ret = in_ret / 2;
			int in_end = in_ret + lstrlen((const wchar_t*)cRegex.Get(0));
			SetSelection(in_start, in_start, in_ret, in_end);
			if (IsVisibleLine(i) == FALSE) {
				SetTopLine(i - GetVisibleLines() + 4);
			}
			return TRUE;
		}
		in_search_col = 0;
	}
	return FALSE;
}

BOOL Cq2chwmEditCtrl::SearchPrev(
	const char *chp_pat,
	BOOL bo_visible)
{
	// ݑIs擾
	int in_selrow_s;
	int in_selrow_e;
	int in_selcol_s;
	int in_selcol_e;
	GetSelection(in_selrow_s, in_selrow_e, in_selcol_s, in_selcol_e);
	if (in_selrow_s == in_selrow_e && in_selcol_s == in_selcol_e) {
		in_selrow_s = -1;
		in_selrow_e = -1;
		in_selcol_s = -1;
		in_selcol_e = -1;
	}

	// Is猟JnʒuvZ
	int in_search_row;
	int in_search_col;
	if (in_selrow_s == -1 || IsVisibleLine(in_selrow_s) == FALSE) {
		in_search_row = GetTopLine() + GetVisibleLines();		// \s̍ŏIs
		in_search_col = -1;						// sS
	} else {
		if (in_selcol_s == 0) {
			in_selrow_s--;
			in_selcol_s = -1;
		}
		in_search_row = in_selrow_s;			// \s
		in_search_col = in_selcol_s;			// s̓r܂
	}

	CString cstr_pat;
	cstr_pat = chp_pat;
	CYoRegex cRegex(cstr_pat, CYoRegex::UTF16LE, TRUE);
	for (int i = in_search_row; i >= 0; i--) {
		if (bo_visible == TRUE && IsVisibleLine(i) == FALSE) break;
		CString cstr_line;
		while (i >= 0) {
			static TCHAR szBuff[SEARCH_LINEMAX];
			int in_len = GetLineString(i, szBuff, SEARCH_LINEMAX);
			if (in_selrow_s - 1 == i && in_search_col != -1) {
				// |>>1|ʕ܂Ԃ
				// |>>2@@@@@@@@@@|s
				// ̂ƂɁu>>2vIԂłƂ
				// u>>1vΏۂƂ邽߂̏
				in_search_col = in_len;
			}
			cstr_line = szBuff + cstr_line;
			if (i == 0 || IsLineEnd(i - 1) == TRUE) {
				break;
			}
			i--;
		}
		if (in_search_col != -1) {
			cstr_line = cstr_line.Left(in_search_col);
		}
		int in_ret;
		if ((in_ret = cRegex.MatchR(cstr_line)) >= 0) {
			in_ret = in_ret / 2;
			const wchar_t	*Buf = (const wchar_t*)cRegex.Get(0);
			int in_end = in_ret + lstrlen(Buf);
			//	http ̓ʏ
			if(strncmp(A(Buf),"tp",2)==0){
				if(in_ret>0){
					if(cstr_line.Mid(in_ret-1,3)=="ttp"){
						in_ret--;
						if(in_ret>0){
							if(cstr_line.Mid(in_ret-1,4)=="http"){
								in_ret--;
							}
						}
					}
				}
			}
			SetSelection(i, i, in_ret, in_end);
			if (IsVisibleLine(i) == FALSE) {
				SetTopLine(i);
			}
			return TRUE;
		}
		in_search_col = -1;
	}
	return FALSE;
}

BOOL Cq2chwmEditCtrl::GetSelectedString(
	CString& cstr_text)
{
	WPARAM wStart;
	LPARAM lEnd;
	::SendMessage(m_hWnd, EM_GETSEL, (WPARAM)&wStart, (LPARAM)&lEnd);
	if (lEnd - wStart == 0) return FALSE;
	TCHAR *pstr = cstr_text.GetBufferSetLength(lEnd - wStart);
	::SendMessage(m_hWnd, EM_GETSELTEXT, 0, (LPARAM)pstr);
	cstr_text.ReleaseBufferSetLength(lEnd - wStart);
	for (int i = 0; i < cstr_text.GetLength(); i++) {
		if (IsExtChar(cstr_text[i]) == TRUE) {
			// q2chg폜
			cstr_text.Delete(i);
			i--;
		}
	}
	return TRUE;
}

void Cq2chwmEditCtrl::OnKeyDown(
	UINT nChar,
	UINT nRepCnt,
	UINT nFlags)
{
	::SendMessage(m_hWnd, WM_KEYDOWN, nChar, nRepCnt);
}

void Cq2chwmEditCtrl::Clear()
{
	::SendMessage(m_hWnd, WM_SETTEXT, 0, (LPARAM)TEXT(""));
}

void Cq2chwmEditCtrl::Copy()
{
	::SendMessage(m_hWnd, WM_COPY, 0, 0);
}

void Cq2chwmEditCtrl::ScrollVertical(
	BOOL bo_next,
	int in_num)
{
	// LPARAM͌ݖ
	// IɃXN[ʂwł悤ɂ
	::SendMessage(m_hWnd, WM_VSCROLL, bo_next == TRUE ? SB_LINEDOWN : SB_LINEUP, in_num);
}

void Cq2chwmEditCtrl::ScrollHorizontal(
	BOOL bo_next,
	int in_num)
{
	// LPARAM͌ݖ
	// IɃXN[ʂwł悤ɂ
	::SendMessage(m_hWnd, WM_HSCROLL, bo_next == TRUE ? SB_LINERIGHT : SB_LINELEFT, in_num);
}

int Cq2chwmEditCtrl::GetLineLength(
	int in_line)
{
	BUFFER *bf = (BUFFER *)GetWindowLong(m_hWnd, GWL_USERDATA);
	if (bf == NULL) {
		return -1;
	}

	if (in_line < 0 || (unsigned)in_line >= (WPARAM)bf->line_len) {
		return -1;
	}
	int in_index = line_get(bf, in_line);
	if (in_index < 0) {
		return -1;
	}

	return line_get_length(bf, in_index);
}

BOOL Cq2chwmEditCtrl::IsExtChar(
	wchar_t wchChar)
{
	if (wchChar == COLOR_FROM ||
		wchChar == COLOR_FROM_WITHMAIL ||
		wchChar == COLOR_FROM_WITHSAGE ||
		wchChar == COLOR_NEW ||
		wchChar == COLOR_DATE ||
		wchChar == COLOR_LINK ||
		wchChar == COLOR_ABONE ||
		wchChar == COLOR_MESSAGE ||
		wchChar == COLOR_IMAGE)
	{
		return TRUE;
	}
	return FALSE;
}

void Cq2chwmEditCtrl::SetGestureMode(BOOL gesture, BOOL inertia, double down)
{
	BUFFER *bf = (BUFFER *)GetWindowLong(m_hWnd, GWL_USERDATA);
	if (bf == NULL) {
		return;
	}
	bf->gesture_mode = gesture;
	bf->inertia_mode = inertia;
	bf->inertia_down = down;
	return;
}

BOOL Cq2chwmEditCtrl::GetGestureMode()
{
	BUFFER *bf = (BUFFER *)GetWindowLong(m_hWnd, GWL_USERDATA);
	if (bf == NULL) {
		return FALSE;
	}
	return bf->gesture_mode;
}
