// q2chwmBoardView.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "MainFrm.h"
#include "q2chwmBoardView.h"
#include "q2chwmConfig.h"
#include "q2chwmArticleFile.h"
#include "YoTime.h"

// Cq2chwmBoardView

IMPLEMENT_DYNCREATE(Cq2chwmBoardView, CTreeView)

Cq2chwmBoardView::Cq2chwmBoardView()
{
	m_pFont = NULL;
	m_bo_running = FALSE;
#ifdef _WIN32_WCE
	m_in_icon_size = 24;
#else
	m_in_icon_size = 16;
#endif
	m_hIconCollapsed = (HICON)::LoadImage(AfxGetApp()->m_hInstance, MAKEINTRESOURCE(IDI_COLLAPSED), IMAGE_ICON, m_in_icon_size, m_in_icon_size, 0);
	m_hIconExpanded = (HICON)::LoadImage(AfxGetApp()->m_hInstance, MAKEINTRESOURCE(IDI_EXPANDED), IMAGE_ICON, m_in_icon_size, m_in_icon_size, 0);
}

Cq2chwmBoardView::~Cq2chwmBoardView()
{
	if (m_pFont != NULL) delete m_pFont;
}

BEGIN_MESSAGE_MAP(Cq2chwmBoardView, CTreeView)
#ifdef _WIN32_WCE
	ON_MESSAGE(WM_GESTURE, OnGesture)
#endif
	ON_WM_DESTROY()
	ON_NOTIFY_REFLECT(NM_RETURN, &Cq2chwmBoardView::OnNMReturn)
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_RELOAD, &Cq2chwmBoardView::OnReload)
	ON_COMMAND(ID_GOBOTTOM, &Cq2chwmBoardView::OnGobottom)
	ON_COMMAND(ID_GOTOP, &Cq2chwmBoardView::OnGotop)
	ON_WM_CHAR()
	ON_WM_PAINT()
	ON_NOTIFY_REFLECT(NM_CLICK, &Cq2chwmBoardView::OnNMClick)
	ON_COMMAND(ID_ADDBOOKMARK, &Cq2chwmBoardView::OnAddBookmark)
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_DETECT_REMOVAL, &Cq2chwmBoardView::OnDetectRemoval)
	ON_WM_TIMER()
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDOWN()
END_MESSAGE_MAP()


// Cq2chwmBoardView ff

#ifdef _DEBUG
void Cq2chwmBoardView::AssertValid() const
{
	CTreeView::AssertValid();
}

#ifndef _WIN32_WCE
void Cq2chwmBoardView::Dump(CDumpContext& dc) const
{
	CTreeView::Dump(dc);
}
#endif
#endif //_DEBUG


// Cq2chwmBoardView bZ[W nh

void Cq2chwmBoardView::OnInitialUpdate()
{
	CTreeView::OnInitialUpdate();

	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	SetFont();
	SetColor();
	LONG lo_style = ::GetWindowLong(GetTreeCtrl().m_hWnd, GWL_STYLE);
	::SetWindowLong(GetTreeCtrl().m_hWnd, GWL_STYLE, lo_style|TVS_HASLINES|TVS_HASBUTTONS|TVS_LINESATROOT);
	HTREEITEM hItem = GetTreeCtrl().InsertItem(_T("q2chwm"));
	m_hItemBookmark = GetTreeCtrl().InsertItem(_T("ubN}[N"), hItem);
	m_hItemCache = GetTreeCtrl().InsertItem(_T("LbV"), hItem);
	m_hItemFind2ch = GetTreeCtrl().InsertItem(_T("X^C"), hItem);
	m_hItemSearchEngine = GetTreeCtrl().InsertItem(_T("Google"), hItem);
	m_hItemEtc = GetTreeCtrl().InsertItem(_T("̑"));

	// board.txtr[쐬
	if (m_cBoardFile.Exist() == FALSE) {
		// 擾邩₢킹
		if (::MessageBox(m_hWnd, _T("ꗗ݂܂BT[o擾܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
			CreateFromHttp(Cq2chwmConfig::GetInstance()->GetBoardUrl());
		}
	} else {
		// r[쐬
		CreateFromFile();
	}

	// Ƃ肠
	GoTop();

	// IMEIt
	SipOff(m_hWnd);

	gesture_mode = Cq2chwmConfig::GetInstance()->GetGestureMode();
	inertia_mode = Cq2chwmConfig::GetInstance()->GetInertiaMode();
	inertia_down = (double)Cq2chwmConfig::GetInstance()->GetInertiaDown() / 100;
	gesture_y = 0;
	gesture_timer = NULL;
	velocity = 0;
	velocity_clip = 0;
}

BOOL Cq2chwmBoardView::CreateFromFile()
{
	CYoTime cTime;
	PRINTLOG("start %d(msec)", cTime.Elapsed());
	int in_ret = m_cBoardFile.CreateFromFile();
	if (in_ret != ERR_NONE) {
		::MessageBox(m_hWnd, _T("ꗗt@C̓ǂݍ݂Ɏs܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONSTOP);
		return FALSE;
	}
	PRINTLOG("end %d(msec)", cTime.Elapsed());

	// c[쐬
	createTree();
	PRINTLOG("createTree end %d(msec)", cTime.Elapsed());

	// ̑쐬
	if (m_cBoardFileEtc.Exist() == TRUE) {
		in_ret = m_cBoardFileEtc.CreateFromFile();
		if (in_ret != ERR_NONE) {
			::MessageBox(m_hWnd, _T("̑t@C̓ǂݍ݂Ɏs܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONSTOP);
			return FALSE;
		}
		createTreeEtc();
	}

	return TRUE;
}

BOOL Cq2chwmBoardView::CreateFromHttp(
	const char *chp_url)
{
	if (m_bo_running == TRUE) return TRUE;
	m_bo_running = TRUE;
	GetParent()->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)TRUE);
	int in_ret = m_cBoardFile.CreateFromHttp(chp_url);
	if (in_ret != ERR_NONE) {
		// G[
		GetParent()->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)FALSE);
		m_bo_running = FALSE;
		ErrorMessageBox(in_ret);
		return FALSE;
	}

	// ړ]o
	DetectRemoval();

	// c[쐬
	createTree();
	GetParent()->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)FALSE);
	m_bo_running = FALSE;

	return TRUE;
}

BOOL Cq2chwmBoardView::ReloadEtc()
{
	// ̑쐬
	if (m_cBoardFileEtc.Exist() == TRUE) {
		clearTreeEtc();
		int in_ret = m_cBoardFileEtc.CreateFromFile();
		if (in_ret != ERR_NONE) {
			::MessageBox(m_hWnd, _T("̑t@C̓ǂݍ݂Ɏs܂B"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONSTOP);
			return FALSE;
		}
		createTreeEtc();
	}
	return TRUE;
}

BOOL Cq2chwmBoardView::DetectRemoval()
{
	// obNAbvt@Cǂݍ
	CYoString str_filename = m_cBoardFile.GetFileName();
	str_filename += ".bak";
	Cq2chwmBoardFile cBoardFileBak(str_filename);
	cBoardFileBak.CreateFromFile();

	BOOL bo_detect = FALSE;
	BOOL bo_err = FALSE;
	CYoString str_msg;
	str_msg = "ړ]ŃG[܂B\n";
	for (int i = 0; i < cBoardFileBak.Rows(); i++) {
		// IDURLTĈړ]o
		int in_index = m_cBoardFile.SearchFromId(cBoardFileBak.GetBoardId(i));
		if (in_index >= 0) {
			const char *chp_url_new = m_cBoardFile.GetBoardUrl(in_index);
			const char *chp_url_old = cBoardFileBak.GetBoardUrl(i);
			if (strcmp(chp_url_new, chp_url_old) != 0) {
				// ړ]o
				PRINTLOG("MOVE: [%s] -> [%s]", chp_url_old, chp_url_new);
				if (MergeDirectory(chp_url_old, chp_url_new) == FALSE) {
					// G[
					bo_err = TRUE;
					str_msg.FormatAdd("%s -> %s\n", chp_url_old, chp_url_new);
				}
				Cq2chwmBookmarkFile::GetInstance()->Replace(chp_url_old, chp_url_new);
				m_cBoardFileEtc.Replace(chp_url_old, chp_url_new);
				bo_detect = TRUE;
			}
		}
	}

	if (bo_err == TRUE) {
		CString cstr_msg;
		cstr_msg = (const char*)str_msg;
		AfxMessageBox(cstr_msg);
	}

	if (bo_detect == TRUE) {
		Cq2chwmBookmarkFile::GetInstance()->Write();
		m_cBoardFileEtc.Write();
	}

	return TRUE;
}

BOOL Cq2chwmBoardView::MergeDirectory(
	const char *chp_src,
	const char *chp_dst)
{
	CYoString str_path_src = UrlToPath(chp_src);
	CYoString str_path_dst = UrlToPath(chp_dst);

	// article-summary̓}[WȂ̂œǂݍł
	Cq2chwmArticleFile cFileSrc;
	cFileSrc.Create(chp_src);
	Cq2chwmArticleFile cFileDst;
	cFileDst.Create(chp_dst);
	cFileDst.AddArticle(cFileSrc);

	// Rs[(chp_src->chp_dst)
	if (ExistFile(str_path_src) == TRUE) {
		MakeDirectory(str_path_dst);
		if (CopyDirectory(str_path_src, str_path_dst) == FALSE) {
			return FALSE;
		}
	}

	// article-summary
	cFileDst.Write();

	// Rs[폜
	if (ExistFile(str_path_src) == TRUE) {
		if (RemoveDirectory((const char*)str_path_src) == FALSE) {
			PRINTLOG("RemoveDirectory error: [%s][%d]", (const char*)str_path_src, ::GetLastError());
			return FALSE;
		}
	}

	// 폜ʁAhCfBNgɂȂhCfBNg폜
	CYoString str_parent_dir = str_path_src;
	char *chp_tmp = (char*)strrchr((const char*)str_parent_dir, '\\');
	if (chp_tmp != NULL) {
		*chp_tmp = 0x00;
		if (ExistFile(str_parent_dir) == TRUE) {
			BOOL bo_exist = FALSE;
			CString cstr_find;
			WIN32_FIND_DATA st_find;
			HANDLE hFind;
			cstr_find = str_parent_dir;
			cstr_find += "\\*.*";
			hFind = ::FindFirstFile(cstr_find, &st_find);
			if (hFind != INVALID_HANDLE_VALUE) {
				do {
					if (wcscmp(st_find.cFileName, _T(".")) == 0 || wcscmp(st_find.cFileName, _T("..")) == 0) continue;
					bo_exist = TRUE;
					break;
				} while (FindNextFile(hFind, &st_find));
				::FindClose(hFind);
				if (bo_exist == FALSE && RemoveDirectory((const char*)str_parent_dir) == FALSE) {
					PRINTLOG("RemoveDirectory error: [%s][%d]", (const char*)str_parent_dir, ::GetLastError());
					return FALSE;
				}
			} else if (::GetLastError() == 18) {
				// ȏt@C܂B
				if (RemoveDirectory((const char*)str_parent_dir) == FALSE) {
					PRINTLOG("RemoveDirectory error: [%s][%d]", (const char*)str_parent_dir, ::GetLastError());
					return FALSE;
				}
			}
		}
	}

	return TRUE;
}

void Cq2chwmBoardView::clearTree()
{
	HTREEITEM hItem = GetTreeCtrl().GetRootItem();
	while (hItem != NULL) {
		Cq2chwmBoardItem *pItem = (Cq2chwmBoardItem*)GetTreeCtrl().GetItemData(hItem);
		if (pItem == NULL) {
			hItem = GetTreeCtrl().GetNextItem(hItem, TVGN_NEXT);
		} else {
			delete pItem;
			HTREEITEM hItemChild = GetTreeCtrl().GetChildItem(hItem);
			while (hItemChild != NULL) {
				Cq2chwmBoardItem *pItem = (Cq2chwmBoardItem*)GetTreeCtrl().GetItemData(hItemChild);
				if (pItem != NULL) delete pItem;
				hItemChild = GetTreeCtrl().GetNextItem(hItemChild, TVGN_NEXT);
			}
			HTREEITEM hItemOld = hItem;
			hItem = GetTreeCtrl().GetNextItem(hItem, TVGN_NEXT);
			GetTreeCtrl().DeleteItem(hItemOld);
		}
	}
}

void Cq2chwmBoardView::clearTreeEtc()
{
	HTREEITEM hItem = GetTreeCtrl().GetChildItem(m_hItemEtc);
	while (hItem != NULL) {
		Cq2chwmBoardItem *pItem = (Cq2chwmBoardItem*)GetTreeCtrl().GetItemData(hItem);
		delete pItem;
		HTREEITEM hItemOld = hItem;
		hItem = GetTreeCtrl().GetNextItem(hItem, TVGN_NEXT);
		GetTreeCtrl().DeleteItem(hItemOld);
	}
}

#define BITWEENNAMETOURL	"                        "
void Cq2chwmBoardView::createTree()
{
	clearTree();
	HTREEITEM hItemParent = NULL;
	HTREEITEM hItemAbove = NULL;
	for (int i = 0; i < m_cBoardFile.Rows(); i++) {
		Cq2chwmBoardItem *pItem = new Cq2chwmBoardItem(m_cBoardFile.GetBoardName(i), m_cBoardFile.GetBoardUrl(i), m_cBoardFile.GetBoardId(i));
		CString cstr_name;
		if (strlen(m_cBoardFile.GetBoardUrl(i)) == 0) {
			// e
			cstr_name = m_cBoardFile.GetBoardName(i);
			hItemParent = GetTreeCtrl().InsertItem(TVIF_PARAM|TVIF_TEXT, cstr_name, -1, -1, 0, 0, (LPARAM)pItem, NULL, hItemAbove);
		} else {
			// q
			cstr_name.Format(_T("%s%s%s"), W(m_cBoardFile.GetBoardName(i)), _T(BITWEENNAMETOURL), W(m_cBoardFile.GetBoardId(i)));
			hItemAbove = GetTreeCtrl().InsertItem(TVIF_PARAM|TVIF_TEXT, cstr_name, -1, -1, 0, 0, (LPARAM)pItem, hItemParent, hItemAbove);
		}
	}
}

void Cq2chwmBoardView::createTreeEtc()
{
	clearTreeEtc();
	HTREEITEM hItemAbove = NULL;
	for (int i = 0; i < m_cBoardFileEtc.Rows(); i++) {
		Cq2chwmBoardItem *pItem = new Cq2chwmBoardItem(m_cBoardFileEtc.GetBoardName(i), m_cBoardFileEtc.GetBoardUrl(i), m_cBoardFileEtc.GetBoardId(i));
		CString cstr_name;
		cstr_name.Format(_T("%s%s%s"), W(m_cBoardFileEtc.GetBoardName(i)), _T(BITWEENNAMETOURL), W(m_cBoardFileEtc.GetBoardId(i)));
		hItemAbove = GetTreeCtrl().InsertItem(TVIF_PARAM|TVIF_TEXT, cstr_name, -1, -1, 0, 0, (LPARAM)pItem, m_hItemEtc, hItemAbove);
	}
}

void Cq2chwmBoardView::OnDestroy()
{
	clearTreeEtc();
	clearTree();
	CTreeView::OnDestroy();

	// TODO: ɃbZ[W nh R[hǉ܂B
}

void Cq2chwmBoardView::OnNMReturn(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	*pResult = 0;
	HTREEITEM hItem = GetTreeCtrl().GetSelectedItem();
	if (GetTreeCtrl().ItemHasChildren(hItem) == TRUE) {
		// q2chwm
		GetTreeCtrl().Expand(hItem, TVE_TOGGLE);
		*pResult = 1;
	} else if (hItem == m_hItemBookmark) {
		GetParent()->SendMessage(WM_USER_OPENBOOKMARK, 0, 0);
	} else if (hItem == m_hItemFind2ch) {
		GetParent()->SendMessage(WM_USER_OPENFIND2CH, 0, 0);
	} else if (hItem == m_hItemSearchEngine) {
		GetParent()->SendMessage(WM_USER_OPENSEARCHENGINE, 0, 0);
	} else if (hItem == m_hItemCache) {
		GetParent()->SendMessage(WM_USER_OPENCACHE, 0, 0);
	} else {
		Cq2chwmBoardItem *pItem = (Cq2chwmBoardItem*)GetTreeCtrl().GetItemData(hItem);
		if (pItem != NULL) {
			GetParent()->SendMessage(WM_USER_BOARDCLICKED, 0, (LPARAM)pItem);
		}
	}
}

void Cq2chwmBoardView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	TRACE(_T("Cq2chwmBoardView::OnKeyDown: %02x(%d)\n"), nChar, nChar);
	if (Cq2chwmConfig::GetInstance()->IsKeyCancel(nChar)) {
		GetParent()->SendMessage(WM_USER_CANCEL, 0, 0);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyViewBack(nChar)) {
		GetParent()->SendMessage(WM_USER_VIEWBACK, 0, 0);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyViewForward(nChar)) {
		GetParent()->SendMessage(WM_USER_VIEWFORWARD, 0, 0);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyBottom(nChar)) {
		GoBottom();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyTop(nChar)) {
		GoTop();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyReload(nChar)) {
		OnReload();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyPageUp(nChar)) {
		GetTreeCtrl().SendMessage(WM_KEYDOWN, VK_PRIOR);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyPageDown(nChar)) {
		GetTreeCtrl().SendMessage(WM_KEYDOWN, VK_NEXT);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyChangeView(nChar)) {
		((Cq2chwmApp*)AfxGetApp())->PopupViewMenu();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyAddBookmark(nChar)) {
		OnAddBookmark();
		return;
	}

	// WM6 Stdp ŊJ
	{
		HTREEITEM hItem = GetTreeCtrl().GetSelectedItem();
		if (hItem != NULL) {
			if (nChar == VK_LEFT) {
				if (GetTreeCtrl().ItemHasChildren(hItem) == TRUE &&
					(GetTreeCtrl().GetItemState(hItem, 0) & TVIS_EXPANDED) > 0)
				{
					// eŊJĂ
					GetTreeCtrl().Expand(hItem, TVE_COLLAPSE);
				} else {
					// eŕĂ邩qȂeֈړ
					if (GetTreeCtrl().GetParentItem(hItem) != NULL) GetTreeCtrl().SelectItem(GetTreeCtrl().GetParentItem(hItem));
				}
				return;
			} else if (nChar == VK_RIGHT) {
				if (GetTreeCtrl().ItemHasChildren(hItem) == TRUE) {
					if ((GetTreeCtrl().GetItemState(hItem, 0) & TVIS_EXPANDED) == 0) {
						// eŕĂJ
						GetTreeCtrl().Expand(hItem, TVE_EXPAND);
					} else {
						// eŊJĂqֈړ
						GetTreeCtrl().SelectItem(GetTreeCtrl().GetChildItem(hItem));
					}
				}
				return;
			}
		}
	}

	CTreeView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void Cq2chwmBoardView::SetFont()
{
	CString cstr_name;
	cstr_name = Cq2chwmConfig::GetInstance()->GetFontNameList();
	LOGFONT lf;
	memset(&lf, 0x00, sizeof(lf));
	_tcscpy_s(lf.lfFaceName, LF_FACESIZE, cstr_name);
	lf.lfHeight = Cq2chwmConfig::GetInstance()->GetFontSizeList() * 10;
	lf.lfWeight = Cq2chwmConfig::GetInstance()->GetFontBoldList() == TRUE ? FW_BOLD : FW_NORMAL;
	lf.lfCharSet = DEFAULT_CHARSET;

	if (m_pFont != NULL) delete m_pFont;
	m_pFont = new CFont();
	m_pFont->CreatePointFontIndirect(&lf);
	CWnd::SetFont(m_pFont);
}

void Cq2chwmBoardView::SetColor()
{
#ifndef _WIN32_WCE
	//GetTreeCtrl().SetBkColor(Cq2chwmConfig::GetInstance()->GetColorBack());
	//GetTreeCtrl().SetTextColor(Cq2chwmConfig::GetInstance()->GetColorFore());
#endif
}

void Cq2chwmBoardView::OnReload()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CreateFromHttp(Cq2chwmConfig::GetInstance()->GetBoardUrl());
	InvalidateRect(NULL);
}

void Cq2chwmBoardView::GoTop()
{
	HTREEITEM hItemRoot= GetTreeCtrl().GetRootItem();
	GetTreeCtrl().SelectItem(hItemRoot);
	GetTreeCtrl().EnsureVisible(hItemRoot);
}

void Cq2chwmBoardView::GoBottom()
{
	HTREEITEM hItem;
	HTREEITEM hItemTmp = GetTreeCtrl().GetRootItem();
	while ((hItemTmp = GetTreeCtrl().GetNextItem(hItemTmp, TVGN_NEXT)) != NULL) {
		hItem = hItemTmp;
	}
	GetTreeCtrl().Select(hItem, TVGN_CARET);
}

void Cq2chwmBoardView::OnGobottom()
{
	// TODO: ɃR}h nh R[hǉ܂B
	GoBottom();
}

void Cq2chwmBoardView::OnGotop()
{
	// TODO: ɃR}h nh R[hǉ܂B
	GoTop();
}

void Cq2chwmBoardView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	return;
	CTreeView::OnChar(nChar, nRepCnt, nFlags);
}

void Cq2chwmBoardView::OnPaint()
{
	PAINTSTRUCT ps;
	CDC* pDC = BeginPaint(&ps);
	//CPaintDC cDC(this); // device context for painting
	//CWnd::DefWindowProc(WM_PAINT, (WPARAM)pDC->m_hDC, 0);
	//return;

	// TODO: ɃbZ[W nh R[hǉ܂B
	// `惁bZ[W CTreeView::OnPaint() ĂяoȂłB
	// ftHg̕`揈
	// WM_PAINTbZ[Wł́AwParamɕ`ȂfoCXReLXg̃nhw肷
	RECT rcView;
	GetClientRect(&rcView);
	CDC cMemDC;
	cMemDC.CreateCompatibleDC(pDC);
	CBitmap cBitmap;
	cBitmap.CreateCompatibleBitmap(pDC, rcView.right, rcView.bottom);
	CBitmap *pOldBitmap = cMemDC.SelectObject(&cBitmap);

	// wiNA
	CBrush cBrush(Cq2chwmConfig::GetInstance()->GetColorBack());
	cMemDC.FillRect(&rcView, &cBrush);

	// m[h`
	//CWnd::DefWindowProc(WM_PAINT, (WPARAM)cMemDC.m_hDC, 0);

	// c[Rg[̃tHg擾A
	// foCXReLXg̃tHgƂĐݒ肷
	LOGFONT stLogFont;
	CFont cFont;
	GetFont()->GetLogFont(&stLogFont);
	cFont.CreateFontIndirect(&stLogFont);
	CFont* pOldFont = cMemDC.SelectObject(&cFont);

	// ׂẴACeɂăeLXg`悵Ȃ
	HTREEITEM hItem = GetTreeCtrl().GetFirstVisibleItem();
	do
	{
		CRect rcItem;
		GetTreeCtrl().GetItemRect(hItem, &rcItem, TRUE);
		if (rcItem.bottom < ps.rcPaint.top ||
			rcItem.top > ps.rcPaint.bottom)
		{
			continue;
		}
		rcItem.right = rcView.right;

		// m[hACR`
		if (GetTreeCtrl().ItemHasChildren(hItem) == TRUE) {
			if ((GetTreeCtrl().GetItemState(hItem, TVIF_STATE) & TVIS_EXPANDED) == 0) {
				::DrawIconEx(cMemDC.m_hDC, rcItem.left - m_in_icon_size, rcItem.top + 2, m_hIconCollapsed, m_in_icon_size, m_in_icon_size, 0, NULL, DI_NORMAL);
			} else {
				::DrawIconEx(cMemDC.m_hDC, rcItem.left - m_in_icon_size, rcItem.top + 2, m_hIconExpanded, m_in_icon_size, m_in_icon_size, 0, NULL, DI_NORMAL);
			}
		}

		// `FƔwiFݒ
		if( hItem == GetTreeCtrl().GetDropHilightItem() ||
			(hItem == GetTreeCtrl().GetSelectedItem() && GetTreeCtrl().GetDropHilightItem() == NULL) )
		{
			cMemDC.SetBkColor(Cq2chwmConfig::GetInstance()->GetColorBack());
			cMemDC.SetTextColor(Cq2chwmConfig::GetInstance()->GetColorActive());
		}
		else
		{
			cMemDC.SetBkColor(Cq2chwmConfig::GetInstance()->GetColorBack());
			cMemDC.SetTextColor(Cq2chwmConfig::GetInstance()->GetColorFore());
		}

		// ACẽeLXg擾A`悷
		CString strText = GetTreeCtrl().GetItemText(hItem);
		int iFind = strText.ReverseFind(_T(' '));
		if (iFind >= 0) {
			CString strName;
			CString strUrl;
			strName = strText.Left(iFind);
			strUrl = strText.Right(strText.GetLength() - iFind - 1);
			cMemDC.ExtTextOutW(rcItem.left + 2, rcItem.top + 1, 0, &rcItem, strName, NULL);
			CSize szBuff = cMemDC.GetTextExtent(_T(BITWEENNAMETOURL));
			cMemDC.ExtTextOutW(rcItem.left + 2 + szBuff.cx, rcItem.top + 1, 0, &rcItem, strUrl, NULL);
		} else {
			cMemDC.ExtTextOutW(rcItem.left + 2, rcItem.top + 1, 0, &rcItem, strText, NULL);
		}

	} while(hItem = GetTreeCtrl().GetNextVisibleItem(hItem));

	// ]
	pDC->BitBlt(ps.rcPaint.left, ps.rcPaint.top, ps.rcPaint.right, ps.rcPaint.bottom, &cMemDC, ps.rcPaint.left, ps.rcPaint.top, SRCCOPY);

	// foCXReLXg̃tHgɖ߂
	cMemDC.SelectObject(pOldBitmap);
	cMemDC.SelectObject(pOldFont);
	cFont.DeleteObject();
	cBitmap.DeleteObject();
	cMemDC.DeleteDC();
	EndPaint(&ps);
}

BOOL Cq2chwmBoardView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	cs.style |= WS_HSCROLL;
	return CTreeView::PreCreateWindow(cs);
}

BOOL Cq2chwmBoardView::SearchNext(
	const char *chp_word)
{
	CYoRegex cRegex(chp_word, CYoRegex::SJIS, TRUE);
	HTREEITEM hItem;
	if (GetTreeCtrl().GetSelectedItem() == NULL) {
		// IȂ
		hItem = GetTreeCtrl().GetRootItem();
	} else if (GetTreeCtrl().ItemHasChildren(GetTreeCtrl().GetSelectedItem()) == TRUE) {
		// eI
		hItem = GetTreeCtrl().GetChildItem(GetTreeCtrl().GetSelectedItem());
	} else {
		// qI
		hItem = GetTreeCtrl().GetNextItem(GetTreeCtrl().GetSelectedItem(), TVGN_NEXT);
		if (hItem == NULL) {
			hItem = GetTreeCtrl().GetNextItem(GetTreeCtrl().GetParentItem(GetTreeCtrl().GetSelectedItem()), TVGN_NEXT);
		}
	}
	while (hItem != NULL) {
		Cq2chwmBoardItem *pItem = (Cq2chwmBoardItem*)GetTreeCtrl().GetItemData(hItem);
		if (pItem == NULL || strlen(pItem->GetBoardUrl()) == 0) {
			if (GetTreeCtrl().ItemHasChildren(hItem) == TRUE) {
				// eACe
				hItem = GetTreeCtrl().GetChildItem(hItem);
			} else {
				// q2chJeSACe
				HTREEITEM hItemTmp = GetTreeCtrl().GetNextItem(hItem, TVGN_NEXT);
				if (hItemTmp == NULL) {
					// eACe̎̃ACe
					hItem = GetTreeCtrl().GetNextItem(GetTreeCtrl().GetParentItem(hItem), TVGN_NEXT);
				} else {
					hItem = hItemTmp;
				}
			}
		} else {
			if (cRegex.Match(pItem->GetBoardName()) >= 0 || cRegex.Match(pItem->GetBoardId()) >= 0) {
				GetTreeCtrl().SelectItem(hItem);
				GetTreeCtrl().EnsureVisible(hItem);
				return TRUE;
			}
			HTREEITEM hItemTmp = GetTreeCtrl().GetNextItem(hItem, TVGN_NEXT);
			if (hItemTmp == NULL) {
				// ̐eACe
				hItem = GetTreeCtrl().GetNextItem(GetTreeCtrl().GetParentItem(hItem), TVGN_NEXT);
			} else {
				// ̎qACe
				hItem = hItemTmp;
			}
		}
	}
	::MessageBox(m_hWnd, _T("Ō܂Ō܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONINFORMATION);
	return FALSE;
}

HTREEITEM Cq2chwmBoardView::getBottomItem(
	HTREEITEM hItemParent)
{
	if (hItemParent == NULL) {
		hItemParent = GetTreeCtrl().GetRootItem();

		// eACȅI[ֈړ
		HTREEITEM hItemTmp = hItemParent;
		while (hItemTmp != NULL) {
			hItemParent = hItemTmp;
			hItemTmp = GetTreeCtrl().GetNextItem(hItemTmp, TVGN_NEXT);
		}
	}

	// eACe̍ŏ̎qACe擾
	HTREEITEM hItemChild = GetTreeCtrl().GetChildItem(hItemParent);
	if (hItemChild == NULL) return hItemParent;

	// qACȅI[ֈړ
	HTREEITEM hItem;
	HTREEITEM hItemTmp = hItemChild;
	while (hItemTmp != NULL) {
		hItem = hItemTmp;
		hItemTmp = GetTreeCtrl().GetNextItem(hItemTmp, TVGN_NEXT);
	}

	return hItem;
}

BOOL Cq2chwmBoardView::SearchPrev(
	const char *chp_word)
{
	CYoRegex cRegex(chp_word, CYoRegex::SJIS, TRUE);
	HTREEITEM hItem;
	if (GetTreeCtrl().GetSelectedItem() == NULL) {
		// IȂ
		hItem = getBottomItem();
	} else if (GetTreeCtrl().ItemHasChildren(GetTreeCtrl().GetSelectedItem()) == TRUE) {
		// eI
		hItem = getBottomItem(GetTreeCtrl().GetNextItem(GetTreeCtrl().GetSelectedItem(), TVGN_PREVIOUS));
	} else {
		// qI
		hItem = GetTreeCtrl().GetNextItem(GetTreeCtrl().GetSelectedItem(), TVGN_PREVIOUS);
		if (hItem == NULL) {
			hItem = GetTreeCtrl().GetParentItem(GetTreeCtrl().GetSelectedItem());
		}
	}
	
	while (hItem != NULL) {
		Cq2chwmBoardItem *pItem = (Cq2chwmBoardItem*)GetTreeCtrl().GetItemData(hItem);
		if (pItem == NULL || strlen(pItem->GetBoardUrl()) == 0) {
			if (GetTreeCtrl().ItemHasChildren(hItem) == TRUE) {
				// eACe
				hItem = getBottomItem(GetTreeCtrl().GetNextItem(hItem, TVGN_PREVIOUS));
			} else {
				// q2chJeSACe
				hItem = GetTreeCtrl().GetNextItem(hItem, TVGN_PREVIOUS);
			}
		} else {
			if (cRegex.Match(pItem->GetBoardName()) >= 0 || cRegex.Match(pItem->GetBoardId()) >= 0) {
				GetTreeCtrl().SelectItem(hItem);
				GetTreeCtrl().EnsureVisible(hItem);
				return TRUE;
			}
			HTREEITEM hItemTmp = GetTreeCtrl().GetNextItem(hItem, TVGN_PREVIOUS);
			if (hItemTmp == NULL) {
				// ̐eACe
				hItem = GetTreeCtrl().GetParentItem(hItem);
			} else {
				// ̎qACe
				hItem = hItemTmp;
			}
		}
	}
	::MessageBox(m_hWnd, _T("Ō܂Ō܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONINFORMATION);
	return FALSE;
}

void Cq2chwmBoardView::OnNMClick(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	*pResult = 0;

	// ::SendMessageƎ̃r[tH[JXĂ܂
	UINT uFlag;
	CPoint pt = ::GetMessagePos();
	GetTreeCtrl().ScreenToClient(&pt);
	HTREEITEM hItem = GetTreeCtrl().HitTest(pt, &uFlag);
	if(hItem == NULL || !(uFlag & TVHT_ONITEM)) return;
	if (GetTreeCtrl().ItemHasChildren(hItem) == TRUE) {
		;
	} else if (hItem == m_hItemBookmark) {
		GetParent()->PostMessage(WM_USER_OPENBOOKMARK, 0, 0);
	} else if (hItem == m_hItemFind2ch) {
		GetParent()->PostMessage(WM_USER_OPENFIND2CH, 0, 0);
	} else if (hItem == m_hItemCache) {
		GetParent()->PostMessage(WM_USER_OPENCACHE, 0, 0);
	} else {
		Cq2chwmBoardItem *pItem = (Cq2chwmBoardItem*)GetTreeCtrl().GetItemData(hItem);
		GetParent()->PostMessage(WM_USER_BOARDCLICKED, 0, (LPARAM)pItem);
	}
}

void Cq2chwmBoardView::OnAddBookmark()
{
	// TODO: ɃR}h nh R[hǉ܂B
	HTREEITEM hItem = GetTreeCtrl().GetSelectedItem();
	if (GetTreeCtrl().ItemHasChildren(hItem) == TRUE ||
		hItem == m_hItemBookmark ||
		hItem == m_hItemFind2ch ||
		hItem == m_hItemCache)
	{
		return;
	}
	if (::MessageBox(m_hWnd, _T("̑ɒǉ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
		Cq2chwmBoardItem *pItem = (Cq2chwmBoardItem*)GetTreeCtrl().GetItemData(hItem);
		if (pItem == NULL) return;
		m_cBoardFileEtc.InsertBoard(pItem->GetBoardName(), pItem->GetBoardUrl(), pItem->GetBoardId());
		m_cBoardFileEtc.Write();
		ReloadEtc();

		// ubN}[Nr[ɒǉ邽߂ɃEBhEbZ[WM
		GetParent()->SendMessage(WM_USER_ADDBOOKMARKBOARD, 0, (LPARAM)pItem);
	}
}

void Cq2chwmBoardView::CopyInformation()
{
	HTREEITEM hItem = GetTreeCtrl().GetSelectedItem();
	if (GetTreeCtrl().ItemHasChildren(hItem) == TRUE ||
		hItem == m_hItemBookmark ||
		hItem == m_hItemFind2ch ||
		hItem == m_hItemCache)
	{
		return;
	}
	Cq2chwmBoardItem *pItem = (Cq2chwmBoardItem*)GetTreeCtrl().GetItemData(hItem);
	if (pItem == NULL) return;
	CString cstr_text;
	cstr_text.Format(_T("%s\r\n%s\r\n"), W(pItem->GetBoardName()), W(pItem->GetBoardUrl()));
	StringToClipboard(cstr_text);
}

#define ETC_BASE_INDEX	10000
int Cq2chwmBoardView::SearchFromUrl(
	const char *chp_burl)
{
	int in_ret = m_cBoardFileEtc.SearchFromUrl(chp_burl);
	if (in_ret == -1) {
		return m_cBoardFile.SearchFromUrl(chp_burl);
	}
	return ETC_BASE_INDEX + in_ret;
}

int Cq2chwmBoardView::SearchFromId(
	const char *chp_bid)
{
	int in_ret = m_cBoardFileEtc.SearchFromId(chp_bid);
	if (in_ret == -1) {
		return m_cBoardFile.SearchFromId(chp_bid);
	}
	return ETC_BASE_INDEX + in_ret;
}

const char *Cq2chwmBoardView::GetBoardName(
	int in_index)
{
	if (in_index >= ETC_BASE_INDEX) {
		return m_cBoardFileEtc.GetBoardName(in_index - ETC_BASE_INDEX);
	}
	return m_cBoardFile.GetBoardName(in_index);
}

const char *Cq2chwmBoardView::GetBoardId(
	int in_index)
{
	if (in_index >= ETC_BASE_INDEX) {
		return m_cBoardFileEtc.GetBoardId(in_index - ETC_BASE_INDEX);
	}
	return m_cBoardFile.GetBoardId(in_index);
}

const char *Cq2chwmBoardView::GetBoardUrl(
	int in_index)
{
	if (in_index >= ETC_BASE_INDEX) {
		return m_cBoardFileEtc.GetBoardUrl(in_index - ETC_BASE_INDEX);
	}
	return m_cBoardFile.GetBoardUrl(in_index);
}

BOOL Cq2chwmBoardView::OnEraseBkgnd(CDC* pDC)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	return TRUE;
	//return CTreeView::OnEraseBkgnd(pDC);
}

void Cq2chwmBoardView::OnDetectRemoval()
{
	// TODO: ɃR}h nh R[hǉ܂B
	HTREEITEM hItem = GetTreeCtrl().GetSelectedItem();
	if (GetTreeCtrl().ItemHasChildren(hItem) == TRUE ||
		hItem == m_hItemBookmark ||
		hItem == m_hItemFind2ch ||
		hItem == m_hItemCache ||
		hItem == m_hItemEtc)
	{
		return;
	}
	Cq2chwmBoardItem *pItem = (Cq2chwmBoardItem*)GetTreeCtrl().GetItemData(hItem);
	if (pItem == NULL) return;
	CYoString str_burl = pItem->GetBoardUrl();
	CYoString str_burl_new;
	DetectRemoval(str_burl, str_burl_new);
}

/*
 * gbvURL(http://jfk.2ch.net/news4vip/)HTML擾Ajavascript
 * window.location.href="[ړ]URL]"ړ]̔gbvURLꂽ
 * ړ]sB
 * \param chp_burl ړ]̔gbvURL
 * \param str_burl_new ړ]̔gbvURL
 * \return G[G[bZ[W\FALSEԂ
 * \return IbZ[W\TRUEԂ
 */
BOOL Cq2chwmBoardView::DetectRemoval(
	const char *chp_burl,
	CYoString &str_burl_new)
{
	if (m_bo_running == TRUE) return TRUE;
	m_bo_running = TRUE;
	GetParent()->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)TRUE);
	BOOL bo_ret = FALSE;
	CYoRegex cRegex("<script language=\"javascript\">[\\r\\n]*.*window\\.location\\.href=\"([^\"]+)\".*[\\r\\n]*</script>", TRUE);
	CYoString str_html;

	// ̃gbvy[W(http://jfk.2ch.net/news4vip/)HTML擾
	CYoHttpClient cHttp(chp_burl);
	cHttp.SetUserAgent(Cq2chwmConfig::GetInstance()->GetUserAgent());
	if (Cq2chwmConfig::GetInstance()->GetProxyUse() == TRUE) {
		cHttp.SetProxy(Cq2chwmConfig::GetInstance()->GetProxyHost(), Cq2chwmConfig::GetInstance()->GetProxyPort());
		cHttp.SetProxyAuth(Cq2chwmConfig::GetInstance()->GetProxyId(), Cq2chwmConfig::GetInstance()->GetProxyPass());
	}
	cHttp.SetCallbackProc(CMainFrame::CallbackProc, AfxGetMainWnd());

	if (cHttp.Connect(TIMEOUT) == FALSE) {
		ErrorMessageBox(ERR_HTTP_CONNECT);
		goto end;
	}

	if (cHttp.Get() == FALSE) {
		ErrorMessageBox(ERR_HTTP_GET);
		goto end;
	}

	if (cHttp.GetResultCode() < 200 || cHttp.GetResultCode() >= 300) {
		ErrorMessageBox(ERR_HTTP_GET);
		goto end;
	}

	// htmlɕێ
	{
		CYoString str_length = cHttp.GetResponseHeader("Content-Length");
		int in_length = str_length.Atoi();
		char cha_buff[RECV_BUFF];
		int in_ret;
		while ((in_ret = cHttp.Recv(cha_buff, sizeof(cha_buff) - 1)) > 0) {
			str_html.StrnCat(cha_buff, in_ret);
			cha_buff[in_ret] = 0x00;
			GetParent()->SendMessage(WM_USER_SETPROGRESS, cHttp.GetRecvSize(), in_length);
		}
		if (in_ret == 0 && ((CMainFrame*)AfxGetMainWnd())->Canceled() == TRUE) {
			goto end;
		}
		if( in_ret == SOCKET_ERROR ){
			ErrorMessageBox(ERR_HTTP_RECV);
			goto end;
		}
	}

	// ړ]Ăꍇ́AL̂悤javascriptŐVURLɃWvĂ悤B
	// javascriptVURLoB
	// window.location.href="http://takeshima.2ch.net/news4vip/"
	if (cRegex.Match(str_html) >= 0 && strcmp(chp_burl, cRegex.Get(1)) != 0) {
		// ړ]o
		const char *chp_burl_new = cRegex.Get(1);
		PRINTLOG("%s", chp_burl_new);

		// t@C̃obNAbvt@C(board.txt.bak)쐬A
		// ړ]URLŔt@C(board.txt)XVAʏ̔ړ]sB
		m_cBoardFile.Backup();
		m_cBoardFile.Replace(chp_burl, chp_burl_new);
		m_cBoardFile.Write();

		// ړ]s
		DetectRemoval();

		// ̑Ă
		m_cBoardFileEtc.Replace(chp_burl, chp_burl_new);
		m_cBoardFileEtc.Write();

		Replace(chp_burl, chp_burl_new);
		str_burl_new = chp_burl_new;
		bo_ret = TRUE;
		::MessageBox(m_hWnd, _T("ړ]o܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONINFORMATION);
	} else {
		// ړ]̌oɎs
		::MessageBox(m_hWnd, _T("ړ]oł܂ł"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONSTOP);
	}

end:
	GetParent()->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)FALSE);
	m_bo_running = FALSE;
	return bo_ret;
}

/*
 * SĂCq2chwmBoardItem{AÂURLVURLɍXVB
 */
void Cq2chwmBoardView::Replace(
	const char *chp_burl_old,
	const char *chp_burl_new)
{
	HTREEITEM hItem = GetTreeCtrl().GetRootItem();
	while (hItem != NULL) {
		Cq2chwmBoardItem *pItem = (Cq2chwmBoardItem*)GetTreeCtrl().GetItemData(hItem);
		if (pItem == NULL && GetTreeCtrl().ItemHasChildren(hItem) == FALSE) {
			hItem = GetTreeCtrl().GetNextItem(hItem, TVGN_NEXT);
		} else {
			HTREEITEM hItemChild = GetTreeCtrl().GetChildItem(hItem);
			while (hItemChild != NULL) {
				Cq2chwmBoardItem *pItem = (Cq2chwmBoardItem*)GetTreeCtrl().GetItemData(hItemChild);
				if (pItem != NULL && strcmp(pItem->GetBoardUrl(), chp_burl_old) == 0) {
					pItem->SetBoardUrl(chp_burl_new);
				}
				hItemChild = GetTreeCtrl().GetNextItem(hItemChild, TVGN_NEXT);
			}
			hItem = GetTreeCtrl().GetNextItem(hItem, TVGN_NEXT);
		}
	}
}


#ifdef _WIN32_WCE
LRESULT Cq2chwmBoardView::OnGesture(WPARAM wParam, LPARAM lParam)
{
	if (!gesture_mode) {
		return TRUE;
	}

	GESTUREINFO gi;
	::ZeroMemory(&gi, sizeof(GESTUREINFO));
	gi.cbSize = sizeof(GESTUREINFO);

	if (TKGetGestureInfo(reinterpret_cast<HGESTUREINFO>(lParam), &gi)) {
		switch (wParam)
		{
			case GID_BEGIN:	// GestureJn
				{
					gesture_y = gi.ptsLocation.y;
				}
				break;
			case GID_PAN:	// p
				{
					CTreeCtrl& tree = this->GetTreeCtrl();

					RECT rc;
					if (!tree.GetItemRect(tree.GetRootItem(), &rc, LVIR_LABEL)){
						break;
					}
					long item_height = rc.bottom - rc.top;
					int max_y = tree.GetScrollLimit(SB_VERT);

					int pre_y = tree.GetScrollPos(SB_VERT);
					int pos_y = pre_y + (gesture_y - gi.ptsLocation.y) / item_height;

					if (pos_y < 0)			pos_y = 0;
					if (pos_y > max_y)		pos_y = max_y;

					if (pre_y != pos_y) {
						gesture_y = gi.ptsLocation.y;

						int nCode = (pre_y < pos_y)? TVGN_NEXTVISIBLE: TVGN_PREVIOUSVISIBLE;
						HTREEITEM hItem = tree.GetFirstVisibleItem();
						for (int i = 0; i <abs(pre_y - pos_y); i++) {
							hItem = tree.GetNextItem(hItem, nCode);
							if (hItem == NULL) break;
						}
						if (hItem != NULL) {
							tree.Select(hItem, TVGN_FIRSTVISIBLE);
						}
					}
				}
				break;
			case GID_SCROLL:	// XN[
				{
					if (inertia_mode) {
						// XN[ON
						int direction = GID_SCROLL_DIRECTION(gi.ullArguments);
						velocity = 0;
						switch(direction) {
							case ARG_SCROLL_DOWN:	// tbN
								velocity = GID_SCROLL_VELOCITY(gi.ullArguments);
								break;
							case ARG_SCROLL_UP:		// tbN
								velocity = -GID_SCROLL_VELOCITY(gi.ullArguments);
								break;
						}
						if (velocity != 0) {
							// XN[p^C}[Jn
							velocity_clip = velocity / 10;	// ^C}100msȂ̂1/10
							gesture_timer = SetTimer(GESTURE_TIMER_ID, 100, NULL);
						}
					}
				}
				break;
			case GID_HOLD:		// (^bv)z[h
				break;
			case GID_SELECT:	// ZNg(^bv)
				{
					if (gesture_timer != 0) {
						velocity = 0;
						if (KillTimer(gesture_timer)) {
							gesture_timer = NULL;
						}
					}

					CTreeCtrl& tree = this->GetTreeCtrl();
					POINT pt = {gi.ptsLocation.x, gi.ptsLocation.y};
					ScreenToClient(&pt);
					CPoint cpt(pt.x, pt.y);
					UINT flags;
					HTREEITEM hItem = tree.HitTest(cpt, &flags);
					if (hItem != NULL) {
						if (flags & TVHT_ONITEMLABEL) {
							tree.Select(hItem, TVGN_CARET);
							// IACeJ
							if (GetTreeCtrl().ItemHasChildren(hItem) == TRUE) {
								// q2chwm
								GetTreeCtrl().Expand(hItem, TVE_TOGGLE);
							} else if (hItem == m_hItemBookmark) {
								GetParent()->SendMessage(WM_USER_OPENBOOKMARK, 0, 0);
							} else if (hItem == m_hItemFind2ch) {
								GetParent()->SendMessage(WM_USER_OPENFIND2CH, 0, 0);
							} else if (hItem == m_hItemSearchEngine) {
								GetParent()->SendMessage(WM_USER_OPENSEARCHENGINE, 0, 0);
							} else if (hItem == m_hItemCache) {
								GetParent()->SendMessage(WM_USER_OPENCACHE, 0, 0);
							} else {
								Cq2chwmBoardItem *pItem = (Cq2chwmBoardItem*)GetTreeCtrl().GetItemData(hItem);
								if (pItem != NULL) {
									GetParent()->SendMessage(WM_USER_BOARDCLICKED, 0, (LPARAM)pItem);
								}
							}
						}else if (flags & TVHT_ONITEMBUTTON) {
							// c[J
							tree.Expand(hItem, TVE_TOGGLE);
						}
					}
				}
				break;
			case GID_DOUBLESELECT:	// _uZNg(^bv)
				break;
			case GID_END:	// GestureI
				gesture_y = 0;
				break;

			default:
				break;
		}
	}
	return TRUE;
}
#endif

void Cq2chwmBoardView::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	if (nIDEvent == gesture_timer) {
		CTreeCtrl& tree = this->GetTreeCtrl();

		RECT rc;
		if (tree.GetItemRect(tree.GetRootItem(), &rc, LVIR_LABEL)){
			long item_height = rc.bottom - rc.top;
			int max_y = tree.GetScrollLimit(SB_VERT);

			int pre_y = tree.GetScrollPos(SB_VERT);
			int v_buf = (int)(velocity * inertia_down);
			velocity -= v_buf;
			if (velocity_clip != 0) {
				if (abs(v_buf) > abs(velocity_clip)) {
					v_buf = velocity_clip;	// ő呬x}
				}
			}
			int pos_y = pre_y + (int)(v_buf / item_height);

			if (pos_y < 0)			pos_y = 0;
			if (pos_y > max_y)		pos_y = max_y;

			if (pre_y != pos_y) {
				int nCode = (pre_y < pos_y)? TVGN_NEXTVISIBLE: TVGN_PREVIOUSVISIBLE;
				HTREEITEM hItem = tree.GetFirstVisibleItem();
				for (int i = 0; i <abs(pre_y - pos_y); i++) {
					hItem = tree.GetNextItem(hItem, nCode);
					if (hItem == NULL) break;
				}
				if (hItem != NULL) {
					tree.Select(hItem, TVGN_FIRSTVISIBLE);
				}
			}else{
				// c肪1sȉɂȂ~
				if (KillTimer(gesture_timer)) {
					gesture_timer = NULL;
				}
			}
		}
		return;
	}

	CTreeView::OnTimer(nIDEvent);
}

void Cq2chwmBoardView::SetGestureMode(BOOL gesture, BOOL inertia, double down)
{
	gesture_mode = gesture;
	inertia_mode = inertia;
	inertia_down = down;
}

void Cq2chwmBoardView::OnLButtonUp(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	if (gesture_mode) {
		return;
	}

	CTreeView::OnLButtonUp(nFlags, point);
}

void Cq2chwmBoardView::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	if (gesture_mode) {
		if (gesture_timer != 0) {
			velocity = 0;
			if (KillTimer(gesture_timer)) {
				gesture_timer = NULL;
			}
		}
		return;
	}

	CTreeView::OnLButtonDown(nFlags, point);
}
