// q2chwmColorSelector.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmColorSelector.h"
#include "q2chwmColorSelectorDialog.h"


// q2chwmColorSelector

IMPLEMENT_DYNAMIC(Cq2chwmColorSelector, CButton)

Cq2chwmColorSelector::Cq2chwmColorSelector()
{
	m_color = 0;
	m_pColorDialog = NULL;
}

Cq2chwmColorSelector::~Cq2chwmColorSelector()
{
}


BEGIN_MESSAGE_MAP(Cq2chwmColorSelector, CButton)
	ON_WM_DRAWITEM()
	ON_CONTROL_REFLECT(BN_CLICKED, &Cq2chwmColorSelector::OnBnClicked)
END_MESSAGE_MAP()



// q2chwmColorSelector bZ[W nh



void Cq2chwmColorSelector::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	CButton::OnDrawItem(nIDCtl, lpDrawItemStruct);
}

BOOL Cq2chwmColorSelector::Create(
	COLORREF color,
	const RECT &rect,
	CWnd *pParent)
{
	m_color = color;
	if (CButton::Create(_T(""), BS_PUSHBUTTON, rect, pParent, 0) == TRUE) {
		ShowWindow(SW_SHOW);
		return TRUE;
	}
	return FALSE;
}

#define MARGIN_FOCUS	2
#define MARGIN_TRIANGLE	(MARGIN_FOCUS+4)
void Cq2chwmColorSelector::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{

	// TODO:  w肳ꂽڂ`悷邽߂̃R[hǉĂB
	CRect rect = lpDrawItemStruct->rcItem;

	// foCXReLXg擾
	CDC* pDC = CDC::FromHandle(lpDrawItemStruct->hDC);

	// hԂpuVƘgp̃y
	CBrush cBrush(m_color);
	CPen cPen;
	if (lpDrawItemStruct->itemState & ODS_FOCUS) {
		// tH[JXȂgŕ`
		COLORREF color_frame;
		if (BRIGHTNESS(GetRValue(m_color), GetGValue(m_color), GetBValue(m_color)) < 128) {
			color_frame = RGB(255, 255, 255);
		} else {
			color_frame = RGB(0, 0, 0);
		}
		cPen.CreatePen(PS_SOLID, 6, color_frame);
	} else {
		cPen.CreatePen(PS_SOLID, 6, m_color);
	}
	CBrush *pOldBrush = pDC->SelectObject(&cBrush);
	CPen* pOldPen = pDC->SelectObject(&cPen);
	pDC->Rectangle(rect);
	pDC->SelectObject(pOldBrush);
	pDC->SelectObject(pOldPen);

	if (lpDrawItemStruct->itemState & ODS_SELECTED) {
		// {^ꂽƂ
		pDC->Draw3dRect(rect, RGB(0, 0, 0), RGB(255, 255, 255));
	} else {
		// ʏ
		pDC->Draw3dRect(rect, RGB(255, 255, 255), RGB(0, 0, 0));
	}

	// `
	int iWidth = 6;
	int iHeight = 2;
	COLORREF clrXor;
	if (BRIGHTNESS(GetRValue(m_color), GetGValue(m_color), GetBValue(m_color)) < 128) {
		clrXor = RGB(255, 255, 255);
	} else {
		clrXor = RGB(0, 0, 0);
	}
	POINT ptTri[] = {
		{rect.right - iWidth - MARGIN_TRIANGLE, rect.top + ((rect.bottom - rect.top) / 2 - (iHeight / 2))},
		{rect.right - (iWidth / 2) - MARGIN_TRIANGLE, rect.top + ((rect.bottom - rect.top) / 2 + iHeight)},
		{rect.right - MARGIN_TRIANGLE, rect.top + ((rect.bottom - rect.top) / 2 - (iHeight / 2))}
	};
	CBrush cTriBrush;
	CPen cTriPen(PS_SOLID, 1 , clrXor);
	cTriBrush.CreateSolidBrush(clrXor);
	CBrush *oldBrush = pDC->SelectObject(&cTriBrush);
	CPen *oldPen = pDC->SelectObject(&cTriPen);
	pDC->Polygon(ptTri, 3);

	// eLXg`
	CString cstrText;
	GetWindowText(cstrText);
	pDC->SetBkMode(TRANSPARENT);
	pDC->SetTextColor(clrXor);
	pDC->DrawText(cstrText, rect, DT_CENTER|DT_VCENTER|DT_SINGLELINE);

	pDC->SelectObject(oldBrush);
	pDC->SelectObject(oldPen);
}

BOOL Cq2chwmColorSelector::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	cs.style |= BS_OWNERDRAW;
	return CButton::PreCreateWindow(cs);
}

void Cq2chwmColorSelector::OnBnClicked()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	m_pColorDialog = new Cq2chwmColorSelectorDialog(this);
	m_pColorDialog->Create(this);
}

void Cq2chwmColorSelector::EndDialog()
{
	m_pColorDialog->DestroyWindow();
}