#pragma once

#include "YoPtrArray.h"

class Cq2chwmLayoutLine
{
private:
	class lineitem
	{
	public:
		CWnd *m_pWnd;
		int m_in_weight;

	public:
		lineitem(CWnd *pWnd, int in_weight)
		{
			m_pWnd = pWnd;
			m_in_weight = in_weight;
		}
	};
	CYoPtrArray m_cArray;
	int m_in_height;
public:
	Cq2chwmLayoutLine(CWnd *pWnd0, int in_weight0,
		CWnd *pWnd1 = NULL, int in_weight1 = -1,
		CWnd *pWnd2 = NULL, int in_weight2 = -1,
		CWnd *pWnd3 = NULL, int in_weight3 = -1,
		CWnd *pWnd4 = NULL, int in_weight4 = -1,
		CWnd *pWnd5 = NULL, int in_weight5 = -1,
		CWnd *pWnd6 = NULL, int in_weight6 = -1,
		CWnd *pWnd7 = NULL, int in_weight7 = -1)
	{
		m_in_height = 1;
		if (pWnd0 != NULL) m_cArray.Add(new lineitem(pWnd0, in_weight0));
		if (pWnd1 != NULL) m_cArray.Add(new lineitem(pWnd1, in_weight1));
		if (pWnd2 != NULL) m_cArray.Add(new lineitem(pWnd2, in_weight2));
		if (pWnd3 != NULL) m_cArray.Add(new lineitem(pWnd3, in_weight3));
		if (pWnd4 != NULL) m_cArray.Add(new lineitem(pWnd4, in_weight4));
		if (pWnd5 != NULL) m_cArray.Add(new lineitem(pWnd5, in_weight5));
		if (pWnd6 != NULL) m_cArray.Add(new lineitem(pWnd6, in_weight6));
		if (pWnd7 != NULL) m_cArray.Add(new lineitem(pWnd7, in_weight7));
	}

	Cq2chwmLayoutLine(int in_height, CWnd *pWnd0, int in_weight0,
		CWnd *pWnd1 = NULL, int in_weight1 = -1,
		CWnd *pWnd2 = NULL, int in_weight2 = -1,
		CWnd *pWnd3 = NULL, int in_weight3 = -1,
		CWnd *pWnd4 = NULL, int in_weight4 = -1,
		CWnd *pWnd5 = NULL, int in_weight5 = -1,
		CWnd *pWnd6 = NULL, int in_weight6 = -1,
		CWnd *pWnd7 = NULL, int in_weight7 = -1)
	{
		m_in_height = in_height;
		if (pWnd0 != NULL) m_cArray.Add(new lineitem(pWnd0, in_weight0));
		if (pWnd1 != NULL) m_cArray.Add(new lineitem(pWnd1, in_weight1));
		if (pWnd2 != NULL) m_cArray.Add(new lineitem(pWnd2, in_weight2));
		if (pWnd3 != NULL) m_cArray.Add(new lineitem(pWnd3, in_weight3));
		if (pWnd4 != NULL) m_cArray.Add(new lineitem(pWnd4, in_weight4));
		if (pWnd5 != NULL) m_cArray.Add(new lineitem(pWnd5, in_weight5));
		if (pWnd6 != NULL) m_cArray.Add(new lineitem(pWnd6, in_weight6));
		if (pWnd7 != NULL) m_cArray.Add(new lineitem(pWnd7, in_weight7));
	}

	~Cq2chwmLayoutLine()
	{
		for (int i = 0; i < m_cArray.Count(); i++) {
			lineitem *pItem = (lineitem*)m_cArray.Get(i);
			delete pItem;
		}
	}

	CWnd *GetWindow(int in_index)
	{
		lineitem *pItem = (lineitem*)m_cArray.Get(in_index);
		return pItem->m_pWnd;
	}

	int GetWeight(int in_index)
	{
		lineitem *pItem = (lineitem*)m_cArray.Get(in_index);
		return pItem->m_in_weight;
	}

	int GetHeight(){ return m_in_height; }

	int GetWeightAll()
	{
		int in_ret = 0;
		for (int i = 0; i < GetCount(); i++) {
			in_ret += GetWeight(i);
		}
		return in_ret;
	}

	inline int GetCount(){ return m_cArray.Count(); }
};

class Cq2chwmLayoutManager
{
private:
	int m_in_margin;
	CYoPtrArray m_cArray;

public:
	Cq2chwmLayoutManager(Cq2chwmLayoutLine *pLine0,
		Cq2chwmLayoutLine *pLine1 = NULL,
		Cq2chwmLayoutLine *pLine2 = NULL,
		Cq2chwmLayoutLine *pLine3 = NULL,
		Cq2chwmLayoutLine *pLine4 = NULL,
		Cq2chwmLayoutLine *pLine5 = NULL,
		Cq2chwmLayoutLine *pLine6 = NULL,
		Cq2chwmLayoutLine *pLine7 = NULL)
	{
		m_in_margin = 4;
		m_cArray.Add(pLine0);
		if (pLine1 != NULL) m_cArray.Add(pLine1);
		if (pLine2 != NULL) m_cArray.Add(pLine2);
		if (pLine3 != NULL) m_cArray.Add(pLine3);
		if (pLine4 != NULL) m_cArray.Add(pLine4);
		if (pLine5 != NULL) m_cArray.Add(pLine5);
		if (pLine6 != NULL) m_cArray.Add(pLine6);
		if (pLine7 != NULL) m_cArray.Add(pLine7);
	}

	~Cq2chwmLayoutManager()
	{
		for (int i = 0; i < m_cArray.Count(); i++) {
			Cq2chwmLayoutLine *pLine= (Cq2chwmLayoutLine*)m_cArray.Get(i);
			delete pLine;
		}
	}

	void Layout(int cx, int cy)
	{
		// svZ
		int in_row = 0;
		for (int i = 0; i < m_cArray.Count(); i++) {
			Cq2chwmLayoutLine *pLine = (Cq2chwmLayoutLine*)m_cArray.Get(i);
			in_row += pLine->GetHeight();
		}

		// 1s̍vZ
		int in_height = cy / in_row;

		// c̃[v
		for (int i = 0; i < m_cArray.Count(); i++) {
			int in_y = in_height * i + m_in_margin;	// s̊Jnʒu(Y)
			Cq2chwmLayoutLine *pLine = (Cq2chwmLayoutLine*)m_cArray.Get(i);
			int in_weight_all = pLine->GetWeightAll();		// SEFCg
			if (in_weight_all == 0) break;
			int in_pixel = cx / in_weight_all;			// EFCg1̕sNZ

			// ̃[v
			int in_weight_cur = 0;
			for (int j = 0; j < pLine->GetCount(); j++) {
				CWnd *pWnd = pLine->GetWindow(j);
				RECT r;
				pWnd->GetWindowRect(&r);
				int in_weight = pLine->GetWeight(j);
				int in_x = in_weight_cur * in_pixel + m_in_margin;

				if (r.bottom - r.top > in_height) {
					pWnd->MoveWindow(in_x, in_y, (in_weight * in_pixel) - m_in_margin * 2, in_height * pLine->GetHeight() - m_in_margin * 2);
				} else {
					pWnd->MoveWindow(in_x, in_y, (in_weight * in_pixel) - m_in_margin * 2, (r.bottom - r.top) * pLine->GetHeight());
				}
				in_weight_cur += in_weight;
			}
		}
	}
};

