#pragma once

#include "nEdit.h"
class Cq2chwmEditCtrl

{
public:
	enum
	{
		COLOR_FROM = 1,
		COLOR_FROM_WITHMAIL,
		COLOR_FROM_WITHSAGE,
		COLOR_NEW,
		COLOR_DATE,
		COLOR_LINK,
		COLOR_ABONE,
		COLOR_MESSAGE,
		COLOR_IMAGE = 15,
	};

private:
	CFont m_cFont;

public:
	HWND m_hWnd;
	static void Regist(const HINSTANCE hInstance);
	static void ClearCache(){ nedit_clear_cache(); }
	Cq2chwmEditCtrl();
	~Cq2chwmEditCtrl();

	// EBhEn
	BOOL Create(CWnd *pParent, int x, int y, int cx, int cy);
	void SetFocus();
	BOOL MoveWindow(int x, int y, int cx, int cy);
	BOOL ShowWindow(int in_cmd);
	void ScrollVertical(BOOL bo_next, int in_num);
	void ScrollHorizontal(BOOL bo_next, int in_num);
	void InvalidateRect(LPCRECT lpRect, BOOL bErase = TRUE){ ::InvalidateRect(m_hWnd, lpRect, bErase); }

	// eLXgn
	void SetText(const char *chp_text, int in_len = -1);
	void SetText(const wchar_t *wchp_text, int in_len = -1);
	void AddText(const char *chp_text, int in_len = -1);
	void AddText(const wchar_t *wchp_text, int in_len = -1);
	void SetWrap(BOOL bo_flg);
	BOOL GetWrap();
	void SetFont(const char *chp_name, int in_size, BOOL bo_bold);
	void SetDrawProc(WPARAM wParam, Q2CH_DRAWPROC proc){ ::SendMessage(m_hWnd, Q2CH_SETDRAWPROC, wParam, (LPARAM)proc); }
	void SetGetColorProc(WPARAM wParam, Q2CH_GETCOLORPROC proc){ ::SendMessage(m_hWnd, Q2CH_SETGETCOLORPROC, wParam, (LPARAM)proc); }
	void SetBeforeWindowProc(WPARAM wParam, Q2CH_WINDOWPROC proc){ ::SendMessage(m_hWnd, Q2CH_SETBEFOREWINDOWPROC, wParam, (LPARAM)proc); }
	void SetAfterWindowProc(WPARAM wParam, Q2CH_WINDOWPROC proc){ ::SendMessage(m_hWnd, Q2CH_SETAFTERWINDOWPROC, wParam, (LPARAM)proc); }
	BOOL GetSelectedString(CString& cstr_text);
	void SetAutoUpdate(BOOL bo_update);
	void Clear();
	void Copy();

	// sn
	int GetLines();
	int GetVisibleLines();
	int GetLineLength(int in_line);
	int GetLineString(int in_line, TCHAR *pszLine, int in_size, BOOL bo_all = TRUE);
	int GetLineString(int in_line, CString &cstr_line, BOOL bo_all = TRUE);
	BOOL IsEndOfLine(int in_line);
	BOOL IsVisibleLine(int in_line);
	void SetTopLine(int in_line);
	int GetTopLine();
	//void SetLineText(const char *chp_text, int in_line, int in_start = 0);
	TCHAR *GetLine(int in_line);
	BOOL IsLineEnd(int in_line);

	// 
	BOOL SearchNext(const char *chp_pat, BOOL bo_visible = FALSE);
	BOOL SearchPrev(const char *chp_pat, BOOL bo_visible = FALSE);

	// Cxg
	void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);

	void SetSelection(int in_row_s, int in_row_e, int in_col_s, int in_col_e);
	void GetSelection(int& in_row_s, int& in_row_e, int& in_col_s, int& in_col_e);

	// 
	BOOL IsExtChar(wchar_t wchChar);

};
