/*
 *  psychlops_g_shader.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/12/14 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */


#include "psychlops_g_shader.h"
#include "../../../platform/gl/extension/psychlops_g_shader_gl.h"

namespace Psychlops {

	Shader::Shader()
	{
		api = new ShaderAPI;
	}
	Shader::~Shader() {
		delete api;
	};
	void Shader::cache(const std::string &orig_source, const std::vector<std::string> &vars, Drawable &target)
	{
		api->cache(orig_source, vars, target);
	}
	void Shader::cacheField(const std::string &orig_source, const std::vector<std::string> &vars, Drawable &target)
	{
		api->cacheField(orig_source, vars, target);
	}
	void Shader::cacheTex(const std::string &orig_source, const std::vector<std::string> &vars, Drawable &target, int sw)
	{
		api->cacheTex(orig_source, vars, target, sw);
	}
	void Shader::drawField(const Rectangle &rect, const double *argv, const int argn)
	{
		api->drawField(rect, argv, argn);
	}
	void Shader::drawImage(Image &img, const double *argv, const int argn, Canvas &target)
	{
		api->drawImage(img, argv, argn, target);
	}
	void Shader::drawImage(Image &img, const double *argv, const int argn, Image &arg_img, Canvas &target)
	{
		api->drawImage(img, argv, argn, arg_img, target);
	}
	void Shader::fieldToImage(Image &target, const Rectangle &rect, const double *argv, const int argn, Canvas &media)
	{
		api->fieldToImage(target, rect, argv, argn, media);
	}
	void Shader::imageToImage(Image &target, Image &img, const double *argv, const int argn, Canvas &media)
	{
		api->imageToImage(target, img, argv, argn, media);
	}

}	/*	<- namespace Psycholops 	*/
