/*
 *  psychlops_code_exception.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2005/12/17 by Kenchi HOSOKAWA
 *  (C) 2005 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_CODINGSUPPORT_EXCEPTION
#define HEADER_PSYCHLOPS_CODINGSUPPORT_EXCEPTION


#include <typeinfo>
#include <string>
#include <iostream>


namespace Psychlops {


	class Exception {
		public:
		const std::type_info &ti_;
		std::string category_;
		std::string str_;
		std::string backtrace_;
		static Exception dummy_;

		public:
		Exception();
		Exception(const std::type_info &ti);
		Exception(std::string str);
		Exception(const char *str);
		Exception(const std::type_info &ti, std::string category);
		Exception(const std::type_info &ti, const char *category);
		Exception(const std::type_info &ti, std::string category, std::string str);
		Exception(const std::type_info &ti, const char *category, const char *str);
		std::string to_s();
		std::string toString();
		std::string getErrorString();
	};

namespace Prototype {

	extern double debug_double[8];

}

}	/*	<- namespace Psychlops 	*/


#endif
