/*
 *  psychlops_g_font_Win32_GL.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2008/09/12 by Kenchi HOSOKAWA
 *  (C) 2008 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */

#include "../../core/graphic/psychlops_g_font.h"
#include <windows.h>


namespace Psychlops {

	Font Font::default_font(20, normal_weight, normal_style, L"MS UI Gothic");

	std::wstring LocalEncodingtoWCHAR(const char* s, int length) {
		std::wstring result;
		result.resize( MultiByteToWideChar( CP_ACP, 0, (LPCSTR)s, length, (LPWSTR)result.data(), 0 ) );
		MultiByteToWideChar( CP_ACP, 0, (LPCSTR)s, length, (LPWSTR)result.data(), length*2 );
		return result;
	}
	std::wstring LocalEncodingtoWCHAR(const char* c) {
		int i = 0;
		while(c[i]!=0) i++;
		i--;
		return LocalEncodingtoWCHAR(c, i);
	}

}	/*	<- namespace Psycholops 	*/
