/*
 *  psychlops_app_main_OSX.h
 *  Psychlops Standard Library (OSX)
 *
 *  Last Modified 2006/02/12 by Kenchi HOSOKAWA
 *  (C) 2006 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */


#ifndef HEADER_PSYCHLOPS_APP_MAIN_OSX
#define HEADER_PSYCHLOPS_APP_MAIN_OSX


#include "../../core/ApplicationInterfaces/psychlops_app_init.h"
#include "../../psychlops_lib.h"


//namespace Psychlops {

	void psychlops_main();

//}	/*	<- namespace Psycholops 	*/



int main(int argc, char *argv[]) {
	try {

		Psychlops::AppInfo::argc = argc;
		Psychlops::AppInfo::argv = argv;
		Psychlops::AppInfo::args.resize(argc);
		for(int i=0; i<argc; i++)
		{
			Psychlops::AppInfo::args[i] = Psychlops::AppInfo::argv[i];
		}
		Psychlops::initialize();
		psychlops_main();
		Psychlops::finalize();

		return 0;

	} catch(Psychlops::Exception e) {
		std::cout << e.to_s() << std::endl;
		Psychlops::AppState::alert(e.to_s());
	} catch(Psychlops::Exception *e) {
		std::cout << e->to_s() << std::endl;
		Psychlops::AppState::alert(e->to_s());
	} catch(char* str) {
		std::cout << str << std::endl;
		Psychlops::AppState::alert(std::string(str));
		//Psychlops::APIApplicationProperties::analyzeAPIError();
	}
	

	return 0;
}


#endif
