/*
 *  psychlops_io_analog.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2008/04/05 by Kenchi HOSOKAWA
 *  (C) 2006 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */

#include "psychlops_io_analog.h"


namespace Psychlops {

	ITrigger::~ITrigger() {
	}


	const Exception trg_no_inst("Trigger has no instance.");
	Trigger::Trigger() { instance = 0; }
	Trigger::Trigger(ITrigger *v) { instance = v; }
	Trigger::Trigger(ITrigger &v) { instance = &v; }
	void Trigger::set(ITrigger *v) { instance = v; }
	void Trigger::set(ITrigger &v) { instance = &v; }
	Trigger::~Trigger() { if(instance==0) delete instance; }
	double Trigger::getLatency() { if(instance!=0) return instance->getLatency(); else throw trg_no_inst; }
	double Trigger::getJitterSD() { if(instance!=0) return instance->getJitterSD(); else throw trg_no_inst; }
	Interval Trigger::getRange() { if(instance!=0) return instance->getRange(); else throw trg_no_inst; }
	bool Trigger::isAnalog() { if(instance!=0) return instance->isAnalog(); else throw trg_no_inst; }

	double Trigger::get() { if(instance!=0) return instance->get(); else throw trg_no_inst; }
	void Trigger::put(double v) { if(instance!=0) instance->put(v); else throw trg_no_inst; }
	void Trigger::pulse(double v) { if(instance!=0) instance->pulse(v); else throw trg_no_inst; }
	void Trigger::keep(double v) { if(instance!=0) instance->keep(v); else throw trg_no_inst; }
	


	AnalogInput::~AnalogInput() {
	}

	AnalogOutput::~AnalogOutput() {
	}


}	/*	<- namespace Psycholops 	*/
