/*
 *  psychlops_io_display_OSX.cpp
 *  Psychlops Standard Library (MacOSX)
 *
 *  Last Modified 2009/03/02 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */


#include <string>
#include "../../core/graphic/psychlops_g_canvas.h"
#include "../../core/ApplicationInterfaces/psychlops_code_exception.h"



namespace Psychlops {

	typedef std::vector<Display> Displays;
	class APIDisplayProperties {
	public:
		CGDirectDisplayID did;
		CFDictionaryRef current_mode_, original_mode_;
		CGGammaValue
			savedRedMin_, savedRedMax_, savedRedGamma_,
			savedGreenMin_, savedGreenMax_, savedGreenGamma_,
			savedBlueMin_, savedBlueMax_, savedBlueGamma_;
		int gamma_mode_;
		
		APIDisplayProperties(CGDirectDisplayID ddid);
		static Displays enumDisplays();
		void getInfo(int &width, int &height, int &color_depth, double &refresh_rate, std::string& name, Rectangle& area);
		void setGammaValue(const double gamma_r, const double gamma_g, const double gamma_b);
		void setGammaTable(const std::vector<double> &table_r, const std::vector<double> &table_g, const std::vector<double> &table_b);
		void setGammaTable(const CGGammaValue * const table_r, const CGGammaValue * const table_g, const CGGammaValue * const table_b, const int num_steps);
		void setGammaTable();
		void saveGammaValue();
		void destroyGammaSettings();
		int getCalibrationMode();
	};

}	/*	<- namespace Psycholops 	*/



