#include <psychlops.h>
using namespace Psychlops;

void psychlops_main() {
	Canvas cnvs(1024,1024,Canvas::window);
	cnvs.watchFPS();
	cnvs.showFPS();
	Mouse::show();



	Color::setGammaValue(1.0,1.0,1.0);


	Image buf[10], reference[10], difference[10], difference2[10];

	Figures::ShaderGrating grat;
	grat.set(240,240);
	grat.contrast = 1.0;
	grat.wavelength = 30.0;
	grat.phase = 0;
	grat.orientation = PI/8;
	grat.to(buf[0]);

	Figures::ShaderExponentialDot dot;
	dot.setSigma(30);
	dot.factor = 1;
	dot.to(buf[1]);

	Figures::ShaderGabor gabor;
	gabor.setSigma(30);
	gabor.contrast = 1;
	gabor.wavelength = 30.0;
	gabor.phase = 0;
	gabor.orientation = PI/8;
	gabor.to(buf[2]);


	Figures::drawGratingToImage(reference[0], 240,240 , 1.0/30.0, 1, PI/8, 0);
	Figures::drawExponentialToImage(reference[1], 30, 1);
	Figures::drawGaborToImage(reference[2], 30, 1.0/30.0, 1, PI/8, 0);


	cnvs.clear(Color(0.25));
	for(int i=0; i<3; i++) {
		Figures::substructImages(difference[i], buf[i], reference[i], 64.0);
		buf[i].shift(50,50+i*300).draw();
		reference[i].shift(350,50+i*300).draw();
		difference[i].shift(650, 50+i*300).draw();
	}
/*
	const int DIFF = 2, SLINE = 120;
	difference2[DIFF].set(480,512);
	int y1, y2;
	for(int y=0; y<240; y++) {
		y1 = (int)(512-reference[DIFF].getPix(SLINE,y).getR()*512);
		y2 = (int)(512-buf[DIFF].getPix(SLINE,y).getR()*512);
		difference2[DIFF].rect(Psychlops::Rectangle(y*2, y1, y*2+1, 511), Color(0.4));
		if(y1>y2) difference2[DIFF].rect(Psychlops::Rectangle(y*2, y2, y*2+1, y1), Color::green);
		if(y1<y2) difference2[DIFF].rect(Psychlops::Rectangle(y*2, y1, y*2+1, y2), Color::red);
	}
	difference2[DIFF].centering().draw();
*/

	cnvs.flip();
	while(!Keyboard::esc.pushed()) {
	}
}

