﻿using System;
using System.Windows;


namespace Psychlops
{
	public static class StaticFunctions
	{
		public static T[] NewArray<T>(int x)
			where T : new()
		{
			T[] t = new T[x];
			for (int i = 0; i < x; i++)
			{
				t[i] = new T();
			}
			return t;
		}
		public static T[,] NewArray<T>(int x, int y)
			where T : new()
		{
			T[,] t = new T[x,y];
			for (int i = 0; i < x; i++)
			{
				for (int j = 0; j < x; j++)
				{
					t[i,j] = new T();
				}
			}
			return t;
		}
		public static T[,,] NewArray<T>(int x, int y, int z)
			where T : new()
		{
			T[,,] t = new T[x, y, z];
			for (int i = 0; i < x; i++)
			{
				for (int j = 0; j < y; j++)
				{
					for (int k = 0; k < z; k++)
					{
						t[i, j, k] = new T();
					}
				}
			}
			return t;
		}
	}

	public partial struct Point
	{
		public double x, y, z;
		public Point(double dx, double dy, double dz = 0.0)
		{
			x = dx;
			y = dy;
			z = dz;
		}
		public Point set(double dx, double dy, double dz = 0.0)
		{
			x = dx;
			y = dy;
			z = dz;
			return this;
		}

		public static Point operator +(Point lhs, Point rhs)
		{
			return new Point(lhs.x + rhs.x, lhs.y + rhs.y, lhs.z + rhs.z);
		}
		public static Point operator -(Point lhs, Point rhs)
		{
			return new Point(lhs.x - rhs.x, lhs.y - rhs.y, lhs.z - rhs.z);
		}
		public override string ToString()
		{
			return "X:"+ x.ToString() + " Y:"+ y.ToString() + " Z:"+ z.ToString();
		}
	}


	public partial struct Color
	{
		public double r, g, b, a;
		public Color(double lum)
		{
			r = g = b = lum;
			a = 1.0;
		}
		public Color(double red, double green, double blue, double alpha = 1.0)
		{
			r = red;
			g = green;
			b = blue;
			a = alpha;
		}
		public void set(double lum)
		{
			r = g = b = lum;
			a = 1.0;
		}
		public void set(double red, double green, double blue, double alpha = 1.0)
		{
			r = red;
			g = green;
			b = blue;
			a = alpha;
		}

		public override string ToString()
		{
			return "R:" + r.ToString() + " G:" + g.ToString() + " B:" + b.ToString() + " A:" + a.ToString();
		}

		public static readonly Color
			black = new Color(0, 0, 0, 1),
			red = new Color(1, 0, 0, 1),
			green = new Color(0, 1, 0, 1),
			blue = new Color(0, 0, 1, 1),
			yellow = new Color(1, 1, 0, 1),
			magenta = new Color(1, 0, 1, 1),
			cyan = new Color(0, 1, 1, 1),
			gray = new Color(.5, .5, .5, 1),
			white = new Color(1, 1, 1, 1),
			null_color = new Color(0, 0, 0, 0),
			transparent = new Color(0, 0, 0, 0);

	}


	public interface Drawable
	{
		Point getCenter();
		void clear(Color col);
		void pix(int x, int y, Color col);
		void line(Line drawee);
		void rect(Rectangle drawee);
		void ellipse(Ellipse drawee);
		void polygon(Polygon drawee);
		void letters(Letters drawee);
		void image(Image drawee);
		void group(Group drawee);
		void shader(ShaderField drawee);
		void msg(string s, double x, double y, Color c);
	}



	public interface Figure
	{
		Point datum { get; set; }
		Figure shift(Point p);
		Figure centering(Point p);
		void draw();
	}
	public static class FigureExtention
	{
		public static Point getDatum(this Figure target)
		{
			return target.datum;
		}
		public static Point setDatum(this Figure target, Point p)
		{
			target.datum = p;
			return target.datum;
		}
		public static Figure shift(this Figure target, double x, double y, double z = 0.0)
		{
			return target.shift(new Point(x, y, z));
		}
		public static Figure centering(this Figure target)
		{
			return target.centering(Main.drawable.getCenter());
		}
		public static Figure centering(this Figure target, double x, double y, double z = 0.0)
		{
			return target.centering(new Point(x, y, z));
		}
	}

	namespace Internal
	{
		public interface PrimitiveFigure : Figure
		{
			UIElement toNative();
			UIElement poolNative(Canvas c);
		}
	}

	public partial class Group : Internal.PrimitiveFigure
	{
		System.Collections.Generic.List<Figure> list;
		System.Windows.Controls.Canvas cnvs;
		System.Windows.Media.TransformGroup trans;
		System.Windows.Media.TransformCollection transF;
		System.Windows.Media.RotateTransform rotateF;
		SimpleProcedure setRotation_;
		System.Windows.Media.ScaleTransform scaleF;
		SimpleProcedure setScaling_;
		System.Windows.Media.TranslateTransform translateF;

		bool AsyncBool;
		double rotation_;
		public double rotation
		{
			get { return rotation_; }
			set { rotation_ = value; rotateF.Dispatcher.BeginInvoke(setRotation_); }
		}		
		public Point axis
		{
			get;
			set;
		}
		Point scaling_;
		public Point scaling
		{
			get { return scaling_; }
			set { scaling_ = value; scaleF.Dispatcher.BeginInvoke(setScaling_); }
		}

		AppendFunc1 append_;

		public Group()
		{
			setRotation_ = new SimpleProcedure(setRotation__);
			setScaling_ = new SimpleProcedure(setScaling__);
			append_ = new AppendFunc1(append__);
			list = new System.Collections.Generic.List<Figure>();
			AsyncBool = false;
			initialize__();
			while (!AsyncBool) { }
		}

		public Group append(Internal.PrimitiveFigure fig)
		{
			list.Add(fig);
			cnvs.Dispatcher.BeginInvoke(append_, fig);
			return this;
		}

		public Point datum { get; set; }
		public Figure shift(Point p)
		{
			datum = datum + p;
			return this;
		}
		public Figure centering(Point p)
		{
			datum = p;
			return this;
		}
		public void draw()
		{
			Main.drawable.group(this);
		}
	}



	public partial class ShaderField : Internal.PrimitiveFigure
	{
		public Point v1, v2;
		
		public ShaderField()
		{
			set(0,0);
		}
		public ShaderField(double wid, double hei)
		{
			initialized = false;
			set(wid, hei);
		}
		public ShaderField(Rectangle another)
		{
			v1 = another.v1;
			v2 = another.v2;
		}
		public ShaderField set(double wid, double hei)
		{
			v1.set(0, 0, 0);
			v2.set(wid, hei, 0);
			return this;
		}
		ShaderField set(Point po1, Point po2)
		{
			v1 = po1;
			v2 = po2;
			return this;
		}
		public ShaderField set(double l, double t, double r, double b)
		{
			v1.set(l, t, 0);
			v2.set(r, b, 0);
			return this;
		}
		public ShaderField set(ShaderField another)
		{
			v1 = another.v1;
			v2 = another.v2;
			return this;
		}

		public ShaderField resize(double width, double height)
		{
			Point po = center;
			set(width, height);
			centering(po);
			return this;
		}


		public Point datum
		{
			get { return v1; }
			set { double w = width, h = height; v1 = value; v2 = v1 + new Point(w,h); }
		}
		public ShaderField move_to(Point p) { datum = p; return this; }
		public ShaderField move_to(double x, double y, double z = 0.0) { datum = new Point(x, y, z); return this; }
		public ShaderField locate(Point p) { datum = p; return this; }
		public ShaderField locate(double x, double y, double z = 0.0) { datum = new Point(x, y, z); return this; }

		public Figure shift(Point p)
		{
			v1 += p;
			v2 += p;
			return this;
		}
		public Figure centering(Point p)
		{
			double h = width, v = height;
			v1.x = p.x - h / 2.0;
			v1.y = p.y - v / 2.0;
			v2.x = v1.x + h;
			v2.y = v1.y + v;
			return this;
		}

		public virtual void draw()
		{
			Main.drawable.shader(this);
		}

		internal Action setParameters = initialize___;
		internal Action initialize__ = initialize___;
		private static void initialize___() {}
		internal bool initialized = false;

		public double left { get { return v1.x; } }
		public double top { get { return v1.y; } }
		public double right { get { return v2.x; } }
		public double bottom { get { return v2.y; } }
		public double width { get { return Math.abs(v1.x - v2.x); } }
		public double height { get { return Math.abs(v1.y - v2.y); } }
		public Point center
		{
			get { return new Point((left + right) / 2, (top + bottom) / 2); }
			set { centering(value); }
		}
		public double getLeft() { return left; }
		public double getTop() { return top; }
		public double getRight() { return right; }
		public double getBottom() { return bottom; }
		public double getWidth() { return width; }
		public double getHeight() { return height; }
		public Point getCenter() { return center; }
	}

}