package zephyr.util;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class ZephyrUtil {

    static final HashMap<Character, String> uniChMap = new HashMap<Character, String>();

    static {
        uniChMap.put('Ā', "A");
        uniChMap.put('ā', "a");
        uniChMap.put('Ă', "A");
        uniChMap.put('ă', "a");
        uniChMap.put('ă', "a");
        uniChMap.put('Ē', "E");
        uniChMap.put('ē', "e");
        uniChMap.put('Ĕ', "E");
        uniChMap.put('ĕ', "e");
        uniChMap.put('Ī', "I");
        uniChMap.put('ī', "i");
        uniChMap.put('Ĭ', "I");
        uniChMap.put('ĭ', "i");
        uniChMap.put('Ō', "O");
        uniChMap.put('ō', "o");
        uniChMap.put('Ŏ', "O");
        uniChMap.put('ŏ', "o");
        uniChMap.put('Ū', "U");
        uniChMap.put('ū', "u");
        uniChMap.put('Ŭ', "U");
        uniChMap.put('ŭ', "u");
        uniChMap.put('Ȳ', "Y");
        uniChMap.put('ȳ', "y");
        uniChMap.put('˘', "");

        uniChMap.put('À', "A");
        uniChMap.put('Á', "A");
        uniChMap.put('Â', "A");
        uniChMap.put('Ã', "A");
        uniChMap.put('Ä', "A");
        uniChMap.put('Æ', "AE");
        uniChMap.put('Ç', "C");
        uniChMap.put('È', "E");
        uniChMap.put('É', "E");
        uniChMap.put('Ê', "E");
        uniChMap.put('Ë', "E");
        uniChMap.put('Ì', "I");
        uniChMap.put('Í', "I");
        uniChMap.put('Ï', "I");
        uniChMap.put('Î', "I");
        uniChMap.put('Ð', "D");
        uniChMap.put('Ñ', "N");
        uniChMap.put('Ò', "O");
        uniChMap.put('Ó', "O");
        uniChMap.put('Ô', "O");
        uniChMap.put('Õ', "O");
        uniChMap.put('Ö', "O");
        uniChMap.put('Ø', "O");
        uniChMap.put('Ù', "U");
        uniChMap.put('Ú', "U");
        uniChMap.put('Û', "U");
        uniChMap.put('Ü', "U");
        uniChMap.put('Ý', "Y");

        uniChMap.put('à', "a");
        uniChMap.put('á', "a");
        uniChMap.put('â', "a");
        uniChMap.put('ã', "a");
        uniChMap.put('ä', "a");
        uniChMap.put('å', "a");
        uniChMap.put('æ', "ae");
        uniChMap.put('ç', "c");
        uniChMap.put('è', "e");
        uniChMap.put('é', "e");
        uniChMap.put('ê', "e");
        uniChMap.put('ë', "e");
        uniChMap.put('ì', "i");
        uniChMap.put('í', "i");
        uniChMap.put('î', "i");
        uniChMap.put('ï', "i");
        uniChMap.put('ñ', "n");
        uniChMap.put('ò', "o");
        uniChMap.put('ó', "o");
        uniChMap.put('ô', "o");
        uniChMap.put('õ', "o");
        uniChMap.put('ö', "o");
        uniChMap.put('ø', "o");
        uniChMap.put('ù', "u");
        uniChMap.put('ú', "u");
        uniChMap.put('û', "u");
        uniChMap.put('ü', "u");
        uniChMap.put('ý', "y");
        uniChMap.put('ÿ', "y");
    }

    public static String dropMarks(char c) {
        String s = uniChMap.get(c);
        if (s != null) {
            return s;
        } else {
            return Character.toString(c);
        }
    }

    public static String dropMarks(String txt) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < txt.length(); i++) {
            char c = txt.charAt(i);
            String s = uniChMap.get(c);
            if (s != null) {
                sb.append(s);
            } else {
                sb.append(c);
            }
        }
        return sb.toString();
    }

    public static String dropTailDigit(String word) {
        if (Character.isDigit(word.charAt(word.length() - 1))) {
            return word.substring(0, word.length() - 1);
        } else {
            return word;
        }
    }

    public static String hex2uni(String txt) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < txt.length()) {
            char c = txt.charAt(i);
            if (c == '&' && txt.substring(i).startsWith("&#x")) {
                int k = txt.indexOf(';', i + 1);
                if (k > 0) {
                    int code = Integer.parseInt(txt.substring(i + 3, k), 16);
                    sb.append((char) code);
                    i = k + 1;
                    continue;
                }
            }
            sb.append(c);
            i++;
        }
        return sb.toString();
    }

    public static String makeKey(String word, boolean bDropTailDigit) {
        if (bDropTailDigit) {
            word = dropTailDigit(word);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < word.length(); i++) {
            sb.append(dropMarks(word.charAt(i)));
        }
        return sb.toString().toLowerCase();
    }

    public static String makeKey(String word) {
        return makeKey(word, true);
    }

    // 文字コードは　"Shift_JIS" ではなくて "Windows-31J" を使うこと。
    // "～" を Shift_JIS で出力すると、？になってしまう。
    // WAVE DASH問題（TILDE問題）
    // http://park3.wakwak.com/~ozashin/sw_tips/webapp_tips/sjis_charset.html
    public static final String SHIFT_JIS_CODE = "Windows-31J";

    public static void setShiftJisOuput() {
        try {
            PrintStream p = new PrintStream(System.out, true, SHIFT_JIS_CODE);
            System.setOut(p);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void setUTF8Ouput() {
        try {
            PrintStream p = new PrintStream(System.out, true, "UTF-8");
            System.setOut(p);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String sed(String line, String[][] replaces, String[][] regReplaces) {
        if (replaces != null) {
            for (int i = 0; i < replaces.length; i++) {
                line = line.replace(replaces[i][0], replaces[i][1]);
            }
        }
        if (regReplaces != null) {
            for (int i = 0; i < regReplaces.length; i++) {
                line = line.replaceAll(regReplaces[i][0], regReplaces[i][1]);
            }
        }
        return line;
    }

}
